/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS.dlg.spots;

import icy.gui.util.FontUtil;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import plugins.fmp.multiSPOTS.MultiSPOTS;
import plugins.fmp.multiSPOTS.experiment.Experiment;

public class LoadSaveSpots
extends JPanel {
    private static final long serialVersionUID = -4019075448319252245L;
    private JButton loadButton = new JButton("Load...");
    private JButton saveButton = new JButton("Save...");
    private MultiSPOTS parent0 = null;

    void init(GridLayout capLayout, MultiSPOTS parent0) {
        this.setLayout(capLayout);
        JLabel loadsaveText = new JLabel("-> Spots, polylines (xml) ", 4);
        loadsaveText.setFont(FontUtil.setStyle((Font)loadsaveText.getFont(), (int)2));
        FlowLayout flowLayout = new FlowLayout(2);
        flowLayout.setVgap(0);
        JPanel panel1 = new JPanel(flowLayout);
        panel1.add(loadsaveText);
        panel1.add(this.loadButton);
        panel1.add(this.saveButton);
        panel1.validate();
        this.add(panel1);
        this.parent0 = parent0;
        this.defineActionListeners();
    }

    private void defineActionListeners() {
        this.loadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((LoadSaveSpots)LoadSaveSpots.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    LoadSaveSpots.this.loadSpotsArray_File(exp);
                    LoadSaveSpots.this.loadCagesArray_File(exp);
                    LoadSaveSpots.this.firePropertyChange("SPOTS_ROIS_OPEN", false, true);
                }
            }
        });
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((LoadSaveSpots)LoadSaveSpots.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    LoadSaveSpots.this.saveSpotsArray_file(exp);
                    LoadSaveSpots.this.saveCagesArray_File(exp);
                    LoadSaveSpots.this.firePropertyChange("SPOTS_ROIS_SAVE", false, true);
                }
            }
        });
    }

    public boolean loadSpotsArray_File(Experiment exp) {
        boolean flag = exp.load_Spots();
        exp.spotsArray.transferSpotsToSequenceAsROIs(exp.seqCamData.seq);
        return flag;
    }

    public boolean saveSpotsArray_file(Experiment exp) {
        this.parent0.dlgExperiment.getExperimentInfosFromDialog(exp);
        boolean flag = exp.saveXML_MCExperiment();
        exp.spotsArray.transferROIsFromSequenceToSpots(exp.seqCamData.seq);
        flag &= exp.save_MCSpots_Only();
        return flag &= exp.save_SpotsMeasures();
    }

    public boolean loadCagesArray_File(Experiment exp) {
        boolean flag = exp.load_Cages();
        if (flag) {
            exp.cagesArray.transferCagesToSequenceAsROIs(exp.seqCamData.seq);
        }
        return flag;
    }

    public boolean saveCagesArray_File(Experiment exp) {
        boolean flag = false;
        if (exp != null) {
            exp.cagesArray.transferROIsFromSequenceToCages(exp.seqCamData.seq);
            flag = exp.save_CagesMeasures();
        }
        return flag;
    }
}

