/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS.dlg.spots;

import icy.gui.frame.IcyFrame;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import plugins.fmp.multiSPOTS.MultiSPOTS;
import plugins.fmp.multiSPOTS.experiment.Experiment;
import plugins.fmp.multiSPOTS.experiment.spots.Spot;
import plugins.fmp.multiSPOTS.tools.JComponents.TableModelSpot;

public class SpotTablePanel
extends JPanel {
    private static final long serialVersionUID = -8611587540329642259L;
    IcyFrame dialogFrame = null;
    private JTable jTable = new JTable();
    private TableModelSpot spotTableModel = null;
    private JButton copyButton = new JButton("Copy table");
    private JButton pasteButton = new JButton("Paste");
    private JButton duplicateLRButton = new JButton("Duplicate cell to pos");
    private JButton duplicateCageButton = new JButton("Duplicate cage stim");
    private JButton exchangeLRButton = new JButton("Exchg L/R");
    private JButton duplicateAllButton = new JButton("Duplicate cell to all");
    private JButton getNfliesButton = new JButton("Get n flies from cage");
    private JButton setCageNoButton = new JButton("Set cage n#");
    private JButton nPixelsButton = new JButton("Get n pixels");
    private MultiSPOTS parent0 = null;
    private List<Spot> spotsArrayCopy = null;

    public void initialize(MultiSPOTS parent0, List<Spot> spotCopy) {
        this.parent0 = parent0;
        this.spotsArrayCopy = spotCopy;
        this.spotTableModel = new TableModelSpot(parent0.expListCombo);
        this.jTable.setModel(this.spotTableModel);
        this.jTable.setSelectionMode(0);
        this.jTable.setPreferredScrollableViewportSize(new Dimension(500, 400));
        this.jTable.setFillsViewportHeight(true);
        TableColumnModel columnModel = this.jTable.getColumnModel();
        DefaultTableCellRenderer centerRenderer = new DefaultTableCellRenderer();
        centerRenderer.setHorizontalAlignment(0);
        for (int i = 0; i < this.spotTableModel.getColumnCount(); ++i) {
            TableColumn col = columnModel.getColumn(i);
            col.setCellRenderer(centerRenderer);
        }
        columnModel.getColumn(0).setPreferredWidth(25);
        columnModel.getColumn(1).setPreferredWidth(15);
        columnModel.getColumn(2).setPreferredWidth(15);
        columnModel.getColumn(3).setPreferredWidth(15);
        columnModel.getColumn(4).setPreferredWidth(25);
        columnModel.getColumn(5).setPreferredWidth(15);
        JScrollPane scrollPane = new JScrollPane(this.jTable);
        JPanel topPanel = new JPanel(new GridLayout(2, 1));
        FlowLayout flowLayout = new FlowLayout(0);
        JPanel panel1 = new JPanel(flowLayout);
        panel1.add(this.copyButton);
        panel1.add(this.pasteButton);
        panel1.add(this.duplicateLRButton);
        panel1.add(this.duplicateAllButton);
        panel1.add(this.exchangeLRButton);
        topPanel.add(panel1);
        JPanel panel2 = new JPanel(flowLayout);
        panel2.add(this.setCageNoButton);
        panel2.add(this.getNfliesButton);
        panel2.add(this.nPixelsButton);
        panel2.add(this.duplicateCageButton);
        topPanel.add(panel2);
        JPanel tablePanel = new JPanel();
        tablePanel.add(scrollPane);
        this.dialogFrame = new IcyFrame("Spots properties", true, true);
        this.dialogFrame.add((Component)topPanel, (Object)"North");
        this.dialogFrame.add((Component)tablePanel, (Object)"Center");
        this.dialogFrame.pack();
        this.dialogFrame.addToDesktopPane();
        this.dialogFrame.requestFocus();
        this.dialogFrame.center();
        this.dialogFrame.setVisible(true);
        this.defineActionListeners();
        this.pasteButton.setEnabled(this.spotsArrayCopy.size() > 0);
    }

    private void defineActionListeners() {
        this.copyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((SpotTablePanel)SpotTablePanel.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    SpotTablePanel.this.copyInfos(exp);
                }
            }
        });
        this.pasteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((SpotTablePanel)SpotTablePanel.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    SpotTablePanel.this.pasteInfos(exp);
                }
                SpotTablePanel.this.spotTableModel.fireTableDataChanged();
            }
        });
        this.nPixelsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((SpotTablePanel)SpotTablePanel.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    SpotTablePanel.this.setSpotsNPixels(exp);
                    SpotTablePanel.this.spotTableModel.fireTableDataChanged();
                }
            }
        });
        this.duplicateLRButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((SpotTablePanel)SpotTablePanel.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    SpotTablePanel.this.duplicateLR(exp);
                }
            }
        });
        this.duplicateCageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((SpotTablePanel)SpotTablePanel.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    SpotTablePanel.this.duplicateCage(exp);
                }
            }
        });
        this.exchangeLRButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((SpotTablePanel)SpotTablePanel.this).parent0.expListCombo.getSelectedItem();
                if (exp == null || exp.spotsArray.nColumnsPerCage * exp.spotsArray.nRowsPerCage != 2) {
                    return;
                }
                SpotTablePanel.this.exchangeLR(exp);
            }
        });
        this.duplicateAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((SpotTablePanel)SpotTablePanel.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    SpotTablePanel.this.duplicateAll(exp);
                }
            }
        });
        this.getNfliesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((SpotTablePanel)SpotTablePanel.this).parent0.expListCombo.getSelectedItem();
                if (exp != null && exp.cagesArray.cagesList.size() > 0) {
                    exp.cagesArray.transferNFliesFromCagesToSpots(exp.spotsArray);
                    SpotTablePanel.this.spotTableModel.fireTableDataChanged();
                }
            }
        });
        this.setCageNoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((SpotTablePanel)SpotTablePanel.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    exp.cagesArray.setCageNbFromSpotsArray(exp.spotsArray);
                    SpotTablePanel.this.spotTableModel.fireTableDataChanged();
                }
            }
        });
    }

    void close() {
        this.dialogFrame.close();
    }

    private void exchangeLR(Experiment exp) {
        int columnIndex = this.jTable.getSelectedColumn();
        if (columnIndex < 0) {
            columnIndex = 5;
        }
        int side0 = exp.spotsArray.spotsList.get((int)0).cagePosition;
        Spot spot0 = new Spot();
        spot0.copySpot(exp.spotsArray.spotsList.get(0));
        Spot spot1 = new Spot();
        spot1.copySpot(exp.spotsArray.spotsList.get(1));
        for (Spot spot : exp.spotsArray.spotsList) {
            if (spot.cagePosition == side0) {
                this.copySingleSpotValue(spot1, spot, columnIndex);
                continue;
            }
            this.copySingleSpotValue(spot0, spot, columnIndex);
        }
    }

    private void copySingleSpotValue(Spot spotFrom, Spot spotTo, int columnIndex) {
        switch (columnIndex) {
            case 3: {
                spotTo.spotNFlies = spotFrom.spotNFlies;
                break;
            }
            case 4: {
                spotTo.spotNPixels = spotFrom.spotNPixels;
                break;
            }
            case 5: {
                spotTo.spotVolume = spotFrom.spotVolume;
                break;
            }
            case 6: {
                spotTo.spotStim = spotFrom.spotStim;
                break;
            }
            case 7: {
                spotTo.spotConc = spotFrom.spotConc;
                break;
            }
        }
    }

    private void copyInfos(Experiment exp) {
        this.spotsArrayCopy.clear();
        for (Spot spot : exp.spotsArray.spotsList) {
            this.spotsArrayCopy.add(spot);
        }
        this.pasteButton.setEnabled(true);
    }

    private void pasteInfos(Experiment exp) {
        for (Spot spotFrom : this.spotsArrayCopy) {
            spotFrom.valid = false;
            for (Spot spotTo : exp.spotsArray.spotsList) {
                if (!spotFrom.getRoi().getName().equals(spotTo.getRoi().getName())) continue;
                spotFrom.valid = true;
                spotTo.cageID = spotFrom.cageID;
                spotTo.cagePosition = spotFrom.cagePosition;
                spotTo.spotNFlies = spotFrom.spotNFlies;
                spotTo.spotStim = spotFrom.spotStim;
                spotTo.spotConc = spotFrom.spotConc;
            }
        }
    }

    private void setSpotsNPixels(Experiment exp) {
        for (Spot spot : exp.spotsArray.spotsList) {
            try {
                spot.spotNPixels = (int)spot.getRoi().getNumberOfPoints();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private void duplicateLR(Experiment exp) {
        int rowIndex = this.jTable.getSelectedRow();
        int columnIndex = this.jTable.getSelectedColumn();
        if (rowIndex < 0) {
            return;
        }
        Spot spot0 = exp.spotsArray.spotsList.get(rowIndex);
        int cageIndex = spot0.cagePosition;
        for (Spot spot : exp.spotsArray.spotsList) {
            if (spot.getRoi().getName().equals(spot0.getRoi().getName()) || spot.cagePosition != cageIndex) continue;
            switch (columnIndex) {
                case 3: {
                    spot.spotNFlies = spot0.spotNFlies;
                    break;
                }
                case 4: {
                    spot.spotNPixels = spot0.spotNPixels;
                    break;
                }
                case 5: {
                    spot.spotVolume = spot0.spotVolume;
                    break;
                }
                case 6: {
                    spot.spotStim = spot0.spotStim;
                    break;
                }
                case 7: {
                    spot.spotConc = spot0.spotConc;
                    break;
                }
            }
        }
    }

    private void duplicateAll(Experiment exp) {
        int rowIndex = this.jTable.getSelectedRow();
        int columnIndex = this.jTable.getSelectedColumn();
        if (rowIndex < 0) {
            return;
        }
        Spot spotFrom = exp.spotsArray.spotsList.get(rowIndex);
        for (Spot spot : exp.spotsArray.spotsList) {
            if (spot.getRoi().getName().equals(spotFrom.getRoi().getName())) continue;
            switch (columnIndex) {
                case 3: {
                    spot.spotNFlies = spotFrom.spotNFlies;
                    break;
                }
                case 4: {
                    spot.spotNPixels = spotFrom.spotNPixels;
                    break;
                }
                case 5: {
                    spot.spotVolume = spotFrom.spotVolume;
                    break;
                }
                case 6: {
                    spot.spotStim = spotFrom.spotStim;
                    break;
                }
                case 7: {
                    spot.spotConc = spotFrom.spotConc;
                    break;
                }
            }
        }
    }

    private void duplicateCage(Experiment exp) {
        int rowIndex = this.jTable.getSelectedRow();
        int columnIndex = this.jTable.getSelectedColumn();
        if (rowIndex < 0) {
            return;
        }
        Spot spotFrom = exp.spotsArray.spotsList.get(rowIndex);
        int cageFrom = spotFrom.cageID;
        int cageTo = -1;
        int nSpotsPerCage = this.getCageNSpots(exp, cageFrom);
        int indexFirstSpotOfCageFrom = this.getIndexFirstSpotOfCage(exp, cageFrom);
        int indexFirstSpotOfCageTo = -1;
        block7: for (int i = 0; i < exp.spotsArray.spotsList.size(); ++i) {
            Spot spot = exp.spotsArray.spotsList.get(i);
            if (spot.cageID == cageFrom) continue;
            if (spot.cageID != cageTo) {
                cageTo = spot.cageID;
                indexFirstSpotOfCageTo = this.getIndexFirstSpotOfCage(exp, cageTo);
            }
            if (this.getCageNSpots(exp, spot.cageID) != nSpotsPerCage) continue;
            int indexFrom = i - indexFirstSpotOfCageTo + indexFirstSpotOfCageFrom;
            Spot spot0 = exp.spotsArray.spotsList.get(indexFrom);
            switch (columnIndex) {
                case 3: {
                    spot.spotNFlies = spot0.spotNFlies;
                    continue block7;
                }
                case 4: {
                    spot.spotNPixels = spot0.spotNPixels;
                    continue block7;
                }
                case 5: {
                    spot.spotVolume = spot0.spotVolume;
                    continue block7;
                }
                case 6: {
                    spot.spotStim = spot0.spotStim;
                    continue block7;
                }
                case 7: {
                    spot.spotConc = spot0.spotConc;
                    continue block7;
                }
            }
        }
    }

    private int getCageNSpots(Experiment exp, int cageID) {
        int nSpots = 0;
        for (Spot spot : exp.spotsArray.spotsList) {
            if (spot.cageID != cageID) continue;
            ++nSpots;
        }
        return nSpots;
    }

    private int getIndexFirstSpotOfCage(Experiment exp, int cageID) {
        int index = -1;
        for (int i = 0; i < exp.spotsArray.spotsList.size(); ++i) {
            Spot spot = exp.spotsArray.spotsList.get(i);
            if (spot.cageID != cageID) continue;
            index = i;
            break;
        }
        return index;
    }
}

