/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS.dlg.spots;

import icy.gui.component.PopupPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import plugins.fmp.multiSPOTS.MultiSPOTS;
import plugins.fmp.multiSPOTS.dlg.spots.CreateCages;
import plugins.fmp.multiSPOTS.dlg.spots.CreateSpots;
import plugins.fmp.multiSPOTS.dlg.spots.DetectContours;
import plugins.fmp.multiSPOTS.dlg.spots.Edit;
import plugins.fmp.multiSPOTS.dlg.spots.Infos;
import plugins.fmp.multiSPOTS.dlg.spots.LoadSaveSpots;
import plugins.fmp.multiSPOTS.experiment.Experiment;
import plugins.fmp.multiSPOTS.experiment.ExperimentUtils;

public class _DlgSpots_
extends JPanel
implements PropertyChangeListener,
ChangeListener {
    private static final long serialVersionUID = 853047648249832145L;
    public PopupPanel capPopupPanel = null;
    JTabbedPane tabbedPane = new JTabbedPane();
    CreateCages tabCreateCages = new CreateCages();
    CreateSpots tabCreateSpots = new CreateSpots();
    Infos tabInfos = new Infos();
    DetectContours tabShape = new DetectContours();
    Edit tabEdit = new Edit();
    public LoadSaveSpots tabFile = new LoadSaveSpots();
    private int id_shape = 1;
    private int id_infos = 1;
    private int id_create = 0;
    private MultiSPOTS parent0 = null;

    public void init(JPanel mainPanel, String string, final MultiSPOTS parent0) {
        this.parent0 = parent0;
        this.capPopupPanel = new PopupPanel(string);
        JPanel capPanel = this.capPopupPanel.getMainPanel();
        capPanel.setLayout(new BorderLayout());
        this.capPopupPanel.collapse();
        mainPanel.add((Component)this.capPopupPanel);
        GridLayout gridLayout = new GridLayout(3, 1);
        int order = 0;
        this.tabCreateCages.init(gridLayout, parent0);
        this.tabCreateCages.addPropertyChangeListener(this);
        this.tabbedPane.addTab("Cages", null, this.tabCreateCages, "Create cages");
        this.id_create = order++;
        this.tabCreateSpots.init(gridLayout, parent0);
        this.tabCreateSpots.addPropertyChangeListener(this);
        this.tabbedPane.addTab("(old spots)", null, this.tabCreateSpots, "Create spots defining liquid drops without reference to cages");
        this.id_create = order++;
        this.tabInfos.init(gridLayout, parent0);
        this.tabInfos.addPropertyChangeListener(this);
        this.tabbedPane.addTab("Infos", null, this.tabInfos, "Edit infos");
        this.id_infos = order++;
        this.tabShape.init(gridLayout, parent0);
        this.tabShape.addPropertyChangeListener(this);
        this.tabbedPane.addTab("Shape", null, this.tabShape, "Edit spots shape");
        this.id_shape = order++;
        this.tabEdit.init(gridLayout, parent0);
        this.tabEdit.addPropertyChangeListener(this);
        this.tabbedPane.addTab("Edit", null, this.tabEdit, "Edit spots position with time");
        ++order;
        this.tabFile.init(gridLayout, parent0);
        this.tabFile.addPropertyChangeListener(this);
        this.tabbedPane.addTab("Load/Save", null, this.tabFile, "Load/Save cage & spots descriptors (xml file)");
        ++order;
        this.tabbedPane.setTabLayoutPolicy(1);
        capPanel.add(this.tabbedPane);
        this.tabbedPane.addChangeListener(this);
        this.capPopupPanel.addComponentListener((ComponentListener)new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                parent0.mainFrame.revalidate();
                parent0.mainFrame.pack();
                parent0.mainFrame.repaint();
            }
        });
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (event.getPropertyName().equals("SPOTS_ROIS_OPEN")) {
            Experiment exp = (Experiment)this.parent0.expListCombo.getSelectedItem();
            if (exp != null) {
                this.displaySpotsInformation(exp);
                this.tabbedPane.setSelectedIndex(this.id_infos);
                this.parent0.dlgExperiment.tabIntervals.getExptParms(exp);
                this.tabCreateCages.updateNColumnsFieldFromSequence();
            }
        } else if (event.getPropertyName().equals("CAP_ROIS_SAVE")) {
            this.tabbedPane.setSelectedIndex(this.id_shape);
        }
    }

    public void displaySpotsInformation(final Experiment exp) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                _DlgSpots_.this.updateDialogs(exp);
                ((_DlgSpots_)_DlgSpots_.this).parent0.dlgExperiment.tabOptions.viewSpotsCheckBox.setSelected(true);
            }
        });
    }

    public void updateDialogs(Experiment exp) {
        if (exp != null) {
            ExperimentUtils.transferSpotsToCamDataSequence(exp);
            this.tabCreateSpots.updateDialog(exp);
            this.tabCreateCages.updateNColumnsFieldFromSequence();
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        JTabbedPane tabbedPane = (JTabbedPane)e.getSource();
        int selectedIndex = tabbedPane.getSelectedIndex();
        Experiment exp = (Experiment)this.parent0.expListCombo.getSelectedItem();
        if (exp != null) {
            boolean displayCapillaries = selectedIndex == this.id_create;
            exp.seqCamData.displaySpecificROIs(displayCapillaries, "line");
            exp.seqCamData.displaySpecificROIs(true, "spots");
        }
    }
}

