/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS.dlg.spotsMeasures;

import icy.roi.ROI2D;
import icy.util.StringUtil;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import plugins.fmp.multiSPOTS.MultiSPOTS;
import plugins.fmp.multiSPOTS.experiment.Experiment;
import plugins.fmp.multiSPOTS.experiment.SequenceKymos;
import plugins.fmp.multiSPOTS.experiment.spots.Spot;
import plugins.fmp.multiSPOTS.experiment.spots.SpotMeasure;
import plugins.fmp.multiSPOTS.series.BuildMedianFromSpotMeasure;
import plugins.fmp.multiSPOTS.series.BuildSeriesOptions;

public class SpotsMeasuresEdit
extends JPanel
implements PropertyChangeListener {
    private static final long serialVersionUID = 2580935598417087197L;
    private JComboBox<String> roiTypeCombo = new JComboBox<String>(new String[]{"sum", "clean", "fly present/absent"});
    private JButton cutAndInterpolateButton = new JButton("Cut & interpolate");
    private JButton compensateButton = new JButton("Compensate (poop deposit)");
    private JComboBox<String> directionCombo = new JComboBox<String>(new String[]{"up", "down"});
    private String buildMedianString = "Build median";
    private JButton buildMedianButton = new JButton(this.buildMedianString);
    private JCheckBox allSeriesCheckBox = new JCheckBox("ALL (current to last)", false);
    private BuildMedianFromSpotMeasure threadbuildMedian = null;
    private MultiSPOTS parent0 = null;

    void init(GridLayout capLayout, MultiSPOTS parent0) {
        this.setLayout(capLayout);
        this.parent0 = parent0;
        FlowLayout layoutLeft = new FlowLayout(0);
        layoutLeft.setVgap(0);
        JPanel panel1 = new JPanel(layoutLeft);
        panel1.add(this.cutAndInterpolateButton);
        panel1.add(new JLabel("Apply to ", 2));
        panel1.add(this.roiTypeCombo);
        this.add(panel1);
        JPanel panel2 = new JPanel(layoutLeft);
        panel2.add(this.compensateButton);
        panel2.add(this.directionCombo);
        this.add(panel2);
        JPanel panel3 = new JPanel(layoutLeft);
        panel3.add(this.buildMedianButton);
        panel3.add(this.allSeriesCheckBox);
        this.add(panel3);
        this.roiTypeCombo.setSelectedIndex(1);
        this.defineListeners();
    }

    private void defineListeners() {
        this.cutAndInterpolateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((SpotsMeasuresEdit)SpotsMeasuresEdit.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    SpotsMeasuresEdit.this.cutAndInterpolate(exp);
                }
            }
        });
        this.compensateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((SpotsMeasuresEdit)SpotsMeasuresEdit.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    SpotsMeasuresEdit.this.compensate(exp);
                }
            }
        });
        this.buildMedianButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SpotsMeasuresEdit.this.buildMedianButton.getText().equals(SpotsMeasuresEdit.this.buildMedianString)) {
                    SpotsMeasuresEdit.this.startDetection();
                } else {
                    SpotsMeasuresEdit.this.stopDetection();
                }
            }
        });
    }

    void startDetection() {
        Experiment exp = (Experiment)this.parent0.expListCombo.getSelectedItem();
        if (exp != null) {
            this.threadbuildMedian = new BuildMedianFromSpotMeasure();
            this.threadbuildMedian.options = this.initDetectOptions(exp);
            this.threadbuildMedian.addPropertyChangeListener(this);
            this.threadbuildMedian.execute();
            this.buildMedianButton.setText("STOP");
        }
    }

    private void stopDetection() {
        if (this.threadbuildMedian != null && !this.threadbuildMedian.stopFlag) {
            this.threadbuildMedian.stopFlag = true;
        }
    }

    private BuildSeriesOptions initDetectOptions(Experiment exp) {
        BuildSeriesOptions options = new BuildSeriesOptions();
        options.expList = this.parent0.expListCombo;
        options.expList.index0 = this.parent0.expListCombo.getSelectedIndex();
        options.expList.index1 = this.allSeriesCheckBox.isSelected() ? options.expList.getItemCount() - 1 : this.parent0.expListCombo.getSelectedIndex();
        options.detectAllSeries = this.allSeriesCheckBox.isSelected();
        if (!this.allSeriesCheckBox.isSelected()) {
            options.seriesLast = options.seriesFirst;
        } else {
            options.seriesFirst = 0;
        }
        return options;
    }

    void cutAndInterpolate(Experiment exp) {
        SequenceKymos seqKymos = exp.seqSpotKymos;
        ROI2D roiRect = seqKymos.seq.getSelectedROI2D();
        if (roiRect == null) {
            return;
        }
        int t = seqKymos.seq.getFirstViewer().getPositionT();
        Spot spot = exp.spotsArray.spotsList.get(t);
        String optionSelected = (String)this.roiTypeCombo.getSelectedItem();
        if (optionSelected.contains("sum")) {
            this.removeAndUpdate(seqKymos, spot, spot.sum_in, roiRect);
        } else if (optionSelected.contains("clean")) {
            this.removeAndUpdate(seqKymos, spot, spot.sum_clean, roiRect);
        } else if (optionSelected.contains("fly")) {
            this.removeAndUpdate(seqKymos, spot, spot.flyPresent, roiRect);
        }
    }

    void compensate(Experiment exp) {
        SequenceKymos seqKymos = exp.seqSpotKymos;
        ROI2D roiRect = seqKymos.seq.getSelectedROI2D();
        if (roiRect == null) {
            return;
        }
        int t = seqKymos.seq.getFirstViewer().getPositionT();
        Spot spot = exp.spotsArray.spotsList.get(t);
        String optionSelected = (String)this.roiTypeCombo.getSelectedItem();
        if (optionSelected.contains("sum")) {
            this.compensateAndUpdate(seqKymos, spot, spot.sum_in, roiRect);
        } else if (optionSelected.contains("clean")) {
            this.compensateAndUpdate(seqKymos, spot, spot.sum_clean, roiRect);
        } else if (optionSelected.contains("fly")) {
            this.compensateAndUpdate(seqKymos, spot, spot.flyPresent, roiRect);
        }
    }

    private void removeAndUpdate(SequenceKymos seqKymos, Spot spot, SpotMeasure spotMeasure, ROI2D roi) {
        spotMeasure.cutAndInterpolatePointsEnclosedInSelectedRoi(roi);
        spotMeasure.transferROItoLevel2D();
    }

    private void compensateAndUpdate(SequenceKymos seqKymos, Spot spot, SpotMeasure spotMeasure, ROI2D roi) {
        boolean bAdd = this.directionCombo.getSelectedIndex() == 0;
        spotMeasure.compensateOffetUsingSelectedRoi(roi, bAdd);
        spotMeasure.transferROItoLevel2D();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (StringUtil.equals((String)"thread_ended", (String)evt.getPropertyName())) {
            this.buildMedianButton.setText(this.buildMedianString);
            Experiment exp = (Experiment)this.parent0.expListCombo.getSelectedItem();
            if (exp != null) {
                exp.load_SpotsMeasures();
                this.parent0.dlgMeasure.tabGraphs.displayGraphsPanels(exp);
            }
        }
    }
}

