/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS.experiment;

import icy.roi.ROI;
import java.util.Iterator;
import java.util.List;
import plugins.fmp.multiSPOTS.experiment.Experiment;
import plugins.fmp.multiSPOTS.experiment.cages.Cage;
import plugins.fmp.multiSPOTS.experiment.spots.Spot;
import plugins.fmp.multiSPOTS.experiment.spots.SpotsArray;
import plugins.fmp.multiSPOTS.tools.ROI2D.ROIUtilities;
import plugins.kernel.roi.roi2d.ROI2DPolygon;
import plugins.kernel.roi.roi2d.ROI2DShape;

public class ExperimentUtils {
    public static void transferCamDataROIStoSpots(Experiment exp) {
        boolean found;
        if (exp.spotsArray == null) {
            exp.spotsArray = new SpotsArray();
        }
        List<ROI> listROISCap = ROIUtilities.getROIsContainingString("spot", exp.seqCamData.seq);
        for (ROI roi : listROISCap) {
            found = false;
            for (Spot spot : exp.spotsArray.spotsList) {
                if (spot.getRoi() == null || !roi.getName().equals(spot.getRoi().getName())) continue;
                found = true;
                break;
            }
            if (found) continue;
            ROI2DPolygon roi_new = new ROI2DPolygon();
            exp.spotsArray.spotsList.add(new Spot((ROI2DShape)roi_new));
        }
        Iterator<Spot> iterator = exp.spotsArray.spotsList.iterator();
        while (iterator.hasNext()) {
            Spot spot = iterator.next();
            found = false;
            for (ROI roi : listROISCap) {
                if (!roi.getName().equals(spot.getRoi().getName())) continue;
                found = true;
                break;
            }
            if (found) continue;
            iterator.remove();
        }
    }

    public static void transferSpotsToCamDataSequence(Experiment exp) {
        if (exp.spotsArray == null) {
            return;
        }
        List<ROI> listROISSpots = ROIUtilities.getROIsContainingString("spot", exp.seqCamData.seq);
        for (Spot spot : exp.spotsArray.spotsList) {
            boolean found = false;
            for (ROI roi : listROISSpots) {
                if (!roi.getName().equals(spot.getRoi().getName())) continue;
                found = true;
                break;
            }
            if (found) continue;
            exp.seqCamData.seq.addROI((ROI)spot.getRoi());
        }
    }

    public static void transferCagesToCamDataSequence(Experiment exp) {
        if (exp.spotsArray == null) {
            return;
        }
        List<ROI> roisAlreadyTransferred = ROIUtilities.getROIsContainingString("cage", exp.seqCamData.seq);
        for (Cage cage : exp.cagesArray.cagesList) {
            boolean found = false;
            for (ROI roi : roisAlreadyTransferred) {
                if (!roi.getName().equals(cage.getRoi().getName())) continue;
                found = true;
                break;
            }
            if (found) continue;
            exp.seqCamData.seq.addROI((ROI)cage.getRoi());
        }
    }
}

