/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS.experiment;

import icy.common.exception.UnsupportedFormatException;
import icy.file.Loader;
import icy.file.Saver;
import icy.gui.frame.progress.ProgressFrame;
import icy.image.IcyBufferedImage;
import icy.roi.ROI2D;
import icy.sequence.MetaDataUtil;
import icy.type.DataType;
import icy.type.collection.array.Array1DUtil;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import loci.formats.FormatException;
import ome.xml.meta.OMEXMLMetadata;
import plugins.fmp.multiSPOTS.experiment.EnumStatus;
import plugins.fmp.multiSPOTS.experiment.ExperimentDirectories;
import plugins.fmp.multiSPOTS.experiment.ImageFileDescriptor;
import plugins.fmp.multiSPOTS.experiment.SequenceCamData;
import plugins.fmp.multiSPOTS.experiment.spots.SpotsArray;
import plugins.fmp.multiSPOTS.tools.Comparators;
import plugins.fmp.multiSPOTS.tools.ROI2D.ROI2DUtilities;
import plugins.kernel.roi.roi2d.ROI2DPolyLine;

public class SequenceKymos
extends SequenceCamData {
    public boolean isRunning_loadImages = false;
    public int imageWidthMax = 0;
    public int imageHeightMax = 0;

    public SequenceKymos() {
        this.status = EnumStatus.KYMOGRAPH;
    }

    public SequenceKymos(String name, IcyBufferedImage image) {
        super(name, image);
        this.status = EnumStatus.KYMOGRAPH;
    }

    public SequenceKymos(List<String> listNames) {
        this.setImagesList(listNames);
        this.status = EnumStatus.KYMOGRAPH;
    }

    public void validateRois() {
        ArrayList listRois = this.seq.getROI2Ds();
        int width = this.seq.getWidth();
        for (ROI2D roi : listRois) {
            if (!(roi instanceof ROI2DPolyLine)) continue;
            if (roi.getName().contains("level")) {
                ROI2DUtilities.interpolateMissingPointsAlongXAxis((ROI2DPolyLine)roi, width);
                continue;
            }
            if (!roi.getName().contains("derivative")) continue;
        }
        Collections.sort(listRois, new Comparators.ROI2D_Name_Comparator());
    }

    public List<ImageFileDescriptor> loadListOfPotentialKymographsFromSpots(String dir, SpotsArray spotsArray) {
        String directoryFull = dir + File.separator;
        int nspots = spotsArray.spotsList.size();
        ArrayList<ImageFileDescriptor> myListOfFiles = new ArrayList<ImageFileDescriptor>(nspots);
        for (int i = 0; i < nspots; ++i) {
            ImageFileDescriptor temp = new ImageFileDescriptor();
            temp.fileName = directoryFull + spotsArray.spotsList.get(i).getRoi().getName() + ".tiff";
            myListOfFiles.add(temp);
        }
        return myListOfFiles;
    }

    public boolean loadKymographImagesFromList(List<ImageFileDescriptor> kymoImagesDesc, boolean adjustImagesSize) {
        boolean flag;
        this.isRunning_loadImages = true;
        boolean bl = flag = kymoImagesDesc.size() > 0;
        if (!flag) {
            return flag;
        }
        if (adjustImagesSize) {
            this.adjustImagesToMaxSize(kymoImagesDesc, this.getMaxSizeofTiffFiles(kymoImagesDesc));
        }
        List<String> myList = new ArrayList<String>();
        for (ImageFileDescriptor prop : kymoImagesDesc) {
            if (!prop.exists) continue;
            myList.add(prop.fileName);
        }
        if (myList.size() > 0) {
            this.status = EnumStatus.KYMOGRAPH;
            myList = ExperimentDirectories.keepOnlyAcceptedNames_List(myList, "tiff");
            this.loadImageList(myList);
            this.setParentDirectoryAsCSCamFileName(myList.get(0));
            this.status = EnumStatus.KYMOGRAPH;
        }
        this.isRunning_loadImages = false;
        return flag;
    }

    protected void setParentDirectoryAsCSCamFileName(String filename) {
        if (filename != null) {
            Path path = Paths.get(filename, new String[0]);
            this.csFileName = path.getName(path.getNameCount() - 2).toString();
            this.seq.setName(this.csFileName);
        }
    }

    Rectangle getMaxSizeofTiffFiles(List<ImageFileDescriptor> files) {
        this.imageWidthMax = 0;
        this.imageHeightMax = 0;
        for (int i = 0; i < files.size(); ++i) {
            ImageFileDescriptor fileProp = files.get(i);
            if (!fileProp.exists) continue;
            this.getImageDim(fileProp);
            if (fileProp.imageWidth > this.imageWidthMax) {
                this.imageWidthMax = fileProp.imageWidth;
            }
            if (fileProp.imageHeight <= this.imageHeightMax) continue;
            this.imageHeightMax = fileProp.imageHeight;
        }
        return new Rectangle(0, 0, this.imageWidthMax, this.imageHeightMax);
    }

    boolean getImageDim(ImageFileDescriptor fileProp) {
        boolean flag = false;
        OMEXMLMetadata metaData = null;
        try {
            metaData = Loader.getOMEXMLMetaData((String)fileProp.fileName);
            fileProp.imageWidth = MetaDataUtil.getSizeX((OMEXMLMetadata)metaData, (int)0);
            fileProp.imageHeight = MetaDataUtil.getSizeY((OMEXMLMetadata)metaData, (int)0);
            flag = true;
        }
        catch (UnsupportedFormatException | IOException | InterruptedException e) {
            e.printStackTrace();
        }
        return flag;
    }

    void adjustImagesToMaxSize(List<ImageFileDescriptor> files, Rectangle rect) {
        ProgressFrame progress = new ProgressFrame("Make kymographs the same width and height");
        progress.setLength((double)files.size());
        for (int i = 0; i < files.size(); ++i) {
            ImageFileDescriptor fileProp = files.get(i);
            if (!fileProp.exists || fileProp.imageWidth == rect.width && fileProp.imageHeight == rect.height) continue;
            progress.setMessage("adjust image " + fileProp.fileName);
            IcyBufferedImage ibufImage1 = null;
            try {
                ibufImage1 = Loader.loadImage((String)fileProp.fileName);
            }
            catch (UnsupportedFormatException | IOException | InterruptedException e1) {
                e1.printStackTrace();
            }
            IcyBufferedImage ibufImage2 = new IcyBufferedImage(this.imageWidthMax, this.imageHeightMax, ibufImage1.getSizeC(), ibufImage1.getDataType_());
            this.transferImage1To2(ibufImage1, ibufImage2);
            try {
                Saver.saveImage((IcyBufferedImage)ibufImage2, (File)new File(fileProp.fileName), (boolean)true);
            }
            catch (IOException | FormatException e) {
                e.printStackTrace();
            }
            progress.incPosition();
        }
        progress.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transferImage1To2(IcyBufferedImage source, IcyBufferedImage destination) {
        int sizeY = source.getSizeY();
        int endC = source.getSizeC();
        int sourceSizeX = source.getSizeX();
        int destSizeX = destination.getSizeX();
        DataType dataType = source.getDataType_();
        boolean signed = dataType.isSigned();
        destination.lockRaster();
        try {
            for (int ch = 0; ch < endC; ++ch) {
                Object src = source.getDataXY(ch);
                Object dst = destination.getDataXY(ch);
                int srcOffset = 0;
                int dstOffset = 0;
                for (int curY = 0; curY < sizeY; ++curY) {
                    Array1DUtil.arrayToArray((Object)src, (int)srcOffset, (Object)dst, (int)dstOffset, (int)sourceSizeX, (boolean)signed);
                    destination.setDataXY(ch, dst);
                    srcOffset += sourceSizeX;
                    dstOffset += destSizeX;
                }
            }
        }
        finally {
            destination.releaseRaster(true);
        }
        destination.dataChanged();
    }
}

