/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS.experiment.cages;

import icy.roi.ROI;
import icy.roi.ROI2D;
import icy.sequence.Sequence;
import icy.type.geom.Polygon2D;
import icy.util.XMLUtil;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import plugins.fmp.multiSPOTS.experiment.Experiment;
import plugins.fmp.multiSPOTS.experiment.SequenceCamData;
import plugins.fmp.multiSPOTS.experiment.cages.Cage;
import plugins.fmp.multiSPOTS.experiment.cages.EnumCageMeasures;
import plugins.fmp.multiSPOTS.experiment.cages.FlyPositions;
import plugins.fmp.multiSPOTS.experiment.spots.Spot;
import plugins.fmp.multiSPOTS.experiment.spots.SpotsArray;
import plugins.fmp.multiSPOTS.tools.Comparators;
import plugins.fmp.multiSPOTS.tools.JComponents.Dialog;
import plugins.fmp.multiSPOTS.tools.ROI2D.ROIUtilities;
import plugins.kernel.roi.roi2d.ROI2DArea;
import plugins.kernel.roi.roi2d.ROI2DPolygon;
import plugins.kernel.roi.roi2d.ROI2DRectangle;
import plugins.kernel.roi.roi2d.ROI2DShape;

public class CagesArray {
    public ArrayList<Cage> cagesList = new ArrayList();
    public int nCagesAlongX = 6;
    public int nCagesAlongY = 8;
    public long detectFirst_Ms = 0L;
    public long detectLast_Ms = 0L;
    public long detectBin_Ms = 60000L;
    public int detect_threshold = 0;
    public int detect_nframes = 0;
    private final String ID_CAGES = "Cages";
    private final String ID_NCAGES = "n_cages";
    private final String ID_DROSOTRACK = "drosoTrack";
    private final String ID_NBITEMS = "nb_items";
    private final String ID_CAGELIMITS = "Cage_Limits";
    private final String ID_FLYDETECTED = "Fly_Detected";
    private static final String ID_MCDROSOTRACK_XML = "MCdrosotrack.xml";
    final String csvSep = ";";

    public void clearAllMeasures(int option_detectCage) {
        for (Cage cage : this.cagesList) {
            int cagenb = cage.getCageNumberInteger();
            if (option_detectCage >= 0 && option_detectCage != cagenb) continue;
            cage.clearMeasures();
        }
    }

    public void removeCages() {
        this.cagesList.clear();
    }

    public void mergeLists(CagesArray cagesm) {
        for (Cage cagem : cagesm.cagesList) {
            if (this.isPresent(cagem)) continue;
            this.cagesList.add(cagem);
        }
    }

    public boolean saveCagesMeasures(String directory) {
        this.csvSaveCagesMeasures(directory);
        String tempName = directory + File.separator + ID_MCDROSOTRACK_XML;
        this.xmlWriteCagesToFileNoQuestion(tempName);
        return true;
    }

    public boolean loadCagesMeasures(String directory) {
        String tempName = directory + File.separator + ID_MCDROSOTRACK_XML;
        this.xmlReadCagesFromFileNoQuestion(tempName);
        return true;
    }

    public boolean xmlWriteCagesToFileNoQuestion(String tempname) {
        if (tempname == null) {
            return false;
        }
        Document doc = XMLUtil.createDocument((boolean)true);
        if (doc == null) {
            return false;
        }
        Element node = XMLUtil.addElement((Node)XMLUtil.getRootElement((Document)doc), (String)"drosoTrack");
        if (node == null) {
            return false;
        }
        int index = 0;
        Element xmlVal = XMLUtil.addElement((Node)node, (String)"Cages");
        int ncages = this.cagesList.size();
        XMLUtil.setAttributeIntValue((Element)xmlVal, (String)"n_cages", (int)ncages);
        for (Cage cage : this.cagesList) {
            cage.xmlSaveCage(xmlVal, index);
            ++index;
        }
        return XMLUtil.saveDocument((Document)doc, (String)tempname);
    }

    private boolean csvSaveCagesMeasures(String directory) {
        try {
            FileWriter csvWriter = new FileWriter(directory + File.separator + "CagesMeasures.csv");
            this.csvSaveDescriptionSection(csvWriter);
            this.csvSaveMeasuresSection(csvWriter, EnumCageMeasures.POSITION);
            csvWriter.flush();
            csvWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }

    private boolean csvSaveDescriptionSection(FileWriter csvWriter) {
        try {
            csvWriter.append("#;DESCRIPTION;Cages data\n");
            csvWriter.append("n cages=;" + Integer.toString(this.cagesList.size()) + "\n");
            if (this.cagesList.size() > 0) {
                for (Cage cage : this.cagesList) {
                    csvWriter.append(cage.csvExportCageDescription(";"));
                }
            }
            csvWriter.append("#;#\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }

    private boolean csvSaveMeasuresSection(FileWriter csvWriter, EnumCageMeasures measuresType) {
        try {
            csvWriter.append("#;#\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }

    public boolean xmlReadCagesFromFile(Experiment exp) {
        String[] filedummy = null;
        String filename = exp.getResultsDirectory();
        File file = new File(filename);
        String directory = file.getParentFile().getAbsolutePath();
        filedummy = Dialog.selectFiles(directory, "xml");
        boolean wasOk = false;
        if (filedummy != null) {
            for (int i = 0; i < filedummy.length; ++i) {
                String csFile = filedummy[i];
                wasOk &= this.xmlReadCagesFromFileNoQuestion(csFile, exp);
            }
        }
        return wasOk;
    }

    public boolean xmlReadCagesFromFileNoQuestion(String tempname) {
        if (tempname == null) {
            return false;
        }
        Document doc = XMLUtil.loadDocument((String)tempname);
        if (doc == null) {
            return false;
        }
        if (this.xmlLoadCages(doc)) {
            return true;
        }
        System.out.println("Cages:xmlReadCagesFromFileNoQuestion() failed to load cages from file");
        return false;
    }

    public boolean xmlReadCagesFromFileNoQuestion(String tempname, Experiment exp) {
        if (tempname == null) {
            return false;
        }
        Document doc = XMLUtil.loadDocument((String)tempname);
        if (doc == null) {
            return false;
        }
        if (this.xmlLoadCages(doc)) {
            this.transferCagesToSequenceAsROIs(exp.seqCamData.seq);
            return true;
        }
        System.out.println("Cages:xmlReadCagesFromFileNoQuestion() failed to load cages from file");
        return false;
    }

    private boolean xmlLoadCages(Document doc) {
        Element node = XMLUtil.getElement((Node)XMLUtil.getRootElement((Document)doc), (String)"drosoTrack");
        if (node == null) {
            return false;
        }
        this.cagesList.clear();
        Element xmlVal = XMLUtil.getElement((Node)node, (String)"Cages");
        if (xmlVal != null) {
            int ncages = XMLUtil.getAttributeIntValue((Element)xmlVal, (String)"n_cages", (int)0);
            for (int index = 0; index < ncages; ++index) {
                Cage cage = new Cage();
                cage.xmlLoadCage(xmlVal, index);
                this.cagesList.add(cage);
            }
        } else {
            ArrayList<ROI2D> cageLimitROIList = new ArrayList<ROI2D>();
            if (this.xmlLoadCagesLimits_v0(node, cageLimitROIList)) {
                ArrayList<FlyPositions> flyPositionsList = new ArrayList<FlyPositions>();
                this.xmlLoadFlyPositions_v0(node, flyPositionsList);
                this.transferDataToCages_v0(cageLimitROIList, flyPositionsList);
            } else {
                return false;
            }
        }
        return true;
    }

    public void copy(CagesArray cag) {
        this.cagesList.clear();
        for (Cage ccag : cag.cagesList) {
            Cage cagi = new Cage();
            cagi.copyCage(ccag);
            this.cagesList.add(cagi);
        }
    }

    private void transferDataToCages_v0(List<ROI2D> cageLimitROIList, List<FlyPositions> flyPositionsList) {
        this.cagesList.clear();
        Collections.sort(cageLimitROIList, new Comparators.ROI2D_Name_Comparator());
        int ncages = cageLimitROIList.size();
        for (int index = 0; index < ncages; ++index) {
            Cage cage = new Cage();
            cage.setRoi((ROI2DShape)cageLimitROIList.get(index));
            cage.flyPositions = flyPositionsList.get(index);
            this.cagesList.add(cage);
        }
    }

    private boolean xmlLoadCagesLimits_v0(Node node, List<ROI2D> cageLimitROIList) {
        if (node == null) {
            return false;
        }
        Element xmlVal = XMLUtil.getElement((Node)node, (String)"Cage_Limits");
        if (xmlVal == null) {
            return false;
        }
        cageLimitROIList.clear();
        int nb_items = XMLUtil.getAttributeIntValue((Element)xmlVal, (String)"nb_items", (int)0);
        for (int i = 0; i < nb_items; ++i) {
            ROI2DPolygon roi = (ROI2DPolygon)ROI.create((String)"plugins.kernel.roi.roi2d.ROI2DPolygon");
            Element subnode = XMLUtil.getElement((Node)xmlVal, (String)("cage" + i));
            roi.loadFromXML((Node)subnode);
            cageLimitROIList.add((ROI2D)roi);
        }
        return true;
    }

    private boolean xmlLoadFlyPositions_v0(Node node, List<FlyPositions> flyPositionsList) {
        if (node == null) {
            return false;
        }
        Element xmlVal = XMLUtil.getElement((Node)node, (String)"Fly_Detected");
        if (xmlVal == null) {
            return false;
        }
        flyPositionsList.clear();
        int nb_items = XMLUtil.getAttributeIntValue((Element)xmlVal, (String)"nb_items", (int)0);
        int ielement = 0;
        for (int i = 0; i < nb_items; ++i) {
            Element subnode = XMLUtil.getElement((Node)xmlVal, (String)("cage" + ielement));
            FlyPositions pos = new FlyPositions();
            pos.loadXYTseriesFromXML(subnode);
            flyPositionsList.add(pos);
            ++ielement;
        }
        return true;
    }

    private boolean isPresent(Cage cagenew) {
        boolean flag = false;
        for (Cage cage : this.cagesList) {
            if (!cage.getRoi().getName().contentEquals(cagenew.getRoi().getName())) continue;
            flag = true;
            break;
        }
        return flag;
    }

    private void addMissingCages(List<ROI2D> roiList) {
        for (ROI2D roi : roiList) {
            boolean found = false;
            if (roi.getName() == null) break;
            for (Cage cage : this.cagesList) {
                if (cage.getRoi() == null) break;
                if (!roi.getName().equals(cage.getRoi().getName())) continue;
                found = true;
                break;
            }
            if (found) continue;
            Cage cage = new Cage();
            cage.setRoi((ROI2DShape)roi);
            this.cagesList.add(cage);
        }
    }

    private void removeOrphanCages(List<ROI2D> roiList) {
        Iterator<Cage> iterator = this.cagesList.iterator();
        while (iterator.hasNext()) {
            Cage cage = iterator.next();
            boolean found = false;
            if (cage.getRoi() != null) {
                String cageRoiName = cage.getRoi().getName();
                for (ROI2D roi : roiList) {
                    if (!roi.getName().equals(cageRoiName)) continue;
                    found = true;
                    break;
                }
            }
            if (found) continue;
            iterator.remove();
        }
    }

    public List<ROI2D> getRoisWithCageName(Sequence seq) {
        ArrayList roiList = seq.getROI2Ds();
        ArrayList<ROI2D> cageList = new ArrayList<ROI2D>();
        for (ROI2D roi : roiList) {
            String csName = roi.getName();
            if (!(roi instanceof ROI2DPolygon) && !(roi instanceof ROI2DArea) || (csName.length() <= 4 || !csName.substring(0, 4).contains("cage")) && !csName.contains("Polygon2D")) continue;
            cageList.add(roi);
        }
        return cageList;
    }

    public void transferCagesToSequenceAsROIs(Sequence seq) {
        seq.removeROIs(ROIUtilities.getROIsContainingString("cage", seq), false);
        ArrayList<ROI2D> cageROIList = new ArrayList<ROI2D>(this.cagesList.size());
        for (Cage cage : this.cagesList) {
            cageROIList.add(cage.getRoi());
        }
        seq.addROIs(cageROIList, true);
    }

    public void transferROIsFromSequenceToCages(Sequence seq) {
        List<ROI2D> roiList = this.getRoisWithCageName(seq);
        Collections.sort(roiList, new Comparators.ROI2D_Name_Comparator());
        this.addMissingCages(roiList);
        this.removeOrphanCages(roiList);
        Collections.sort(this.cagesList, new Comparators.Cage_Name_Comparator());
    }

    public void removeAllRoiDetFromSequence(SequenceCamData seqCamData) {
        ArrayList seqlist = seqCamData.seq.getROI2Ds();
        for (ROI2D roi : seqlist) {
            if (!(roi instanceof ROI2DShape) || !roi.getName().contains("det")) continue;
            seqCamData.seq.removeROI((ROI)roi);
        }
    }

    public void transferNFliesFromCagesToSpots(SpotsArray spotsArray) {
        for (Spot spot : spotsArray.spotsList) {
            for (Cage cage : this.cagesList) {
                int cagenb = cage.getCageNumberInteger();
                if (spot.cageID != cagenb) continue;
                spot.spotNFlies = cage.cageNFlies;
            }
        }
    }

    public void transferNFliesFromSpotsToCages(SpotsArray spotsArray) {
        for (Cage cage : this.cagesList) {
            int cagenb = cage.getCageNumberInteger();
            for (Spot spot : spotsArray.spotsList) {
                if (spot.cageID != cagenb) continue;
                cage.cageNFlies = spot.spotNFlies;
            }
        }
    }

    public void setCageNbFromSpotsArray(SpotsArray spotsArray) {
        spotsArray.updatePlateIndexToCageIndexes(spotsArray.nColumnsPerCage, spotsArray.nRowsPerCage);
    }

    public Cage getCageFromNumber(int number) {
        Cage cageFound = null;
        for (Cage cage : this.cagesList) {
            if (number != cage.getCageNumberInteger()) continue;
            cageFound = cage;
            break;
        }
        return cageFound;
    }

    public List<ROI2D> getPositionsAsListOfROI2DRectanglesAtT(int t) {
        ArrayList<ROI2D> roiRectangleList = new ArrayList<ROI2D>(this.cagesList.size());
        for (Cage cage : this.cagesList) {
            ROI2DRectangle roiRectangle = cage.getRoiRectangleFromPositionAtT(t);
            if (roiRectangle == null) continue;
            roiRectangleList.add((ROI2D)roiRectangle);
        }
        return roiRectangleList;
    }

    public void orderFlyPositions() {
        for (Cage cage : this.cagesList) {
            Collections.sort(cage.flyPositions.flyPositionList, new Comparators.XYTaValue_Tindex_Comparator());
        }
    }

    public void initFlyPositions(int option_cagenumber) {
        int nbcages = this.cagesList.size();
        for (int i = 0; i < nbcages; ++i) {
            Cage cage = this.cagesList.get(i);
            if (option_cagenumber != -1 && cage.getCageNumberInteger() != option_cagenumber || cage.cageNFlies <= 0) continue;
            cage.flyPositions = new FlyPositions();
            cage.flyPositions.ensureCapacity(this.detect_nframes);
        }
    }

    public void computeBooleanMasksForCages() {
        for (Cage cage : this.cagesList) {
            try {
                cage.computeCageBooleanMask2D();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public int getLastIntervalFlyAlive(int cagenumber) {
        int flypos = -1;
        for (Cage cage : this.cagesList) {
            String cagenumberString = cage.getRoi().getName().substring(4);
            if (Integer.valueOf(cagenumberString) != cagenumber) continue;
            flypos = cage.flyPositions.getLastIntervalAlive();
            break;
        }
        return flypos;
    }

    public boolean isFlyAlive(int cagenumber) {
        boolean isalive = false;
        for (Cage cage : this.cagesList) {
            String cagenumberString = cage.getRoi().getName().substring(4);
            if (Integer.valueOf(cagenumberString) != cagenumber) continue;
            isalive = cage.flyPositions.getLastIntervalAlive() > 0;
            break;
        }
        return isalive;
    }

    public boolean isDataAvailable(int cagenumber) {
        boolean isavailable = false;
        for (Cage cage : this.cagesList) {
            String cagenumberString = cage.getRoi().getName().substring(4);
            if (Integer.valueOf(cagenumberString) != cagenumber) continue;
            isavailable = true;
            break;
        }
        return isavailable;
    }

    public int getHorizontalSpanOfCages() {
        int leftPixel = -1;
        int rightPixel = -1;
        for (Cage cage : this.cagesList) {
            ROI2D roiCage = cage.getRoi();
            Rectangle2D rect = roiCage.getBounds2D();
            int left = (int)rect.getX();
            int right = left + (int)rect.getWidth();
            if (leftPixel < 0 || left < leftPixel) {
                leftPixel = left;
            }
            if (right <= rightPixel) continue;
            rightPixel = right;
        }
        return rightPixel - leftPixel;
    }

    public Polygon2D getPolygon2DEnclosingAllCages() {
        if (this.cagesList.size() < 1 || this.cagesList.get(0).getRoi() == null) {
            return null;
        }
        this.updateArrayIndexes();
        Polygon2D polygon = this.getCoordinatesOfROI(this.cagesList.get(0).getRoi());
        for (Cage cage : this.cagesList) {
            int col = cage.arrayColumn;
            int row = cage.arrayRow;
            Polygon2D n = this.getCoordinatesOfROI(cage.getRoi());
            if (col == 0 && row == 0) {
                this.transferPointToPolygon(0, polygon, n);
                continue;
            }
            if (col == this.nCagesAlongX - 1 && row == 0) {
                this.transferPointToPolygon(3, polygon, n);
                continue;
            }
            if (col == this.nCagesAlongX - 1 && row == this.nCagesAlongY - 1) {
                this.transferPointToPolygon(2, polygon, n);
                continue;
            }
            if (col != 0 || row != this.nCagesAlongY - 1) continue;
            this.transferPointToPolygon(1, polygon, n);
        }
        return polygon;
    }

    public void updateArrayIndexes() {
        int upleft = 0;
        int downleft = 1;
        int upright = 3;
        Polygon2D polygon = this.getCoordinatesOfROI(this.cagesList.get(0).getRoi());
        double width0 = polygon.xpoints[upright] - polygon.xpoints[upleft];
        double height0 = polygon.ypoints[downleft] - polygon.ypoints[upleft];
        this.nCagesAlongX = 1;
        this.nCagesAlongY = 1;
        for (Cage cage : this.cagesList) {
            Polygon2D n = this.getCoordinatesOfROI(cage.getRoi());
            int arrayColumn = (int)Math.round((n.xpoints[upright] - polygon.xpoints[upleft]) / width0);
            cage.arrayColumn = arrayColumn - 1;
            if (this.nCagesAlongX < arrayColumn) {
                this.nCagesAlongX = arrayColumn;
            }
            int arrayRow = (int)Math.round((n.ypoints[downleft] - polygon.ypoints[upleft]) / height0);
            cage.arrayRow = arrayRow - 1;
            if (this.nCagesAlongY >= arrayRow) continue;
            this.nCagesAlongY = arrayRow;
        }
    }

    private void transferPointToPolygon(int i, Polygon2D dest, Polygon2D source) {
        dest.xpoints[i] = source.xpoints[i];
        dest.ypoints[i] = source.ypoints[i];
    }

    private Polygon2D getCoordinatesOfROI(ROI2D roi) {
        Polygon2D polygon = null;
        if (roi instanceof ROI2DPolygon) {
            polygon = ((ROI2DPolygon)roi).getPolygon2D();
        } else {
            Rectangle rect = roi.getBounds();
            polygon = new Polygon2D((Rectangle2D)rect);
        }
        return polygon;
    }
}

