/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS.experiment.cages;

import icy.util.StringUtil;
import icy.util.XMLUtil;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import plugins.kernel.roi.roi2d.ROI2DArea;

public class FlyPosition {
    public Rectangle2D rectPosition = new Rectangle2D.Double(Double.NaN, Double.NaN, Double.NaN, Double.NaN);
    public ROI2DArea flyRoi = null;
    public int flyIndexT = 0;
    public boolean bAlive = false;
    public boolean bSleep = false;
    public boolean bPadded = false;
    public double distance = 0.0;
    public double sumDistance = 0.0;
    public double axis1 = 0.0;
    public double axis2 = 0.0;

    public FlyPosition() {
    }

    public FlyPosition(int indexT) {
        this.flyIndexT = indexT;
    }

    public FlyPosition(int indexT, Rectangle2D rectangle) {
        if (rectangle != null) {
            this.rectPosition.setRect(rectangle);
        }
        this.flyIndexT = indexT;
    }

    public FlyPosition(int indexT, Rectangle2D rectangle, ROI2DArea roiArea) {
        if (rectangle != null) {
            this.rectPosition.setRect(rectangle);
        }
        this.flyRoi = new ROI2DArea(roiArea);
        this.flyIndexT = indexT;
    }

    public FlyPosition(int indexT, Rectangle2D rectangle, boolean alive) {
        if (rectangle != null) {
            this.rectPosition.setRect(rectangle);
        }
        this.flyIndexT = indexT;
        this.bAlive = alive;
    }

    public void copy(FlyPosition source) {
        this.flyIndexT = source.flyIndexT;
        this.bAlive = source.bAlive;
        this.bSleep = source.bSleep;
        this.bPadded = source.bPadded;
        this.distance = source.distance;
        this.rectPosition.setRect(source.rectPosition);
        if (source.flyRoi != null && source.flyRoi.getBounds().height > 0 && source.flyRoi.getBounds().width > 0) {
            this.flyRoi = new ROI2DArea(source.flyRoi);
        }
        this.axis1 = source.axis1;
        this.axis2 = source.axis2;
    }

    Point2D getCenterRectangle() {
        return new Point2D.Double(this.rectPosition.getX() + this.rectPosition.getWidth() / 2.0, this.rectPosition.getY() + this.rectPosition.getHeight() / 2.0);
    }

    public boolean loadXYTvaluesFromXML(Node node) {
        Element node_roi;
        if (node == null) {
            return false;
        }
        Element node_XYTa = XMLUtil.getElement((Node)node, (String)"XYTa");
        if (node_XYTa != null) {
            double xR = XMLUtil.getAttributeDoubleValue((Element)node_XYTa, (String)"xR", (double)Double.NaN);
            double yR = XMLUtil.getAttributeDoubleValue((Element)node_XYTa, (String)"yR", (double)Double.NaN);
            double wR = XMLUtil.getAttributeDoubleValue((Element)node_XYTa, (String)"wR", (double)Double.NaN);
            double hR = XMLUtil.getAttributeDoubleValue((Element)node_XYTa, (String)"hR", (double)Double.NaN);
            if (!Double.isNaN(xR) && !Double.isNaN(yR)) {
                this.rectPosition.setRect(xR, yR, wR, hR);
            } else {
                xR = XMLUtil.getAttributeDoubleValue((Element)node_XYTa, (String)"x", (double)Double.NaN);
                yR = XMLUtil.getAttributeDoubleValue((Element)node_XYTa, (String)"y", (double)Double.NaN);
                if (!Double.isNaN(xR) && !Double.isNaN(yR)) {
                    wR = 4.0;
                    hR = 4.0;
                    this.rectPosition.setRect(xR -= 2.0, yR -= 2.0, wR, hR);
                }
            }
            this.flyIndexT = XMLUtil.getAttributeIntValue((Element)node_XYTa, (String)"t", (int)0);
            this.bAlive = XMLUtil.getAttributeBooleanValue((Element)node_XYTa, (String)"a", (boolean)false);
            this.bSleep = XMLUtil.getAttributeBooleanValue((Element)node_XYTa, (String)"s", (boolean)false);
        }
        if ((node_roi = XMLUtil.getElement((Node)node, (String)"roi")) != null) {
            if (this.flyRoi == null) {
                this.flyRoi = new ROI2DArea();
            }
            this.flyRoi.loadFromXML((Node)node_roi);
        }
        return false;
    }

    public boolean saveXYTvaluesToXML(Node node) {
        if (node == null) {
            return false;
        }
        Element node_XYTa = XMLUtil.addElement((Node)node, (String)"XYTa");
        if (!Double.isNaN(this.rectPosition.getX())) {
            XMLUtil.setAttributeDoubleValue((Element)node_XYTa, (String)"xR", (double)this.rectPosition.getX());
            XMLUtil.setAttributeDoubleValue((Element)node_XYTa, (String)"yR", (double)this.rectPosition.getY());
            XMLUtil.setAttributeDoubleValue((Element)node_XYTa, (String)"wR", (double)this.rectPosition.getWidth());
            XMLUtil.setAttributeDoubleValue((Element)node_XYTa, (String)"hR", (double)this.rectPosition.getHeight());
        }
        XMLUtil.setAttributeDoubleValue((Element)node_XYTa, (String)"t", (double)this.flyIndexT);
        XMLUtil.setAttributeBooleanValue((Element)node_XYTa, (String)"a", (boolean)this.bAlive);
        XMLUtil.setAttributeBooleanValue((Element)node_XYTa, (String)"s", (boolean)this.bSleep);
        Element node_roi = XMLUtil.addElement((Node)node, (String)"roi");
        if (this.flyRoi != null) {
            this.flyRoi.saveToXML((Node)node_roi);
        }
        return false;
    }

    public boolean cvsExportXYWHData(StringBuffer sbf, String sep) {
        this.cvsExportXYData(sbf, sep);
        sbf.append(StringUtil.toString((double)this.rectPosition.getWidth()));
        sbf.append(sep);
        sbf.append(StringUtil.toString((double)this.rectPosition.getHeight()));
        sbf.append(sep);
        return true;
    }

    public boolean cvsExportXYData(StringBuffer sbf, String sep) {
        sbf.append(StringUtil.toString((int)this.flyIndexT));
        sbf.append(sep);
        sbf.append(StringUtil.toString((double)this.rectPosition.getX()));
        sbf.append(sep);
        sbf.append(StringUtil.toString((double)this.rectPosition.getY()));
        sbf.append(sep);
        return true;
    }

    public boolean csvImportXYWHData(String[] data, int startAt) {
        int npoints = 5;
        if (data.length < npoints + startAt - 1) {
            return false;
        }
        int offset = startAt;
        this.flyIndexT = Integer.valueOf(data[offset]);
        double xR = Double.valueOf(data[++offset]);
        double yR = Double.valueOf(data[++offset]);
        double wR = Double.valueOf(data[++offset]);
        double hR = Double.valueOf(data[++offset]);
        ++offset;
        this.rectPosition.setRect(xR, yR, wR, hR);
        return true;
    }

    public boolean csvImportXYData(String[] data, int startAt) {
        int npoints = 3;
        if (data.length < npoints + startAt - 1) {
            return false;
        }
        int offset = startAt;
        this.flyIndexT = Integer.valueOf(data[offset]);
        double xR = Double.valueOf(data[++offset]);
        double yR = Double.valueOf(data[++offset]);
        ++offset;
        if (!Double.isNaN(xR) && !Double.isNaN(yR)) {
            double wR = 4.0;
            double hR = 4.0;
            this.rectPosition.setRect(xR -= 2.0, yR -= 2.0, wR, hR);
        }
        return true;
    }
}

