/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS.experiment.spots;

import icy.image.IcyBufferedImage;
import icy.roi.BooleanMask2D;
import icy.roi.ROI2D;
import icy.util.XMLUtil;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import plugins.fmp.multiSPOTS.experiment.spots.EnumSpotMeasures;
import plugins.fmp.multiSPOTS.experiment.spots.SpotMeasure;
import plugins.fmp.multiSPOTS.series.BuildSeriesOptions;
import plugins.fmp.multiSPOTS.tools.ROI2D.ROI2DAlongT;
import plugins.fmp.multiSPOTS.tools.ROI2D.ROI2DUtilities;
import plugins.fmp.multiSPOTS.tools.polyline.Level2D;
import plugins.fmp.multiSPOTS.tools.toExcel.EnumXLSColumnHeader;
import plugins.fmp.multiSPOTS.tools.toExcel.EnumXLSExportType;
import plugins.kernel.roi.roi2d.ROI2DPolyLine;
import plugins.kernel.roi.roi2d.ROI2DShape;

public class Spot
implements Comparable<Spot> {
    private ROI2DShape spotRoi2D = null;
    private ROI2DShape spotRoi_old = null;
    private ArrayList<ROI2DAlongT> listRoiAlongT = new ArrayList();
    public int kymographIndex = -1;
    public BooleanMask2D mask2DSpot = null;
    public int cageID = -1;
    public int cagePosition = 0;
    public int plateIndex = 0;
    public int plateColumn = 0;
    public int plateRow = 0;
    public String version = null;
    public String spotStim = new String("..");
    public String spotConc = new String("..");
    public int spotNFlies = 1;
    public double spotVolume = 1.0;
    public int spotNPixels = 1;
    public int spotRadius = 30;
    public int spotXCoord = -1;
    public int spotYCoord = -1;
    public boolean descriptionOK = false;
    public int versionInfos = 0;
    public BuildSeriesOptions limitsOptions = new BuildSeriesOptions();
    public int spot_CamData_T = -1;
    public int spot_Kymograph_T = -1;
    public String spot_filenameTIFF = null;
    public IcyBufferedImage spot_Image = null;
    public SpotMeasure sum_in = new SpotMeasure("sum");
    public SpotMeasure sum_clean = new SpotMeasure("clean");
    public SpotMeasure flyPresent = new SpotMeasure("flyPresent");
    public boolean valid = true;
    public boolean okToAnalyze = true;
    private final String ID_META = "metaMC";
    private final String ID_NFLIES = "nflies";
    private final String ID_CAGE = "cage_id";
    private final String ID_CAGEINDEX = "cage_index";
    private final String ID_PLATEINDEX = "plate_index";
    private final String ID_PLATECOL = "plate_col";
    private final String ID_PLATEROW = "plate_row";
    private final String ID_SPOTVOLUME = "volume";
    private final String ID_PIXELS = "pixels";
    private final String ID_RADIUS = "radius";
    private final String ID_XCOORD = "spotXCoord";
    private final String ID_YCOORD = "spotYCoord";
    private final String ID_STIMULUS = "stimulus";
    private final String ID_CONCENTRATION = "concentration";
    private final String ID_DESCOK = "descriptionOK";
    private final String ID_VERSIONINFOS = "versionInfos";
    private final String ID_INTERVALS = "INTERVALS";
    private final String ID_NINTERVALS = "nintervals";
    private final String ID_INTERVAL = "interval_";
    private final String ID_INDEXIMAGE = "indexImageMC";
    private final String ID_VERSION = "version";
    private final String ID_VERSIONNUM = "1.0.0";
    private Color[] spotColors = new Color[]{new Color(255, 85, 85), new Color(85, 85, 255), new Color(85, 255, 85), new Color(255, 255, 85), new Color(255, 85, 255), new Color(85, 255, 255), Color.pink, Color.gray};

    public Spot(ROI2DShape roi) {
        this.spotRoi2D = roi;
    }

    public Spot() {
    }

    @Override
    public int compareTo(Spot o) {
        if (o != null) {
            return this.spotRoi2D.getName().compareTo(o.spotRoi2D.getName());
        }
        return 1;
    }

    public void copySpot(Spot spotFrom) {
        this.version = spotFrom.version;
        this.spotRoi2D = (ROI2DShape)spotFrom.spotRoi2D.getCopy();
        this.plateIndex = spotFrom.plateIndex;
        this.plateColumn = spotFrom.plateColumn;
        this.plateRow = spotFrom.plateRow;
        this.cageID = spotFrom.cageID;
        this.cagePosition = spotFrom.cagePosition;
        this.spotNFlies = spotFrom.spotNFlies;
        this.spotVolume = spotFrom.spotVolume;
        this.spotStim = spotFrom.spotStim;
        this.spotConc = spotFrom.spotConc;
        this.spotNPixels = spotFrom.spotNPixels;
        this.spotRadius = spotFrom.spotRadius;
        this.spotXCoord = spotFrom.spotXCoord;
        this.spotYCoord = spotFrom.spotYCoord;
        this.limitsOptions = spotFrom.limitsOptions;
        this.sum_in.copyLevel2D(spotFrom.sum_in);
        this.sum_clean.copyLevel2D(spotFrom.sum_clean);
        this.flyPresent.copyLevel2D(spotFrom.flyPresent);
    }

    public ROI2D getRoi() {
        return this.spotRoi2D;
    }

    public ROI2D getRoi_old() {
        return this.spotRoi_old;
    }

    public void setRoi(ROI2DShape roi) {
        this.spotRoi2D = roi;
        this.listRoiAlongT.clear();
    }

    public void setRoi_old(ROI2DShape roi) {
        this.spotRoi_old = roi;
    }

    public String getPlateCoordinatesAsString() {
        String plateCoords = this.getCharForNumber(this.plateRow) + "_" + Integer.toString(this.plateColumn);
        return plateCoords;
    }

    private String getCharForNumber(int i) {
        return i > -1 && i < 26 ? String.valueOf((char)(i + 65)) : null;
    }

    public void setSpotRoi_InColorAccordingToSpotIndex(int index) {
        Color value = this.spotColors[index % 8];
        this.spotRoi2D.setColor(value);
    }

    public String getCagePosition(EnumXLSExportType xlsExportOption) {
        String value = null;
        switch (xlsExportOption) {
            case DISTANCE: 
            case ISALIVE: {
                value = String.valueOf(this.cagePosition) + "(T=B)";
                break;
            }
            case TOPLEVELDELTA_LR: 
            case TOPLEVEL_LR: {
                if (this.cagePosition == 0) {
                    value = "sum";
                    break;
                }
                if (this.cagePosition != 1) break;
                value = "PI";
                break;
            }
            case XYIMAGE: 
            case XYTOPCAGE: 
            case XYTIPCAPS: {
                if (this.cagePosition == 0) {
                    value = "x";
                    break;
                }
                value = "y";
                break;
            }
            default: {
                value = String.valueOf(this.cagePosition);
            }
        }
        return value;
    }

    public String getSpotField(EnumXLSColumnHeader fieldEnumCode) {
        String stringValue = null;
        switch (fieldEnumCode) {
            case CAP_STIM: {
                stringValue = this.spotStim;
                break;
            }
            case CAP_CONC: {
                stringValue = this.spotConc;
                break;
            }
        }
        return stringValue;
    }

    public void setSpotField(EnumXLSColumnHeader fieldEnumCode, String stringValue) {
        switch (fieldEnumCode) {
            case CAP_STIM: {
                this.spotStim = stringValue;
                break;
            }
            case CAP_CONC: {
                this.spotConc = stringValue;
                break;
            }
        }
    }

    public Point2D getSpotCenter() {
        Point pt = this.spotRoi2D.getPosition();
        Rectangle rect = this.spotRoi2D.getBounds();
        pt.translate(rect.height / 2, rect.width / 2);
        return pt;
    }

    private SpotMeasure getSpotArea(EnumXLSExportType option) {
        switch (option) {
            case AREA_SUM: 
            case AREA_SUM_LR: {
                return this.sum_in;
            }
            case AREA_SUMCLEAN: 
            case AREA_SUMCLEAN_LR: {
                return this.sum_clean;
            }
            case AREA_FLYPRESENT: {
                return this.flyPresent;
            }
        }
        return null;
    }

    public boolean isL() {
        int i = this.plateIndex % 2;
        return 0 == i;
    }

    public boolean isR() {
        int i = this.plateIndex % 2;
        return 1 == i;
    }

    public boolean isIndexSelected(List<Integer> selectedIndexes) {
        if (selectedIndexes == null || selectedIndexes.size() < 1) {
            return true;
        }
        for (int i : selectedIndexes) {
            if (i != this.plateIndex) continue;
            return true;
        }
        return false;
    }

    public boolean isThereAnyMeasuresDone(EnumXLSExportType option) {
        SpotMeasure spotArea = this.getSpotArea(option);
        if (spotArea != null) {
            return spotArea.isThereAnyMeasuresDone();
        }
        return false;
    }

    public ArrayList<Double> getSpotMeasuresForXLSPass1(EnumXLSExportType option, long seriesBinMs, long outputBinMs) {
        SpotMeasure spotArea = this.getSpotArea(option);
        if (spotArea != null) {
            return spotArea.getLevel2D_Y_subsampled(seriesBinMs, outputBinMs);
        }
        return null;
    }

    public void cropSpotMeasuresToNPoints(int npoints) {
        this.cropSpotMeasureToNPoints(this.sum_in, npoints);
        this.cropSpotMeasureToNPoints(this.sum_clean, npoints);
        this.cropSpotMeasureToNPoints(this.flyPresent, npoints);
    }

    private void cropSpotMeasureToNPoints(SpotMeasure spotMeasure, int npoints) {
        if (spotMeasure.getLevel2DNPoints() > 0) {
            spotMeasure.cropLevel2DToNPoints(npoints);
        }
    }

    public void restoreClippedSpotMeasures() {
        this.restoreClippedMeasures(this.sum_in);
        this.restoreClippedMeasures(this.sum_clean);
        this.restoreClippedMeasures(this.flyPresent);
    }

    private void restoreClippedMeasures(SpotMeasure spotMeasure) {
        if (spotMeasure.getLevel2DNPoints() > 0) {
            spotMeasure.restoreCroppedLevel2D();
        }
    }

    public void transferROIsMeasuresToLevel2D() {
        this.sum_in.transferROItoLevel2D();
        this.sum_clean.transferROItoLevel2D();
        this.flyPresent.transferROItoLevel2D();
    }

    public boolean loadFromXML_SpotOnly(Node node) {
        boolean flag;
        Element nodeMeta = XMLUtil.getElement((Node)node, (String)"metaMC");
        boolean bl = flag = nodeMeta != null;
        if (flag) {
            this.version = XMLUtil.getElementValue((Node)nodeMeta, (String)"version", (String)"0.0.0");
            this.cageID = XMLUtil.getElementIntValue((Node)nodeMeta, (String)"indexImageMC", (int)this.cageID);
            this.descriptionOK = XMLUtil.getElementBooleanValue((Node)nodeMeta, (String)"descriptionOK", (boolean)false);
            this.versionInfos = XMLUtil.getElementIntValue((Node)nodeMeta, (String)"versionInfos", (int)0);
            this.spotNFlies = XMLUtil.getElementIntValue((Node)nodeMeta, (String)"nflies", (int)this.spotNFlies);
            this.cageID = XMLUtil.getElementIntValue((Node)nodeMeta, (String)"cage_id", (int)this.cageID);
            this.cagePosition = XMLUtil.getElementIntValue((Node)nodeMeta, (String)"cage_index", (int)this.cagePosition);
            this.plateIndex = XMLUtil.getElementIntValue((Node)nodeMeta, (String)"plate_index", (int)this.plateIndex);
            this.plateColumn = XMLUtil.getElementIntValue((Node)nodeMeta, (String)"plate_col", (int)this.plateColumn);
            this.plateRow = XMLUtil.getElementIntValue((Node)nodeMeta, (String)"plate_row", (int)this.plateRow);
            this.spotVolume = XMLUtil.getElementDoubleValue((Node)nodeMeta, (String)"volume", (double)Double.NaN);
            this.spotNPixels = XMLUtil.getElementIntValue((Node)nodeMeta, (String)"pixels", (int)5);
            this.spotRadius = XMLUtil.getElementIntValue((Node)nodeMeta, (String)"radius", (int)30);
            this.spotXCoord = XMLUtil.getElementIntValue((Node)nodeMeta, (String)"spotXCoord", (int)-1);
            this.spotYCoord = XMLUtil.getElementIntValue((Node)nodeMeta, (String)"spotYCoord", (int)-1);
            this.spotStim = XMLUtil.getElementValue((Node)nodeMeta, (String)"stimulus", (String)"stimulus");
            this.spotConc = XMLUtil.getElementValue((Node)nodeMeta, (String)"concentration", (String)"concentration");
            this.spotRoi2D = (ROI2DShape)ROI2DUtilities.loadFromXML_ROI(nodeMeta);
            this.setSpotRoi_InColorAccordingToSpotIndex(this.cagePosition);
            this.limitsOptions.loadFromXML(nodeMeta);
            this.loadFromXML_SpotAlongT(node);
        }
        return flag;
    }

    private boolean loadFromXML_SpotAlongT(Node node) {
        this.listRoiAlongT.clear();
        Element nodeMeta2 = XMLUtil.getElement((Node)node, (String)"INTERVALS");
        if (nodeMeta2 == null) {
            return false;
        }
        int nitems = XMLUtil.getElementIntValue((Node)nodeMeta2, (String)"nintervals", (int)0);
        if (nitems > 0) {
            for (int i = 0; i < nitems; ++i) {
                Element node_i = XMLUtil.setElement((Node)nodeMeta2, (String)("interval_" + i));
                ROI2DAlongT roiInterval = new ROI2DAlongT();
                roiInterval.loadFromXML(node_i);
                this.listRoiAlongT.add(roiInterval);
                if (i != 0) continue;
                this.spotRoi2D = (ROI2DShape)this.listRoiAlongT.get(0).getRoi_in();
            }
        }
        return true;
    }

    public boolean saveToXML_SpotOnly(Node node) {
        Element nodeMeta = XMLUtil.setElement((Node)node, (String)"metaMC");
        if (nodeMeta == null) {
            return false;
        }
        if (this.version == null) {
            this.version = "1.0.0";
        }
        XMLUtil.setElementValue((Node)nodeMeta, (String)"version", (String)this.version);
        XMLUtil.setElementIntValue((Node)nodeMeta, (String)"indexImageMC", (int)this.cageID);
        XMLUtil.setElementBooleanValue((Node)nodeMeta, (String)"descriptionOK", (boolean)this.descriptionOK);
        XMLUtil.setElementIntValue((Node)nodeMeta, (String)"versionInfos", (int)this.versionInfos);
        XMLUtil.setElementIntValue((Node)nodeMeta, (String)"nflies", (int)this.spotNFlies);
        XMLUtil.setElementIntValue((Node)nodeMeta, (String)"cage_id", (int)this.cageID);
        XMLUtil.setElementIntValue((Node)nodeMeta, (String)"cage_index", (int)this.cagePosition);
        XMLUtil.setElementIntValue((Node)nodeMeta, (String)"plate_index", (int)this.plateIndex);
        XMLUtil.setElementIntValue((Node)nodeMeta, (String)"plate_col", (int)this.plateColumn);
        XMLUtil.setElementIntValue((Node)nodeMeta, (String)"plate_row", (int)this.plateRow);
        XMLUtil.setElementDoubleValue((Node)nodeMeta, (String)"volume", (double)this.spotVolume);
        XMLUtil.setElementIntValue((Node)nodeMeta, (String)"pixels", (int)this.spotNPixels);
        XMLUtil.setElementIntValue((Node)nodeMeta, (String)"radius", (int)this.spotRadius);
        XMLUtil.setElementIntValue((Node)nodeMeta, (String)"spotXCoord", (int)this.spotXCoord);
        XMLUtil.setElementIntValue((Node)nodeMeta, (String)"spotYCoord", (int)this.spotYCoord);
        XMLUtil.setElementValue((Node)nodeMeta, (String)"stimulus", (String)this.spotStim);
        XMLUtil.setElementValue((Node)nodeMeta, (String)"concentration", (String)this.spotConc);
        ROI2DUtilities.saveToXML_ROI(nodeMeta, (ROI2D)this.spotRoi2D);
        boolean flag = this.saveToXML_SpotAlongT(node);
        return flag;
    }

    private boolean saveToXML_SpotAlongT(Node node) {
        Element nodeMeta2 = XMLUtil.setElement((Node)node, (String)"INTERVALS");
        if (nodeMeta2 == null) {
            return false;
        }
        int nitems = this.listRoiAlongT.size();
        XMLUtil.setElementIntValue((Node)nodeMeta2, (String)"nintervals", (int)nitems);
        if (nitems > 0) {
            for (int i = 0; i < nitems; ++i) {
                Element node_i = XMLUtil.setElement((Node)nodeMeta2, (String)("interval_" + i));
                this.listRoiAlongT.get(i).saveToXML(node_i);
            }
        }
        return true;
    }

    public List<ROI2DAlongT> getROIAlongTList() {
        if (this.listRoiAlongT.size() < 1) {
            this.initROIAlongTList();
        }
        return this.listRoiAlongT;
    }

    public ROI2DAlongT getROIAtT(long t) {
        if (this.listRoiAlongT.size() < 1) {
            this.initROIAlongTList();
        }
        ROI2DAlongT spotRoi = null;
        for (ROI2DAlongT item : this.listRoiAlongT) {
            if (t < item.getT()) break;
            spotRoi = item;
        }
        return spotRoi;
    }

    public void removeROIAlongTListItem(long t) {
        ROI2DAlongT itemFound = null;
        for (ROI2DAlongT item : this.listRoiAlongT) {
            if (t != item.getT()) continue;
            itemFound = item;
        }
        if (itemFound != null) {
            this.listRoiAlongT.remove(itemFound);
        }
    }

    private void initROIAlongTList() {
        this.listRoiAlongT.add(new ROI2DAlongT(0L, (ROI2D)this.spotRoi2D));
    }

    public void adjustLevel2DMeasuresToImageWidth(int imageWidth) {
        this.sum_in.adjustLevel2DToImageWidth(imageWidth);
        this.sum_clean.adjustLevel2DToImageWidth(imageWidth);
        this.flyPresent.adjustLevel2DToImageWidth(imageWidth);
    }

    public void cropLevel2DMeasuresToImageWidth(int imageWidth) {
        this.sum_in.cropLevel2DToNPoints(imageWidth);
        this.sum_clean.cropLevel2DToNPoints(imageWidth);
        this.flyPresent.cropLevel2DToNPoints(imageWidth);
    }

    public void initLevel2DMeasures() {
        this.sum_in.initLevel2D_fromMeasureValues(this.getRoi().getName());
        this.sum_clean.initLevel2D_fromMeasureValues(this.getRoi().getName());
        this.flyPresent.initLevel2D_fromBooleans(this.getRoi().getName());
    }

    public void buildRunningMedianFromSumLevel2D(int imageHeight) {
        int span = 10;
        if (this.sum_in.values != null) {
            this.sum_clean.buildRunningMedian(span, this.sum_in.values);
        } else {
            this.sum_clean.buildRunningMedian(span, this.sum_in.getLevel2D().ypoints);
        }
        this.sum_clean.initLevel2D_fromMeasureValues(this.sum_clean.getName());
    }

    public List<ROI2D> transferSpotMeasuresToROIs(int imageHeight) {
        ArrayList<ROI2D> measuresRoisList = new ArrayList<ROI2D>();
        if (this.sum_in.getLevel2DNPoints() != 0) {
            measuresRoisList.add((ROI2D)this.sum_in.getROIForImage(this.spotRoi2D.getName(), this.spot_Kymograph_T, imageHeight));
        }
        if (this.sum_clean.getLevel2DNPoints() != 0) {
            measuresRoisList.add((ROI2D)this.sum_clean.getROIForImage(this.spotRoi2D.getName(), this.spot_Kymograph_T, imageHeight));
        }
        if (this.flyPresent.getLevel2DNPoints() != 0) {
            measuresRoisList.add((ROI2D)this.flyPresent.getROIForImage(this.spotRoi2D.getName(), this.spot_Kymograph_T, 10));
        }
        return measuresRoisList;
    }

    public void transferROItoMeasures(ROI2D roi, int imageHeight) {
        String name = roi.getName();
        if (name.contains(this.sum_in.getName())) {
            this.transferROItoMeasureValue(roi, imageHeight, this.sum_in);
        } else if (name.contains(this.sum_clean.getName())) {
            this.transferROItoMeasureValue(roi, imageHeight, this.sum_clean);
        } else if (name.contains(this.flyPresent.getName())) {
            this.transferROItoMeasureBoolean(roi, this.flyPresent);
        }
    }

    private void transferROItoMeasureValue(ROI2D roi, int imageHeight, SpotMeasure spotMeasure) {
        if (roi instanceof ROI2DPolyLine) {
            Level2D level2D = new Level2D(((ROI2DPolyLine)roi).getPolyline2D());
            level2D.multiply_Y(imageHeight);
            spotMeasure.setLevel2D(level2D);
        }
    }

    private void transferROItoMeasureBoolean(ROI2D roi, SpotMeasure spotMeasure) {
        if (roi instanceof ROI2DPolyLine) {
            Level2D level2D = new Level2D(((ROI2DPolyLine)roi).getPolyline2D());
            level2D.threshold_Y(1.0);
            spotMeasure.setLevel2D(level2D);
        }
    }

    public String csvExportSpotArrayHeader(String csvSep) {
        StringBuffer sbf = new StringBuffer();
        sbf.append("#" + csvSep + "SPOTS" + csvSep + "describe each spot\n");
        List<String> row2 = Arrays.asList("index", "name", "cage", "nflies", "volume", "npixel", "radius", "stim", "conc", "side");
        sbf.append(String.join((CharSequence)csvSep, row2));
        sbf.append("\n");
        return sbf.toString();
    }

    public String csvExportDescription(String csvSep) {
        StringBuffer sbf = new StringBuffer();
        List<String> row = Arrays.asList(String.valueOf(this.plateIndex), this.getRoi().getName(), String.valueOf(this.cageID), String.valueOf(this.spotNFlies), String.valueOf(this.spotVolume), String.valueOf(this.spotNPixels), String.valueOf(this.spotRadius), this.spotStim.replace(",", "."), this.spotConc.replace(",", "."), String.valueOf(this.cagePosition));
        sbf.append(String.join((CharSequence)csvSep, row));
        sbf.append("\n");
        return sbf.toString();
    }

    public String csvExportMeasures_SectionHeader(EnumSpotMeasures measureType, String csvSep) {
        StringBuffer sbf = new StringBuffer();
        List<String> listExplanation1 = Arrays.asList("\n name", "index", "npts", "yi", "\n");
        String explanation1 = String.join((CharSequence)csvSep, listExplanation1);
        switch (measureType) {
            case AREA_SUM: 
            case AREA_SUMCLEAN: 
            case AREA_FLYPRESENT: 
            case AREA_OUT: 
            case AREA_DIFF: {
                sbf.append("#" + csvSep + measureType.toString() + csvSep + explanation1);
                break;
            }
            default: {
                sbf.append("#" + csvSep + "UNDEFINED" + csvSep + "------------\n");
            }
        }
        return sbf.toString();
    }

    public String csvExportMeasures_OneType(EnumSpotMeasures measureType, String csvSep) {
        StringBuffer sbf = new StringBuffer();
        sbf.append(this.spotRoi2D.getName() + csvSep + this.plateIndex + csvSep);
        switch (measureType) {
            case AREA_SUM: {
                this.sum_in.cvsExportYDataToRow(sbf, csvSep);
                break;
            }
            case AREA_SUMCLEAN: {
                this.sum_clean.cvsExportYDataToRow(sbf, csvSep);
                break;
            }
            case AREA_FLYPRESENT: {
                this.flyPresent.cvsExportYDataToRow(sbf, csvSep);
                break;
            }
        }
        sbf.append("\n");
        return sbf.toString();
    }

    public void csvImportDescription(String[] data, boolean dummyColumn) {
        int i = dummyColumn ? 1 : 0;
        this.plateIndex = Integer.valueOf(data[i]);
        this.spotRoi2D.setName(data[++i]);
        this.cageID = Integer.valueOf(data[++i]);
        this.spotNFlies = Integer.valueOf(data[++i]);
        this.spotVolume = Double.valueOf(data[++i]);
        this.spotNPixels = Integer.valueOf(data[++i]);
        this.spotRadius = Integer.valueOf(data[++i]);
        this.spotStim = data[++i];
        this.spotConc = data[++i];
        this.cagePosition = Integer.valueOf(data[++i]);
    }

    public void csvImportMeasures_OneType(EnumSpotMeasures measureType, String[] data, boolean x, boolean y) {
        if (x && y) {
            switch (measureType) {
                case AREA_SUM: {
                    this.sum_in.csvImportXYDataFromRow(data, 2);
                    break;
                }
                case AREA_SUMCLEAN: {
                    this.sum_clean.csvImportXYDataFromRow(data, 2);
                    break;
                }
                case AREA_FLYPRESENT: {
                    this.flyPresent.csvImportXYDataFromRow(data, 2);
                    break;
                }
            }
        } else if (!x && y) {
            switch (measureType) {
                case AREA_SUM: {
                    this.sum_in.csvImportYDataFromRow(data, 2);
                    break;
                }
                case AREA_SUMCLEAN: {
                    this.sum_clean.csvImportYDataFromRow(data, 2);
                    break;
                }
                case AREA_FLYPRESENT: {
                    this.flyPresent.csvImportYDataFromRow(data, 2);
                    break;
                }
            }
        }
    }
}

