/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS.experiment.spots;

import icy.roi.ROI;
import icy.roi.ROI2D;
import icy.sequence.Sequence;
import icy.type.geom.Polygon2D;
import icy.util.XMLUtil;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import plugins.fmp.multiSPOTS.experiment.KymoIntervals;
import plugins.fmp.multiSPOTS.experiment.spots.EnumSpotMeasures;
import plugins.fmp.multiSPOTS.experiment.spots.Spot;
import plugins.fmp.multiSPOTS.experiment.spots.SpotsDescription;
import plugins.fmp.multiSPOTS.series.BuildSeriesOptions;
import plugins.fmp.multiSPOTS.tools.Comparators;
import plugins.fmp.multiSPOTS.tools.ROI2D.ROI2DAlongT;
import plugins.fmp.multiSPOTS.tools.ROI2D.ROIUtilities;
import plugins.fmp.multiSPOTS.tools.polyline.Level2D;
import plugins.fmp.multiSPOTS.tools.toExcel.EnumXLSExportType;
import plugins.kernel.roi.roi2d.ROI2DPolygon;
import plugins.kernel.roi.roi2d.ROI2DShape;

public class SpotsArray {
    public SpotsDescription spotsDescription = new SpotsDescription();
    public ArrayList<Spot> spotsList = new ArrayList();
    public int nColumnsPerPlate = 12;
    public int nRowsPerPlate = 8;
    public int nColumnsPerCage = 2;
    public int nRowsPerCage = 1;
    private KymoIntervals spotsListTimeIntervals = null;
    private static final String ID_SPOTTRACK = "spotTrack";
    private static final String ID_NSPOTS = "N_spots";
    private static final String ID_NCOLUMNSPERPLATE = "N_columns";
    private static final String ID_NROWSPERPLATE = "N_rows";
    private static final String ID_NCOLUMNSPERCAGE = "N_columns_per_cage";
    private static final String ID_NROWSPERCAGE = "N_rows_per_cage";
    private static final String ID_LISTOFSPOTS = "List_of_spots";
    private static final String ID_SPOT_ = "spot_";
    private static final String ID_MCSPOTS_XML = "MCspots.xml";
    private final String csvFileName = "SpotsMeasures.csv";
    final String csvSep = ";";

    public boolean load_Measures(String directory) {
        boolean flag = false;
        try {
            flag = this.csvLoadSpots(directory, EnumSpotMeasures.SPOTS_MEASURES);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }

    public boolean load_Spots(String directory) {
        boolean flag = false;
        try {
            flag = this.csvLoadSpots(directory, EnumSpotMeasures.ALL);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }

    public boolean save_Spots(String directory) {
        boolean flag = false;
        try {
            flag = this.csvSaveSpots(directory);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }

    public boolean save_Measures(String directory) {
        if (directory == null) {
            return false;
        }
        this.csvSaveSpots(directory);
        return true;
    }

    public String getXMLSpotsName() {
        return ID_MCSPOTS_XML;
    }

    private boolean xmlSave_ListOfSpots(Document doc) {
        Element node = XMLUtil.getElement((Node)XMLUtil.getRootElement((Document)doc), (String)ID_SPOTTRACK);
        if (node == null) {
            return false;
        }
        XMLUtil.setElementIntValue((Node)node, (String)"version", (int)2);
        Element nodeSpotsArray = XMLUtil.setElement((Node)node, (String)ID_LISTOFSPOTS);
        XMLUtil.setElementIntValue((Node)nodeSpotsArray, (String)ID_NSPOTS, (int)this.spotsList.size());
        XMLUtil.setElementIntValue((Node)nodeSpotsArray, (String)ID_NCOLUMNSPERPLATE, (int)this.nColumnsPerPlate);
        XMLUtil.setElementIntValue((Node)nodeSpotsArray, (String)ID_NROWSPERPLATE, (int)this.nRowsPerPlate);
        XMLUtil.setElementIntValue((Node)nodeSpotsArray, (String)ID_NCOLUMNSPERCAGE, (int)this.nColumnsPerCage);
        XMLUtil.setElementIntValue((Node)nodeSpotsArray, (String)ID_NROWSPERCAGE, (int)this.nRowsPerCage);
        int i = 0;
        Collections.sort(this.spotsList);
        for (Spot spot : this.spotsList) {
            Element nodeSpot = XMLUtil.setElement((Node)node, (String)(ID_SPOT_ + i));
            spot.saveToXML_SpotOnly(nodeSpot);
            ++i;
        }
        return true;
    }

    public boolean xmlSave_MCSpots_Descriptors(String csFileName) {
        Document doc;
        if (csFileName != null && (doc = XMLUtil.createDocument((boolean)true)) != null) {
            this.spotsDescription.xmlSaveSpotsDescription(doc);
            this.xmlSave_ListOfSpots(doc);
            return XMLUtil.saveDocument((Document)doc, (String)csFileName);
        }
        return false;
    }

    public boolean xmlLoad_MCSpots_Descriptors(String csFileName) {
        boolean flag = false;
        if (csFileName == null) {
            return flag;
        }
        Document doc = XMLUtil.loadDocument((String)csFileName);
        if (doc != null) {
            this.spotsDescription.xmlLoadSpotsDescription(doc);
            flag = this.xmlLoad_Spots_Only_v1(doc);
        }
        return flag;
    }

    private boolean xmlLoad_Spots_Only_v1(Document doc) {
        Element node = XMLUtil.getElement((Node)XMLUtil.getRootElement((Document)doc), (String)ID_SPOTTRACK);
        if (node == null) {
            return false;
        }
        Element nodecaps = XMLUtil.getElement((Node)node, (String)ID_LISTOFSPOTS);
        int nitems = XMLUtil.getElementIntValue((Node)nodecaps, (String)ID_NSPOTS, (int)0);
        this.nColumnsPerPlate = XMLUtil.getElementIntValue((Node)nodecaps, (String)ID_NCOLUMNSPERPLATE, (int)12);
        this.nRowsPerPlate = XMLUtil.getElementIntValue((Node)nodecaps, (String)ID_NROWSPERPLATE, (int)8);
        this.nColumnsPerCage = XMLUtil.getElementIntValue((Node)nodecaps, (String)ID_NCOLUMNSPERCAGE, (int)2);
        this.nRowsPerCage = XMLUtil.getElementIntValue((Node)nodecaps, (String)ID_NROWSPERCAGE, (int)1);
        this.spotsList = new ArrayList(nitems);
        for (int i = 0; i < nitems; ++i) {
            Element nodecapillary = XMLUtil.getElement((Node)node, (String)(ID_SPOT_ + i));
            Spot spot = new Spot();
            spot.loadFromXML_SpotOnly(nodecapillary);
            if (this.isPresent(spot)) continue;
            this.spotsList.add(spot);
        }
        return true;
    }

    public void copy(SpotsArray sourceSpotArray) {
        this.spotsDescription.copy(sourceSpotArray.spotsDescription);
        this.spotsList.clear();
        for (Spot sourceSpot : sourceSpotArray.spotsList) {
            Spot spot = new Spot();
            spot.copySpot(sourceSpot);
            this.spotsList.add(spot);
        }
    }

    public boolean isPresent(Spot capNew) {
        boolean flag = false;
        for (Spot spot : this.spotsList) {
            if (!spot.getRoi().getName().contentEquals(capNew.getRoi().getName())) continue;
            flag = true;
            break;
        }
        return flag;
    }

    public void mergeLists(SpotsArray sourceSpotList) {
        for (Spot spot : sourceSpotList.spotsList) {
            if (this.isPresent(spot)) continue;
            this.spotsList.add(spot);
        }
    }

    public void adjustSpotsLevel2DMeasuresToImageWidth(int imageWidth) {
        for (Spot spot : this.spotsList) {
            spot.adjustLevel2DMeasuresToImageWidth(imageWidth);
        }
    }

    public void cropSpotsLevel2DMeasuresToImageWidth(int imageWidth) {
        for (Spot spot : this.spotsList) {
            spot.cropLevel2DMeasuresToImageWidth(imageWidth);
        }
    }

    public Spot getSpotFromName(String name) {
        Spot spotFound = null;
        for (Spot spot : this.spotsList) {
            if (!spot.getRoi().getName().equals(name)) continue;
            spotFound = spot;
            break;
        }
        return spotFound;
    }

    public Spot getSpotContainingName(String name) {
        Spot spotFound = null;
        for (Spot spot : this.spotsList) {
            if (!spot.getRoi().getName().contains(name)) continue;
            spotFound = spot;
            break;
        }
        return spotFound;
    }

    public int getCageIndexFromPlateIndex(int plateIndex) {
        int plateColumn = plateIndex % this.nColumnsPerPlate;
        int cageColumn = plateColumn / this.nColumnsPerCage;
        int plateRow = plateIndex / this.nColumnsPerPlate;
        int cageRow = plateRow / this.nRowsPerCage;
        int nCagesAlongX = this.nColumnsPerPlate / this.nColumnsPerCage;
        int cageID = cageRow * nCagesAlongX + cageColumn;
        return cageID;
    }

    public void updatePlateIndexToCageIndexes(int nColsPerCage, int nRowsPerCage) {
        this.nColumnsPerCage = nColsPerCage;
        this.nRowsPerCage = nRowsPerCage;
        for (Spot spot : this.spotsList) {
            spot.cageID = this.getCageIndexFromPlateIndex(spot.plateIndex);
            int spotCageColumn = spot.plateColumn % nColsPerCage;
            int spotCageRow = spot.plateRow % nRowsPerCage;
            spot.cagePosition = spotCageRow * nColsPerCage + spotCageColumn;
            spot.setSpotRoi_InColorAccordingToSpotIndex(spot.cagePosition);
        }
    }

    public void transferROIsFromSequenceToSpots(Sequence seq) {
        List<ROI> listROISSpot = ROIUtilities.getROIsContainingString("spot", seq);
        Collections.sort(listROISSpot, new Comparators.ROI_Name_Comparator());
        block0: for (Spot spot : this.spotsList) {
            spot.valid = false;
            String spotName = spot.getRoi().getName();
            Iterator<ROI> iterator = listROISSpot.iterator();
            while (iterator.hasNext()) {
                ROI roi = iterator.next();
                String roiName = roi.getName();
                if (roiName.equals(spotName) && roi instanceof ROI2DShape) {
                    spot.setRoi((ROI2DShape)roi);
                    spot.valid = true;
                }
                if (!spot.valid) continue;
                iterator.remove();
                continue block0;
            }
        }
        Iterator<Spot> iterator = this.spotsList.iterator();
        while (iterator.hasNext()) {
            Spot spot;
            spot = iterator.next();
            if (spot.valid) continue;
            iterator.remove();
        }
        if (listROISSpot.size() > 0) {
            for (ROI roi : listROISSpot) {
                Spot spot = new Spot((ROI2DShape)roi);
                if (this.isPresent(spot)) continue;
                this.spotsList.add(spot);
            }
        }
        Collections.sort(this.spotsList);
    }

    public void transferROIsMeasuresFromSequenceToSpots() {
        for (Spot spot : this.spotsList) {
            spot.transferROIsMeasuresToLevel2D();
        }
    }

    public void transferSpotsToSequenceAsROIs(Sequence seq) {
        seq.removeROIs(ROIUtilities.getROIsContainingString("spot", seq), false);
        ArrayList<ROI2D> spotROIList = new ArrayList<ROI2D>(this.spotsList.size());
        for (Spot spot : this.spotsList) {
            spotROIList.add(spot.getRoi());
        }
        seq.addROIs(spotROIList, true);
    }

    public void transferSpotsMeasuresToSequenceAsROIs(Sequence seq) {
        List seqRoisList = seq.getROI2Ds(false);
        ROIUtilities.removeROIsMissingChar(seqRoisList, '_');
        ArrayList<ROI2D> newRoisList = new ArrayList<ROI2D>();
        int nspots = this.spotsList.size();
        int height = seq.getHeight();
        for (int i = 0; i < nspots; ++i) {
            List<ROI2D> listOfRois = this.spotsList.get(i).transferSpotMeasuresToROIs(height);
            for (ROI2D roi : listOfRois) {
                if (roi == null) continue;
                roi.setT(i);
            }
            newRoisList.addAll(listOfRois);
        }
        ROIUtilities.mergeROIsListNoDuplicate(seqRoisList, newRoisList, seq);
        seq.removeAllROI();
        seq.addROIs((Collection)seqRoisList, false);
    }

    public void initSpotsWithNFlies(int nflies) {
        int spotArraySize = this.spotsList.size();
        for (int i = 0; i < spotArraySize; ++i) {
            Spot spot = this.spotsList.get(i);
            spot.spotNFlies = nflies;
        }
    }

    public Polygon2D getPolygon2DEnclosingAllSpots() {
        if (this.spotsList.size() < 1) {
            return null;
        }
        ArrayList<Point2D.Double> points = new ArrayList<Point2D.Double>();
        int spotX = this.spotsList.get((int)0).spotXCoord;
        int spotY = this.spotsList.get((int)0).spotYCoord;
        points.add(new Point2D.Double(spotX, spotY));
        points.add(new Point2D.Double(spotX + 1, spotY));
        points.add(new Point2D.Double(spotX + 1, spotY + 1));
        points.add(new Point2D.Double(spotX, spotY + 1));
        Polygon2D polygon = new Polygon2D(points);
        for (Spot spot : this.spotsList) {
            int col = spot.plateColumn;
            int row = spot.plateRow;
            if (col == 0 && row == 0) {
                this.replaceItem(polygon, 0, spot);
                continue;
            }
            if (col == this.nColumnsPerPlate - 1 && row == 0) {
                this.replaceItem(polygon, 1, spot);
                continue;
            }
            if (col == this.nColumnsPerPlate - 1 && row == this.nRowsPerPlate - 1) {
                this.replaceItem(polygon, 2, spot);
                continue;
            }
            if (col != 0 || row != this.nRowsPerPlate - 1) continue;
            this.replaceItem(polygon, 3, spot);
        }
        return polygon;
    }

    private void replaceItem(Polygon2D polygon, int index, Spot spot) {
        polygon.xpoints[index] = spot.spotXCoord;
        polygon.ypoints[index] = spot.spotYCoord;
    }

    public ArrayList<Spot> getSpotsEnclosed(ROI2DPolygon envelopeRoi) {
        ArrayList<Spot> enclosedSpots = new ArrayList<Spot>();
        if (envelopeRoi != null) {
            for (Spot spot : this.spotsList) {
                try {
                    if (!envelopeRoi.contains((ROI)spot.getRoi())) continue;
                    spot.getRoi().setSelected(true);
                    enclosedSpots.add(spot);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        } else {
            for (Spot spot : this.spotsList) {
                if (!spot.getRoi().isSelected()) continue;
                enclosedSpots.add(spot);
            }
        }
        return enclosedSpots;
    }

    public double getScalingFactorToPhysicalUnits(EnumXLSExportType xlsoption) {
        double scalingFactorToPhysicalUnits = 1.0;
        return scalingFactorToPhysicalUnits;
    }

    public Polygon2D get2DPolygonEnclosingSpots() {
        Rectangle outerRectangle = null;
        for (Spot spot : this.spotsList) {
            Rectangle rect = spot.getRoi().getBounds();
            if (outerRectangle == null) {
                outerRectangle = rect;
                continue;
            }
            outerRectangle.add(rect);
        }
        if (outerRectangle == null) {
            return null;
        }
        return new Polygon2D(outerRectangle);
    }

    public void transferSumToSumClean() {
        int span = 10;
        for (Spot spot : this.spotsList) {
            if (spot.sum_in.values != null) {
                spot.sum_clean.buildRunningMedian(span, spot.sum_in.values);
                continue;
            }
            Level2D level = spot.sum_in.getLevel2D();
            if (level == null || level.npoints <= 0) continue;
            spot.sum_clean.buildRunningMedian(span, level.ypoints);
        }
    }

    public void initLevel2DMeasures() {
        for (Spot spot : this.spotsList) {
            spot.initLevel2DMeasures();
        }
    }

    public int getSpotIndexFromPlateCoordinates(String rowLetter, String columnNumber) {
        int index = 0;
        int col = 0;
        try {
            col = Integer.parseInt(columnNumber);
        }
        catch (NumberFormatException e1) {
            col = 0;
        }
        int row = this.getNumericReferenceNumber(rowLetter);
        index = row * this.nColumnsPerPlate + col;
        return index;
    }

    private int getNumericReferenceNumber(String str) {
        String result = "";
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (Character.isLetter(ch)) {
                int initialCharacter = Character.isUpperCase(ch) ? 65 : 97;
                result = result.concat(String.valueOf(ch - initialCharacter));
                continue;
            }
            result = result + ch;
        }
        return Integer.parseInt(result);
    }

    public KymoIntervals getKymoIntervalsFromSpots() {
        if (this.spotsListTimeIntervals == null) {
            this.spotsListTimeIntervals = new KymoIntervals();
            for (Spot spot : this.spotsList) {
                for (ROI2DAlongT roiFK : spot.getROIAlongTList()) {
                    Long[] interval = new Long[]{roiFK.getT(), -1L};
                    this.spotsListTimeIntervals.addIfNew(interval);
                }
            }
        }
        return this.spotsListTimeIntervals;
    }

    public int findKymoROI2DIntervalStart(long intervalT) {
        return this.spotsListTimeIntervals.findStartItem(intervalT);
    }

    public long getKymoROI2DIntervalsStartAt(int selectedItem) {
        return this.spotsListTimeIntervals.get(selectedItem)[0];
    }

    public int addKymoROI2DInterval(long start) {
        Long[] interval = new Long[]{start, -1L};
        int item = this.spotsListTimeIntervals.addIfNew(interval);
        for (Spot spot : this.spotsList) {
            List<ROI2DAlongT> listROI2DForKymo = spot.getROIAlongTList();
            ROI2D roi = spot.getRoi();
            if (item > 0) {
                roi = (ROI2D)listROI2DForKymo.get(item - 1).getRoi_in().getCopy();
            }
            listROI2DForKymo.add(item, new ROI2DAlongT(start, roi));
        }
        return item;
    }

    public void deleteKymoROI2DInterval(long start) {
        this.spotsListTimeIntervals.deleteIntervalStartingAt(start);
        for (Spot spot : this.spotsList) {
            spot.removeROIAlongTListItem(start);
        }
    }

    private boolean csvLoadSpots(String directory, EnumSpotMeasures option) throws Exception {
        String row;
        String pathToCsv = directory + File.separator + "SpotsMeasures.csv";
        File csvFile = new File(pathToCsv);
        if (!csvFile.isFile()) {
            return false;
        }
        BufferedReader bufferedReader = new BufferedReader(new FileReader(pathToCsv));
        String sep = ";";
        while ((row = bufferedReader.readLine()) != null) {
            String[] data;
            if (row.charAt(0) == '#') {
                sep = String.valueOf(row.charAt(1));
            }
            if (!(data = row.split(sep))[0].equals("#")) continue;
            switch (data[1]) {
                case "DESCRIPTION": {
                    this.csvLoadDescription(bufferedReader, sep);
                    break;
                }
                case "SPOTS": {
                    this.csvLoadSpotsArray(bufferedReader, sep);
                    break;
                }
                case "AREA_SUM": {
                    this.csvLoadSpotsMeasures(bufferedReader, EnumSpotMeasures.AREA_SUM, sep);
                    break;
                }
                case "AREA_OUT": {
                    this.csvLoadSpotsMeasures(bufferedReader, EnumSpotMeasures.AREA_OUT, sep);
                    break;
                }
                case "AREA_DIFF": {
                    this.csvLoadSpotsMeasures(bufferedReader, EnumSpotMeasures.AREA_DIFF, sep);
                    break;
                }
                case "AREA_SUMCLEAN": {
                    this.csvLoadSpotsMeasures(bufferedReader, EnumSpotMeasures.AREA_SUMCLEAN, sep);
                    break;
                }
                case "AREA_FLYPRESENT": {
                    this.csvLoadSpotsMeasures(bufferedReader, EnumSpotMeasures.AREA_FLYPRESENT, sep);
                    break;
                }
            }
        }
        bufferedReader.close();
        return true;
    }

    private String csvLoadSpotsArray(BufferedReader csvReader, String csvSep) {
        try {
            String row = csvReader.readLine();
            String[] data0 = row.split(csvSep);
            boolean dummyColumn = data0[0].contains("prefix");
            while ((row = csvReader.readLine()) != null) {
                String[] data = row.split(csvSep);
                if (data[0].equals("#")) {
                    return data[1];
                }
                Spot spot = this.getSpotFromName(data[dummyColumn ? 2 : 1]);
                if (spot == null) {
                    spot = new Spot();
                }
                spot.csvImportDescription(data, dummyColumn);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private String csvLoadDescription(BufferedReader csvReader, String csvSep) {
        try {
            String row = csvReader.readLine();
            row = csvReader.readLine();
            String[] data = row.split(csvSep);
            this.spotsDescription.csvImportSpotsDescriptionData(data);
            row = csvReader.readLine();
            data = row.split(csvSep);
            if (data[0].substring(0, Math.min(data[0].length(), 5)).equals("n spot")) {
                int nspots = Integer.valueOf(data[1]);
                if (nspots >= this.spotsList.size()) {
                    this.spotsList.ensureCapacity(nspots);
                } else {
                    this.spotsList.subList(nspots, this.spotsList.size()).clear();
                }
                row = csvReader.readLine();
                data = row.split(csvSep);
            }
            if (data[0].equals("#")) {
                return data[1];
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private String csvLoadSpotsMeasures(BufferedReader csvReader, EnumSpotMeasures measureType, String csvSep) {
        try {
            String row = csvReader.readLine();
            boolean y = true;
            boolean x = row.contains("xi");
            while ((row = csvReader.readLine()) != null) {
                String[] data = row.split(csvSep);
                if (data[0].equals("#")) {
                    return data[1];
                }
                Spot spot = this.getSpotFromName(data[0]);
                if (spot == null) {
                    spot = new Spot();
                }
                spot.csvImportMeasures_OneType(measureType, data, x, y);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private boolean csvSaveSpots(String directory) {
        Path path = Paths.get(directory, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            return false;
        }
        try {
            FileWriter csvWriter = new FileWriter(directory + File.separator + "SpotsMeasures.csv");
            this.csvSave_DescriptionSection(csvWriter);
            this.csvSave_MeasuresSection(csvWriter, EnumSpotMeasures.AREA_SUM);
            this.csvSave_MeasuresSection(csvWriter, EnumSpotMeasures.AREA_SUMCLEAN);
            this.csvSave_MeasuresSection(csvWriter, EnumSpotMeasures.AREA_OUT);
            this.csvSave_MeasuresSection(csvWriter, EnumSpotMeasures.AREA_DIFF);
            this.csvSave_MeasuresSection(csvWriter, EnumSpotMeasures.AREA_FLYPRESENT);
            csvWriter.flush();
            csvWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }

    private boolean csvSave_DescriptionSection(FileWriter csvWriter) {
        try {
            csvWriter.append(this.spotsDescription.csvExportSectionHeader(";"));
            csvWriter.append(this.spotsDescription.csvExportExperimentDescriptors(";"));
            csvWriter.append("n spots=;" + Integer.toString(this.spotsList.size()) + "\n");
            csvWriter.append("#;#\n");
            if (this.spotsList.size() > 0) {
                csvWriter.append(this.spotsList.get(0).csvExportSpotArrayHeader(";"));
                for (Spot spot : this.spotsList) {
                    csvWriter.append(spot.csvExportDescription(";"));
                }
                csvWriter.append("#;#\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }

    private boolean csvSave_MeasuresSection(FileWriter csvWriter, EnumSpotMeasures measureType) {
        try {
            if (this.spotsList.size() <= 1) {
                return false;
            }
            csvWriter.append(this.spotsList.get(0).csvExportMeasures_SectionHeader(measureType, ";"));
            for (Spot spot : this.spotsList) {
                csvWriter.append(spot.csvExportMeasures_OneType(measureType, ";"));
            }
            csvWriter.append("#;#\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }

    public void setFilterOfSpotsToAnalyze(boolean setFilter, BuildSeriesOptions options) {
        for (Spot spot : this.spotsList) {
            spot.okToAnalyze = true;
            if (!setFilter) continue;
            if (!options.detectL && spot.isL()) {
                spot.okToAnalyze = false;
            }
            if (!options.detectR && spot.isR()) {
                spot.okToAnalyze = false;
            }
            if (!options.detectSelectedROIs || spot.isIndexSelected(options.selectedIndexes)) continue;
            spot.okToAnalyze = false;
        }
    }
}

