/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS.series;

import icy.gui.frame.progress.ProgressFrame;
import icy.gui.viewer.Viewer;
import icy.image.IcyBufferedImage;
import icy.roi.ROI;
import icy.sequence.Sequence;
import icy.system.thread.Processor;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.imageio.ImageIO;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import plugins.fmp.multiSPOTS.experiment.Experiment;
import plugins.fmp.multiSPOTS.series.BuildSeriesOptions;
import plugins.fmp.multiSPOTS.tools.JComponents.JComboBoxExperiment;
import plugins.fmp.multiSPOTS.tools.ViewerFMP;
import plugins.kernel.roi.roi2d.ROI2DRectangle;

public abstract class BuildSeries
extends SwingWorker<Integer, Integer> {
    public BuildSeriesOptions options = new BuildSeriesOptions();
    public boolean stopFlag = false;
    public boolean threadRunning = false;
    int nframescomputed = 0;
    int nframestotal = 0;
    int selectedExperimentIndex = -1;
    Sequence seqNegative = null;
    ViewerFMP vNegative = null;
    public final String THREAD_ENDED = "thread_ended";
    public final String THREAD_DONE = "thread_done";

    @Override
    protected Integer doInBackground() throws Exception {
        System.out.println("BuildSeries:doInBackground loop over experiments");
        this.threadRunning = true;
        int nbiterations = 0;
        JComboBoxExperiment expList = this.options.expList;
        ProgressFrame progress = new ProgressFrame("Analyze series");
        this.selectedExperimentIndex = expList.getSelectedIndex();
        this.selectList(expList, -1);
        int index = expList.index0;
        while (index <= expList.index1 && !this.stopFlag) {
            long startTimeInNs = System.nanoTime();
            Experiment exp = (Experiment)expList.getItemAt(index);
            progress.setMessage("Processing file: " + (index + 1) + "//" + (expList.index1 + 1));
            System.out.println("BuildSeries:doInBackground " + (index + 1) + ": " + exp.getResultsDirectory());
            exp.setBinSubDirectory(this.options.binSubDirectory);
            boolean flag = exp.createDirectoryIfDoesNotExist(exp.getKymosBinFullDirectory());
            if (flag) {
                this.analyzeExperiment(exp);
                long endTime2InNs = System.nanoTime();
                System.out.println("BuildSeries:doInBackground process ended - duration: " + (float)(endTime2InNs - startTimeInNs) / 1.0E9f + " s");
            } else {
                System.out.println("BuildSeries:doInBackground process aborted - subdirectory not created: " + exp.getKymosBinFullDirectory());
            }
            ++index;
            ++nbiterations;
        }
        progress.close();
        this.threadRunning = false;
        this.selectList(expList, this.selectedExperimentIndex);
        return nbiterations;
    }

    private void selectList(final JComboBoxExperiment expList, final int index) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    expList.setSelectedIndex(index);
                }
            });
        }
        catch (InterruptedException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void done() {
        int statusMsg = 0;
        try {
            statusMsg = (Integer)super.get();
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
        }
        if (!this.threadRunning || this.stopFlag) {
            this.firePropertyChange("thread_ended", null, statusMsg);
        } else {
            this.firePropertyChange("thread_done", null, statusMsg);
        }
    }

    abstract void analyzeExperiment(Experiment var1);

    protected void waitFuturesCompletion(Processor processor, ArrayList<Future<?>> futuresArray, ProgressFrame progressBar) {
        int frame = 1;
        this.nframescomputed = futuresArray.size();
        this.nframestotal = 0;
        while (!futuresArray.isEmpty()) {
            Future<?> f = futuresArray.get(futuresArray.size() - 1);
            if (progressBar != null) {
                progressBar.setMessage("Analyze frame: " + this.nframestotal + "//" + this.nframescomputed);
            }
            try {
                f.get();
            }
            catch (ExecutionException e) {
                System.out.println("BuildSeries:waitFuturesCompletion - frame:" + frame + " Execution exception: " + e);
            }
            catch (InterruptedException e) {
                System.out.println("BuildSeries:waitFuturesCompletion - Interrupted exception: " + e);
            }
            futuresArray.remove(f);
            ++frame;
        }
    }

    protected boolean checkBoundsForCages(Experiment exp) {
        exp.cagesArray.detectBin_Ms = this.options.t_Ms_BinDuration;
        if (this.options.isFrameFixed) {
            exp.cagesArray.detectFirst_Ms = this.options.t_Ms_First;
            exp.cagesArray.detectLast_Ms = this.options.t_Ms_Last;
            if (exp.cagesArray.detectLast_Ms > exp.seqCamData.lastImage_ms) {
                exp.cagesArray.detectLast_Ms = exp.seqCamData.lastImage_ms;
            }
        } else {
            exp.cagesArray.detectFirst_Ms = exp.seqCamData.firstImage_ms;
            exp.cagesArray.detectLast_Ms = exp.seqCamData.lastImage_ms;
        }
        exp.cagesArray.detect_threshold = this.options.threshold;
        boolean flag = true;
        if (exp.cagesArray.cagesList.size() < 1) {
            System.out.println("BuildSeries:checkBoundsForCages ! skipped experiment with no cage: " + exp.getResultsDirectory());
            flag = false;
        }
        return flag;
    }

    protected void getTimeLimitsOfSequence(Experiment exp) {
        exp.getFileIntervalsFromSeqCamData();
        exp.seqCamData.binDuration_ms = exp.seqCamData.binImage_ms;
        if (this.options.isFrameFixed) {
            exp.seqCamData.binFirst_ms = this.options.t_Ms_First;
            exp.seqCamData.binLast_ms = this.options.t_Ms_Last;
            if (exp.seqCamData.binLast_ms + exp.seqCamData.firstImage_ms > exp.seqCamData.lastImage_ms) {
                exp.seqCamData.binLast_ms = exp.seqCamData.lastImage_ms - exp.seqCamData.firstImage_ms;
            }
        } else {
            exp.seqCamData.binFirst_ms = 0L;
            exp.seqCamData.binLast_ms = exp.seqCamData.lastImage_ms - exp.seqCamData.firstImage_ms;
        }
    }

    public IcyBufferedImage imageIORead(String name) {
        BufferedImage image = null;
        try {
            image = ImageIO.read(new File(name));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return IcyBufferedImage.createFrom((BufferedImage)image);
    }

    protected boolean loadDrosoTrack(Experiment exp) {
        exp.seqCamData.seq = exp.seqCamData.initSequenceFromFirstImage(exp.seqCamData.getImagesList(true));
        boolean flag = exp.load_Cages();
        return flag;
    }

    void closeSequence(Sequence seq) {
        if (seq != null) {
            seq.close();
            seq = null;
        }
    }

    void closeViewer(Viewer v) {
        if (v != null) {
            v.close();
            v = null;
        }
    }

    Sequence newSequence(String title, IcyBufferedImage image) {
        Sequence seq = new Sequence();
        seq.setName(title);
        seq.setImage(0, 0, (BufferedImage)image);
        return seq;
    }

    void displayRectanglesAsROIs(Sequence seq, List<Rectangle2D> listRectangles, boolean eraseOldPoints) {
        if (eraseOldPoints) {
            seq.removeAllROI();
        }
        for (Rectangle2D rectangle : listRectangles) {
            ROI2DRectangle flyPoint = new ROI2DRectangle(rectangle);
            seq.addROI((ROI)flyPoint);
        }
    }

    void openFlyDetectViewers(final Experiment exp) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    BuildSeries.this.seqNegative = BuildSeries.this.newSequence("detectionImage", exp.seqCamData.refImage);
                    BuildSeries.this.vNegative = new ViewerFMP(BuildSeries.this.seqNegative, false, true);
                    BuildSeries.this.vNegative.setVisible(true);
                }
            });
        }
        catch (InterruptedException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }
}

