/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS.series;

import icy.gui.frame.progress.ProgressFrame;
import icy.image.IcyBufferedImage;
import icy.image.IcyBufferedImageCursor;
import icy.roi.BooleanMask2D;
import icy.roi.ROI2D;
import icy.sequence.Sequence;
import icy.system.SystemUtil;
import icy.system.thread.Processor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import plugins.fmp.multiSPOTS.experiment.Experiment;
import plugins.fmp.multiSPOTS.experiment.SequenceCamData;
import plugins.fmp.multiSPOTS.experiment.spots.Spot;
import plugins.fmp.multiSPOTS.series.BuildSeries;
import plugins.fmp.multiSPOTS.series.ResultsThreshold;
import plugins.fmp.multiSPOTS.tools.ROI2D.ROI2DAlongT;
import plugins.fmp.multiSPOTS.tools.ViewerFMP;
import plugins.fmp.multiSPOTS.tools.imageTransform.ImageTransformInterface;
import plugins.fmp.multiSPOTS.tools.imageTransform.ImageTransformOptions;
import plugins.kernel.roi.roi2d.ROI2DRectangle;

public class BuildSpotsMeasures
extends BuildSeries {
    public Sequence seqData = new Sequence();
    private ViewerFMP vData = null;
    private ImageTransformOptions transformOptions01 = null;
    ImageTransformInterface transformFunctionSpot = null;
    ImageTransformOptions transformOptions02 = null;
    ImageTransformInterface transformFunctionFly = null;

    @Override
    void analyzeExperiment(Experiment exp) {
        this.loadExperimentDataToMeasureSpots(exp);
        exp.spotsArray.setFilterOfSpotsToAnalyze(true, this.options);
        this.openViewers(exp);
        this.getTimeLimitsOfSequence(exp);
        if (this.measureSpots(exp)) {
            this.saveComputation(exp);
        }
        exp.spotsArray.setFilterOfSpotsToAnalyze(false, this.options);
        this.closeViewers();
    }

    private boolean loadExperimentDataToMeasureSpots(Experiment exp) {
        boolean flag = exp.load_Spots();
        exp.seqCamData.seq = exp.seqCamData.initSequenceFromFirstImage(exp.seqCamData.getImagesList(true));
        return flag;
    }

    private void saveComputation(Experiment exp) {
        String directory;
        if (this.options.doCreateBinDir) {
            exp.setBinSubDirectory(exp.getBinNameFromKymoFrameStep());
        }
        if ((directory = exp.getDirectoryToSaveResults()) == null) {
            return;
        }
        exp.spotsArray.transferSumToSumClean();
        exp.spotsArray.initLevel2DMeasures();
        exp.saveXML_MCExperiment();
        exp.save_SpotsMeasures();
    }

    private void initMeasureSpots(Experiment exp) {
        this.initMasks2D(exp);
        this.initSpotsDataArrays(exp);
        if (this.transformFunctionSpot == null) {
            this.transformOptions01 = new ImageTransformOptions();
            this.transformOptions01.transformOption = this.options.transform01;
            this.transformOptions01.copyResultsToThe3planes = false;
            this.transformOptions01.setSingleThreshold(this.options.spotThreshold, this.options.spotThresholdUp);
            this.transformFunctionSpot = this.options.transform01.getFunction();
            this.transformOptions02 = new ImageTransformOptions();
            this.transformOptions02.transformOption = this.options.transform02;
            this.transformOptions02.copyResultsToThe3planes = false;
            this.transformFunctionFly = this.options.transform02.getFunction();
        }
    }

    private boolean measureSpots(final Experiment exp) {
        if (exp.spotsArray.spotsList.size() < 1) {
            System.out.println("DetectAreas:measureAreas Abort (1): nbspots = 0");
            return false;
        }
        this.threadRunning = true;
        this.stopFlag = false;
        exp.build_MsTimeIntervalsArray_From_SeqCamData_FileNamesList();
        final int iiFirst = 0;
        final int iiLast = exp.seqCamData.fixedNumberOfImages > 0L ? (int)exp.seqCamData.fixedNumberOfImages : exp.seqCamData.nTotalFrames;
        this.vData.setTitle(exp.seqCamData.getCSCamFileName() + ": " + iiFirst + "-" + iiLast);
        final ProgressFrame progressBar1 = new ProgressFrame("Analyze stack");
        Processor processor = new Processor(SystemUtil.getNumberOfCPUs());
        processor.setThreadName("measureSpots");
        processor.setPriority(5);
        int ntasks = iiLast - iiFirst;
        ArrayList tasks = new ArrayList(ntasks);
        tasks.clear();
        this.initMeasureSpots(exp);
        int ii = iiFirst;
        while (ii < iiLast) {
            if (this.options.concurrentDisplay) {
                IcyBufferedImage sourceImage0 = this.imageIORead(exp.seqCamData.getFileNameFromImageList(ii));
                this.seqData.setImage(0, 0, (BufferedImage)sourceImage0);
                this.vData.setTitle("Frame #" + ii + " /" + iiLast);
            }
            final int t = ii++;
            final IcyBufferedImage sourceImage = this.imageIORead(exp.seqCamData.getFileNameFromImageList(t));
            tasks.add(processor.submit(new Runnable(){

                @Override
                public void run() {
                    progressBar1.setMessage("Analyze frame: " + t + "//" + iiLast);
                    double background = 0.0;
                    IcyBufferedImage transformToMeasureArea = BuildSpotsMeasures.this.transformFunctionSpot.getTransformedImage(sourceImage, BuildSpotsMeasures.this.transformOptions01);
                    IcyBufferedImage transformToDetectFly = BuildSpotsMeasures.this.transformFunctionFly.getTransformedImage(sourceImage, BuildSpotsMeasures.this.transformOptions02);
                    IcyBufferedImageCursor cursorToDetectFly = new IcyBufferedImageCursor(transformToDetectFly);
                    IcyBufferedImageCursor cursorToMeasureArea = new IcyBufferedImageCursor(transformToMeasureArea);
                    if (BuildSpotsMeasures.this.options.compensateBackground) {
                        ROI2DAlongT outerRoiT = BuildSpotsMeasures.this.getROI2DAlongTEnclosingAllSpots(exp, t);
                        ResultsThreshold outerResult = BuildSpotsMeasures.this.measureSpotOverThreshold(cursorToMeasureArea, cursorToDetectFly, outerRoiT);
                        background = outerResult.sumTot_no_fly_over_threshold / (double)outerResult.nPoints_no_fly;
                    }
                    double final_background = background;
                    int ii = t - iiFirst;
                    for (Spot spot : exp.spotsArray.spotsList) {
                        if (!spot.okToAnalyze) continue;
                        ROI2DAlongT roiT = spot.getROIAtT(t);
                        ResultsThreshold results = BuildSpotsMeasures.this.measureSpotOverThreshold(cursorToMeasureArea, cursorToDetectFly, roiT);
                        spot.flyPresent.isPresent[ii] = results.nPoints_fly_present;
                        spot.sum_in.values[ii] = results.sumOverThreshold / (double)results.npoints_in - final_background;
                        if (results.nPoints_no_fly == results.npoints_in) continue;
                        spot.sum_in.values[ii] = results.sumTot_no_fly_over_threshold / (double)results.nPoints_no_fly - final_background;
                    }
                }
            }));
        }
        this.waitFuturesCompletion(processor, tasks, null);
        progressBar1.close();
        return true;
    }

    ROI2DAlongT getROI2DAlongTEnclosingAllSpots(Experiment exp, int t) {
        Rectangle2D rect = this.getRectangleEnclosingAllSpots(exp, t);
        ROI2DRectangle roiRect = new ROI2DRectangle(rect);
        try {
            BooleanMask2D roiRectMask = roiRect.getBooleanMask(true);
            for (Spot spot : exp.spotsArray.spotsList) {
                BooleanMask2D mask = spot.getROIAtT(t).getMask2D_in();
                roiRectMask.subtract(mask.bounds, mask.mask);
            }
            ROI2DAlongT roiT = new ROI2DAlongT(0L, (ROI2D)roiRect);
            roiT.setMask2D_in(roiRectMask);
            roiT.mask2DPoints_in = roiT.mask2D_in.getPoints();
            return roiT;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return null;
        }
    }

    Rectangle2D getRectangleEnclosingAllSpots(Experiment exp, int t) {
        Rectangle outerRectangle = exp.spotsArray.spotsList.get(0).getROIAtT(t).getRoi_in().getBounds();
        for (Spot spot : exp.spotsArray.spotsList) {
            Rectangle rect = spot.getROIAtT(t).getRoi_in().getBounds();
            Rectangle2D.union(outerRectangle, rect, outerRectangle);
        }
        return outerRectangle;
    }

    private ResultsThreshold measureSpotOverThreshold(IcyBufferedImageCursor cursorToMeasureArea, IcyBufferedImageCursor cursorToDetectFly, ROI2DAlongT roiT) {
        ResultsThreshold result = new ResultsThreshold();
        result.npoints_in = roiT.mask2DPoints_in.length;
        for (int offset = 0; offset < roiT.mask2DPoints_in.length; ++offset) {
            Point pt = roiT.mask2DPoints_in[offset];
            int value = (int)cursorToMeasureArea.get((int)pt.getX(), (int)pt.getY(), 0);
            int value_to_detect_fly = (int)cursorToDetectFly.get((int)pt.getX(), (int)pt.getY(), 0);
            boolean isFlyThere = this.isFlyPresent(value_to_detect_fly);
            if (!isFlyThere) {
                ++result.nPoints_no_fly;
            } else {
                ++result.nPoints_fly_present;
            }
            if (!this.isOverThreshold(value)) continue;
            result.sumOverThreshold += (double)value;
            ++result.nPointsOverThreshold;
            if (isFlyThere) continue;
            result.sumTot_no_fly_over_threshold += (double)value;
        }
        return result;
    }

    private boolean isFlyPresent(double value) {
        boolean flag;
        boolean bl = flag = value > (double)this.options.flyThreshold;
        if (!this.options.flyThresholdUp) {
            flag = !flag;
        }
        return flag;
    }

    private boolean isOverThreshold(double value) {
        boolean flag;
        boolean bl = flag = value > (double)this.options.spotThreshold;
        if (!this.options.spotThresholdUp) {
            flag = !flag;
        }
        return flag;
    }

    private void initSpotsDataArrays(Experiment exp) {
        int nFrames = exp.seqCamData.nTotalFrames;
        for (Spot spot : exp.spotsArray.spotsList) {
            int i = spot.plateIndex % 2;
            if (0 == i && !this.options.detectL || 1 == i && !this.options.detectR) continue;
            spot.sum_in.values = new double[nFrames];
            spot.sum_clean.values = new double[nFrames];
            spot.flyPresent.isPresent = new int[nFrames];
        }
    }

    private void initMasks2D(Experiment exp) {
        SequenceCamData seqCamData = exp.seqCamData;
        if (seqCamData.seq == null) {
            seqCamData.seq = exp.seqCamData.initSequenceFromFirstImage(exp.seqCamData.getImagesList(true));
        }
        for (Spot spot : exp.spotsArray.spotsList) {
            List<ROI2DAlongT> listRoiT = spot.getROIAlongTList();
            for (ROI2DAlongT roiT : listRoiT) {
                if (roiT.getMask2D_in() != null) continue;
                roiT.buildMask2DFromRoi_in();
            }
        }
    }

    private void closeViewers() {
        this.closeViewer(this.vData);
        this.closeSequence(this.seqData);
    }

    private void openViewers(final Experiment exp) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    BuildSpotsMeasures.this.seqData = BuildSpotsMeasures.this.newSequence(exp.seqCamData.getCSCamFileName(), exp.seqCamData.getSeqImage(0, 0));
                    BuildSpotsMeasures.this.vData = new ViewerFMP(BuildSpotsMeasures.this.seqData, true, true);
                }
            });
        }
        catch (InterruptedException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }
}

