/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS.tools.JComponents;

import javax.swing.table.AbstractTableModel;
import plugins.fmp.multiSPOTS.experiment.Experiment;
import plugins.fmp.multiSPOTS.experiment.spots.Spot;
import plugins.fmp.multiSPOTS.tools.JComponents.JComboBoxExperiment;

public class TableModelSpot
extends AbstractTableModel {
    private static final long serialVersionUID = 6325792669154093747L;
    private JComboBoxExperiment expList = null;
    String[] columnNames = new String[]{"Name", "IDCage", "PosCage", "N flies", "N pixels", "Volume", "Stimulus", "Concentration"};

    public TableModelSpot(JComboBoxExperiment expList) {
        this.expList = expList;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return String.class;
            }
            case 1: {
                return Integer.class;
            }
            case 2: {
                return Integer.class;
            }
            case 3: {
                return Integer.class;
            }
            case 4: {
                return Integer.class;
            }
            case 5: {
                return Double.class;
            }
            case 6: {
                return String.class;
            }
            case 7: {
                return String.class;
            }
        }
        return String.class;
    }

    @Override
    public String getColumnName(int column) {
        return this.columnNames[column];
    }

    @Override
    public int getRowCount() {
        if (this.expList != null && this.expList.getSelectedIndex() >= 0) {
            Experiment exp = (Experiment)this.expList.getSelectedItem();
            return exp.spotsArray.spotsList.size();
        }
        return 0;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Spot spot = this.getSpotAt(rowIndex);
        if (spot != null) {
            switch (columnIndex) {
                case 0: {
                    return spot.getRoi().getName();
                }
                case 1: {
                    return spot.cageID;
                }
                case 2: {
                    return spot.cagePosition;
                }
                case 3: {
                    return spot.spotNFlies;
                }
                case 4: {
                    return spot.spotNPixels;
                }
                case 5: {
                    return spot.spotVolume;
                }
                case 6: {
                    return spot.spotStim;
                }
                case 7: {
                    return spot.spotConc;
                }
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return false;
            }
        }
        return true;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        Spot spot = this.getSpotAt(rowIndex);
        if (spot != null) {
            switch (columnIndex) {
                case 0: {
                    spot.getRoi().setName(aValue.toString());
                    break;
                }
                case 1: {
                    spot.cageID = (Integer)aValue;
                    break;
                }
                case 2: {
                    spot.cagePosition = (Integer)aValue;
                    break;
                }
                case 3: {
                    spot.spotNFlies = (Integer)aValue;
                    break;
                }
                case 4: {
                    spot.spotNPixels = (Integer)aValue;
                    break;
                }
                case 5: {
                    spot.spotVolume = (Double)aValue;
                    break;
                }
                case 6: {
                    spot.spotStim = aValue.toString();
                    break;
                }
                case 7: {
                    spot.spotConc = aValue.toString();
                }
            }
        }
    }

    private Spot getSpotAt(int rowIndex) {
        Spot spot = null;
        if (this.expList != null && this.expList.getSelectedIndex() >= 0) {
            Experiment exp = (Experiment)this.expList.getSelectedItem();
            spot = exp.spotsArray.spotsList.get(rowIndex);
        }
        return spot;
    }
}

