/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS.tools.ROI2D;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import icy.image.IcyBufferedImage;
import icy.image.IcyBufferedImageUtil;
import icy.math.MathUtil;
import icy.roi.BooleanMask2D;
import icy.roi.ROI;
import icy.roi.ROI2D;
import icy.roi.ROIIterator;
import icy.sequence.Sequence;
import icy.type.collection.array.ArrayUtil;
import icy.type.point.Point5D;
import icy.type.rectangle.Rectangle5D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.vecmath.Point2d;
import javax.vecmath.Vector2d;
import plugins.fmp.multiSPOTS.experiment.spots.Spot;
import plugins.fmp.multiSPOTS.series.BuildSeriesOptions;
import plugins.kernel.roi.roi2d.ROI2DPoint;
import plugins.kernel.roi.roi2d.ROI2DPolygon;
import plugins.kernel.roi.roi3d.ROI3DPoint;

public class ROI2DMeasures {
    public static double[] computeOrientation(ROI roi, Sequence sequence) throws InterruptedException {
        double[] ellipse = new double[12];
        if (roi instanceof ROI2D) {
            try {
                Point2d radii = new Point2d();
                Vector2d[] eigenVectors = new Vector2d[2];
                ROI2DMeasures.fitEllipse((ROI2D)roi, null, radii, null, eigenVectors, null);
                radii.scale(2.0);
                ellipse[0] = radii.x;
                ellipse[1] = radii.y;
                Vector2d firstAxis = eigenVectors[0];
                ellipse[3] = MathUtil.round((double)firstAxis.x, (int)2);
                ellipse[4] = MathUtil.round((double)firstAxis.y, (int)2);
                Vector2d secondAxis = eigenVectors[1];
                ellipse[6] = MathUtil.round((double)secondAxis.x, (int)2);
                ellipse[7] = MathUtil.round((double)secondAxis.y, (int)2);
                ellipse[11] = 1.0;
            }
            catch (RuntimeException e) {
                Arrays.fill(ellipse, Double.NaN);
            }
        } else {
            System.err.println("Cannot compute ellipse dimensions for ROI of type: " + roi.getClassName());
            Arrays.fill(ellipse, Double.NaN);
        }
        if (sequence != null) {
            ellipse[0] = ellipse[0] * sequence.getPixelSizeX();
            ellipse[1] = ellipse[1] * sequence.getPixelSizeY();
            ellipse[2] = ellipse[2] * sequence.getPixelSizeZ();
        }
        Arrays.sort(ellipse, 0, 3);
        double tmp = ellipse[0];
        ellipse[0] = ellipse[2];
        ellipse[2] = tmp;
        return ellipse;
    }

    public static void fitEllipse(ROI2D roi, Point2d center, Point2d radii, Double angle, Vector2d[] eigenVectors, double[] equation) throws RuntimeException, InterruptedException {
        Point[] points = roi.getBooleanMask(true).getContourPoints();
        if (points.length < 4) {
            return;
        }
        Point2D ccenter = ROI2DMeasures.computeMassCenter((ROI)roi).toPoint2D();
        double cx = ccenter.getX();
        double cy = ccenter.getY();
        double[][] d1 = new double[points.length][3];
        double[][] d2 = new double[points.length][3];
        for (int i = 0; i < d1.length; ++i) {
            double xixC = (double)points[i].x - cx;
            double yiyC = (double)points[i].y - cy;
            d1[i][0] = xixC * xixC;
            d1[i][1] = xixC * yiyC;
            d1[i][2] = yiyC * yiyC;
            d2[i][0] = xixC;
            d2[i][1] = yiyC;
            d2[i][2] = 1.0;
        }
        Matrix D1 = new Matrix(d1);
        Matrix D2 = new Matrix(d2);
        Matrix S1 = D1.transpose().times(D1);
        Matrix S2 = D1.transpose().times(D2);
        Matrix S3 = D2.transpose().times(D2);
        Matrix T = S3.inverse().times(-1.0).times(S2.transpose());
        Matrix M = S1.plus(S2.times(T));
        double[][] m = M.getArray();
        double[][] n = new double[][]{{m[2][0] / 2.0, m[2][1] / 2.0, m[2][2] / 2.0}, {-m[1][0], -m[1][1], -m[1][2]}, {m[0][0] / 2.0, m[0][1] / 2.0, m[0][2] / 2.0}};
        Matrix N = new Matrix((double[][])n);
        EigenvalueDecomposition E = N.eig();
        Matrix eVec = E.getV();
        Matrix R1 = eVec.getMatrix(0, 0, 0, 2);
        Matrix R2 = eVec.getMatrix(1, 1, 0, 2);
        Matrix R3 = eVec.getMatrix(2, 2, 0, 2);
        Matrix cond = R1.times(4.0).arrayTimes(R3).minus(R2.arrayTimes(R2));
        int _f = 0;
        for (int i = 0; i < 3; ++i) {
            if (!(cond.get(0, i) > 0.0)) continue;
            _f = i;
            break;
        }
        Matrix A1 = eVec.getMatrix(0, 2, _f, _f);
        Matrix A = new Matrix(6, 1);
        A.setMatrix(0, 2, 0, 0, A1);
        A.setMatrix(3, 5, 0, 0, T.times(A1));
        double[] ell = A.getColumnPackedCopy();
        double a4 = ell[3] - 2.0 * ell[0] * cx - ell[1] * cy;
        double a5 = ell[4] - 2.0 * ell[2] * cy - ell[1] * cx;
        double a6 = ell[5] + ell[0] * cx * cx + ell[2] * cy * cy + ell[1] * cx * cy - ell[3] * cx - ell[4] * cy;
        A.set(3, 0, a4);
        A.set(4, 0, a5);
        A.set(5, 0, a6);
        A = A.times(1.0 / A.normF());
        ell = A.getColumnPackedCopy();
        if (equation != null && equation.length != 6) {
            System.arraycopy(ell, 0, equation, 0, 6);
        }
        double a = ell[0];
        double b = ell[1] / 2.0;
        double c = ell[2];
        double d = ell[3] / 2.0;
        double f = ell[4] / 2.0;
        double g = ell[5];
        double cX = (c * d - b * f) / (b * b - a * c);
        double cY = (a * f - b * d) / (b * b - a * c);
        double af = 2.0 * (a * f * f + c * d * d + g * b * b - 2.0 * b * d * f - a * c * g);
        double aL = Math.sqrt(af / ((b * b - a * c) * (Math.sqrt((a - c) * (a - c) + 4.0 * b * b) - (a + c))));
        double bL = Math.sqrt(af / ((b * b - a * c) * (-Math.sqrt((a - c) * (a - c) + 4.0 * b * b) - (a + c))));
        double phi = 0.0;
        phi = b == 0.0 ? (Math.abs(a) <= Math.abs(c) ? 0.0 : 1.5707963267948966) : (Math.abs(a) <= Math.abs(c) ? Math.atan(2.0 * b / (a - c)) / 2.0 : Math.atan(2.0 * b / (a - c)) / 2.0 + 1.5707963267948966);
        if (center != null) {
            center.set(cX, cY);
        }
        if (radii != null) {
            radii.set(aL, bL);
        }
        if (angle != null) {
            angle = phi;
        }
        if (eigenVectors != null) {
            eigenVectors[0] = new Vector2d(Math.cos(phi), Math.sin(phi));
            eigenVectors[1] = new Vector2d(Math.cos(phi + 1.5707963267948966), Math.sin(phi + 1.5707963267948966));
        }
    }

    public static Point5D computeMassCenter(ROI roi) throws InterruptedException {
        Rectangle5D bounds = roi.getBounds5D();
        if (bounds.isEmpty()) {
            return bounds.getPosition();
        }
        if (roi instanceof ROI2DPoint || roi instanceof ROI3DPoint) {
            return bounds.getPosition();
        }
        ROIIterator it = new ROIIterator(roi, true);
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        double t = 0.0;
        double c = 0.0;
        long numPts = 0L;
        while (!it.done()) {
            if ((numPts & 0xFFFFL) == 0L && Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
            x += (double)it.getX();
            y += (double)it.getY();
            z += (double)it.getZ();
            t += (double)it.getT();
            c += (double)it.getC();
            it.next();
            ++numPts;
        }
        if (numPts == 0L) {
            return new Point5D.Double();
        }
        return new Point5D.Double(x / (double)numPts, y / (double)numPts, z / (double)numPts, t / (double)numPts, c / (double)numPts);
    }

    public static ROI2DPolygon getContourOfDetectedSpot(IcyBufferedImage workImage, Spot spot, BuildSeriesOptions options) {
        BooleanMask2D mask2d = ROI2DMeasures.getMaskOfThresholdedImage(workImage, spot, options);
        List<Point> points = ROI2DMeasures.getLargestContourFromThresholdedImage(mask2d);
        if (points != null) {
            List points2s = points.stream().map(point -> new Point2D.Double(point.getX(), point.getY())).collect(Collectors.toList());
            ROI2DPolygon roi = new ROI2DPolygon(points2s);
            return roi;
        }
        return null;
    }

    private static BooleanMask2D getMaskOfThresholdedImage(IcyBufferedImage workImage, Spot spot, BuildSeriesOptions options) {
        boolean spotThresholdUp = options.spotThresholdUp;
        int spotThreshold = options.spotThreshold;
        Rectangle rectSpot = spot.mask2DSpot.bounds;
        IcyBufferedImage subWorkImage = IcyBufferedImageUtil.getSubImage((IcyBufferedImage)workImage, (Rectangle)rectSpot);
        boolean[] mask = spot.mask2DSpot.mask;
        int[] workData = (int[])ArrayUtil.arrayToIntArray((Object)subWorkImage.getDataXY(0), (boolean)workImage.isSignedDataType());
        if (spotThresholdUp) {
            for (int offset = 0; offset < workData.length; ++offset) {
                if (!mask[offset]) continue;
                mask[offset] = workData[offset] < spotThreshold;
            }
        } else {
            for (int offset = 0; offset < workData.length; ++offset) {
                if (!mask[offset]) continue;
                mask[offset] = workData[offset] > spotThreshold;
            }
        }
        return new BooleanMask2D(rectSpot, mask);
    }

    private static List<Point> getLargestContourFromThresholdedImage(BooleanMask2D mask2d) {
        List points = null;
        BooleanMask2D[] components = null;
        int maxPoints = 0;
        try {
            components = mask2d.getComponents();
            int itemMax = 0;
            if (components.length > 0) {
                for (int i = 0; i < components.length; ++i) {
                    BooleanMask2D comp = components[i];
                    if (comp.getNumberOfPoints() <= maxPoints) continue;
                    itemMax = i;
                    maxPoints = comp.getNumberOfPoints();
                }
            }
            if (maxPoints > 0) {
                points = components[itemMax].getConnectedContourPoints();
            } else {
                System.out.println("unsuccessful detection of spot limits");
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return points;
    }
}

