/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS.tools.ROI2D;

import icy.gui.frame.progress.FailedAnnounceFrame;
import icy.roi.ROI2D;
import icy.type.geom.Polygon2D;
import icy.type.geom.Polyline2D;
import icy.util.XMLUtil;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import plugins.kernel.roi.roi2d.ROI2DLine;
import plugins.kernel.roi.roi2d.ROI2DPolyLine;
import plugins.kernel.roi.roi2d.ROI2DPolygon;
import plugins.kernel.roi.roi2d.ROI2DRectShape;
import plugins.kernel.roi.roi2d.ROI2DShape;

public class ROI2DUtilities {
    private static final String ID_ROIMC = "roiMC";

    public static Polygon2D getPolygonEnclosingROI2Ds(ArrayList<ROI2D> listRois) {
        ROI2D roi1 = listRois.get(0);
        Rectangle rect0 = roi1.getBounds();
        int x0 = (int)rect0.getX();
        int y0 = (int)rect0.getY();
        int width0 = (int)rect0.getWidth();
        int height0 = (int)rect0.getHeight();
        for (ROI2D roi : listRois) {
            if (!roi.getName().contains("spot")) continue;
            Rectangle rect1 = roi.getBounds();
            int x1 = (int)rect1.getX();
            int y1 = (int)rect1.getY();
            int width1 = x1 - x0 + (int)rect1.getWidth();
            int height1 = y1 - y0 + (int)rect1.getHeight();
            if (width1 > width0) {
                width0 = width1;
            }
            if (height1 <= height0) continue;
            height0 = height1;
        }
        return new Polygon2D((Rectangle2D)new Rectangle2D.Double(x0, y0, width0, height0));
    }

    public static void saveToXML_ROI(Node node, ROI2D roi) {
        Element nodeROI = XMLUtil.setElement((Node)node, (String)ID_ROIMC);
        if (!roi.saveToXML((Node)nodeROI)) {
            XMLUtil.removeNode((Node)node, (Node)nodeROI);
            System.err.println("Error: the roi " + roi.getName() + " was not correctly saved to XML !");
        }
    }

    public static ROI2D loadFromXML_ROI(Node node) {
        Element nodeROI = XMLUtil.getElement((Node)node, (String)ID_ROIMC);
        if (nodeROI != null) {
            ROI2D roi = (ROI2D)ROI2D.createFromXML((Node)nodeROI);
            return roi;
        }
        return null;
    }

    public static ROI2D resizeROI(ROI2D roi, int delta_pixel) {
        ROI2D out = (ROI2D)roi.getCopy();
        if (out instanceof ROI2DRectShape || out instanceof ROI2DLine) {
            out = ROI2DUtilities.resizeRectROI(roi, delta_pixel);
        } else if (out instanceof ROI2DShape) {
            out = ROI2DUtilities.resizeShape2DROI(roi, delta_pixel);
        } else {
            out.setName(roi.getName());
            new FailedAnnounceFrame("Cannot rescale a " + roi.getSimpleClassName());
        }
        return out;
    }

    private static ROI2D resizeRectROI(ROI2D out, int delta_pixel) {
        Rectangle2D b2 = out.getBounds2D();
        double oldX = b2.getCenterX();
        double oldY = b2.getCenterY();
        b2.setFrame(b2.getX() - oldX, b2.getY() - oldY, b2.getWidth(), b2.getHeight());
        b2.setFrame(b2.getX() + (double)delta_pixel, b2.getY() + (double)delta_pixel, b2.getWidth() + (double)(delta_pixel * 2), b2.getHeight() + (double)(delta_pixel * 2));
        b2.setFrame(b2.getX() + oldX, b2.getY() + oldY, b2.getWidth(), b2.getHeight());
        out.setBounds2D(b2);
        return out;
    }

    private static ROI2D resizeShape2DROI(ROI2D out, int delta_pixel) {
        Object poly;
        ROI2DShape shape = (ROI2DShape)out;
        ArrayList pts = shape.getPoints();
        Point2D.Double oldCenter = new Point2D.Double();
        for (Point2D pt : pts) {
            oldCenter.x += pt.getX();
            oldCenter.y += pt.getY();
        }
        oldCenter.x /= (double)pts.size();
        oldCenter.y /= (double)pts.size();
        for (Point2D pt : pts) {
            double x = pt.getX();
            double y = pt.getY();
            x = x >= 0.0 ? x + (double)delta_pixel : (x -= oldCenter.x) - (double)delta_pixel;
            y = y >= 0.0 ? y + (double)delta_pixel : (y -= oldCenter.y) - (double)delta_pixel;
            pt.setLocation(x += oldCenter.x, y += oldCenter.y);
        }
        if (out instanceof ROI2DPolygon) {
            poly = (ROI2DPolygon)out;
            poly.setPoints((List)pts);
        } else if (out instanceof ROI2DPolyLine) {
            poly = (ROI2DPolyLine)out;
            poly.setPoints((List)pts);
        } else {
            try {
                shape.getClass().getMethod("removeAllPoint", new Class[0]).invoke((Object)shape, new Object[0]);
                for (Point2D pt : pts) {
                    shape.addNewPoint(pt, true);
                }
            }
            catch (Exception e) {
                shape.setName(out.getName());
                new FailedAnnounceFrame("Cannot resize a " + out.getSimpleClassName());
            }
        }
        return shape;
    }

    public static ROI2D rescaleROI(ROI2D roi, double scale) {
        ROI2D out = (ROI2D)roi.getCopy();
        out.setName(roi.getName() + " x" + scale);
        if (out instanceof ROI2DRectShape || out instanceof ROI2DLine) {
            out = ROI2DUtilities.rescaleRectROI(roi, scale);
        } else if (out instanceof ROI2DShape) {
            out = ROI2DUtilities.rescaleShape2DROI(roi, scale);
        } else {
            out.setName(roi.getName());
            new FailedAnnounceFrame("Cannot rescale a " + roi.getSimpleClassName());
        }
        return out;
    }

    private static ROI2D rescaleRectROI(ROI2D out, double scale) {
        Rectangle2D b2 = out.getBounds2D();
        double oldX = b2.getCenterX();
        double oldY = b2.getCenterY();
        b2.setFrame(b2.getX() - oldX, b2.getY() - oldY, b2.getWidth(), b2.getHeight());
        b2.setFrame(b2.getX() * scale, b2.getY() * scale, b2.getWidth() * scale, b2.getHeight() * scale);
        b2.setFrame(b2.getX() + oldX, b2.getY() + oldY, b2.getWidth(), b2.getHeight());
        out.setBounds2D(b2);
        return out;
    }

    private static ROI2D rescaleShape2DROI(ROI2D out, double scale) {
        Object poly;
        ROI2DShape shape = (ROI2DShape)out;
        Point2D.Double oldCenter = new Point2D.Double();
        ArrayList pts = shape.getPoints();
        for (Point2D pt : pts) {
            oldCenter.x += pt.getX();
            oldCenter.y += pt.getY();
        }
        oldCenter.x /= (double)pts.size();
        oldCenter.y /= (double)pts.size();
        for (Point2D pt : pts) {
            double x = pt.getX();
            double y = pt.getY();
            x -= oldCenter.x;
            y -= oldCenter.y;
            x *= scale;
            y *= scale;
            pt.setLocation(x += oldCenter.x, y += oldCenter.y);
        }
        if (out instanceof ROI2DPolygon) {
            poly = (ROI2DPolygon)out;
            poly.setPoints((List)pts);
        } else if (out instanceof ROI2DPolyLine) {
            poly = (ROI2DPolyLine)out;
            poly.setPoints((List)pts);
        } else {
            try {
                shape.getClass().getMethod("removeAllPoint", new Class[0]).invoke((Object)shape, new Object[0]);
                for (Point2D pt : pts) {
                    shape.addNewPoint(pt, true);
                }
            }
            catch (Exception e) {
                shape.setName(out.getName());
                new FailedAnnounceFrame("Cannot rescale a " + out.getSimpleClassName());
            }
        }
        return shape;
    }

    public static void interpolateMissingPointsAlongXAxis(ROI2DPolyLine roiLine, int nintervals) {
        if (nintervals <= 1) {
            return;
        }
        Polyline2D polyline = roiLine.getPolyline2D();
        int roiLine_npoints = polyline.npoints;
        if (roiLine_npoints == 0) {
            return;
        }
        if (roiLine_npoints > nintervals) {
            roiLine_npoints = nintervals;
        }
        ArrayList<Point2D.Double> pts = new ArrayList<Point2D.Double>(roiLine_npoints);
        double ylast = polyline.ypoints[roiLine_npoints - 1];
        int xfirst0 = (int)polyline.xpoints[0];
        for (int i = 1; i < roiLine_npoints; ++i) {
            int xlast;
            int xfirst = (int)polyline.xpoints[i - 1];
            if (xfirst < 0) {
                xfirst = 0;
            }
            if ((xlast = (int)polyline.xpoints[i]) > xfirst0 + nintervals - 1) {
                xlast = xfirst0 + nintervals - 1;
            }
            double yfirst = polyline.ypoints[i - 1];
            ylast = polyline.ypoints[i];
            for (int j = xfirst; j < xlast; ++j) {
                int val = (int)(yfirst + (ylast - yfirst) * (double)(j - xfirst) / (double)(xlast - xfirst));
                Point2D.Double pt = new Point2D.Double(j, val);
                pts.add(pt);
            }
        }
        Point2D.Double pt = new Point2D.Double(polyline.xpoints[roiLine_npoints - 1], ylast);
        pts.add(pt);
        roiLine.setPoints(pts);
    }
}

