/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS.tools.chart;

import icy.gui.frame.IcyFrame;
import icy.gui.util.GuiUtil;
import icy.gui.viewer.Viewer;
import icy.roi.ROI;
import icy.roi.ROI2D;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.List;
import javax.swing.JPanel;
import org.jfree.chart.ChartColor;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.chart.plot.CombinedRangeXYPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import plugins.fmp.multiSPOTS.experiment.Experiment;
import plugins.fmp.multiSPOTS.experiment.spots.Spot;
import plugins.fmp.multiSPOTS.tools.toExcel.EnumXLSExportType;
import plugins.fmp.multiSPOTS.tools.toExcel.XLSExport;
import plugins.fmp.multiSPOTS.tools.toExcel.XLSExportOptions;
import plugins.fmp.multiSPOTS.tools.toExcel.XLSResults;
import plugins.fmp.multiSPOTS.tools.toExcel.XLSResultsArray;

public class ChartSpots
extends IcyFrame {
    public JPanel mainChartPanel = null;
    public IcyFrame mainChartFrame = null;
    private Point pt = new Point(0, 0);
    private boolean flagMaxMinSet = false;
    private double globalYMax = 0.0;
    private double globalYMin = 0.0;
    private double globalXMax = 0.0;
    private double ymax = 0.0;
    private double ymin = 0.0;
    private double xmax = 0.0;
    int nCagesAlongX = 1;
    int nCagesAlongY = 1;
    ChartPanel[][] panelHolder = null;
    Experiment exp = null;

    public void createSpotsChartPanel2(String title, Experiment exp) {
        this.mainChartPanel = new JPanel();
        this.mainChartFrame = GuiUtil.generateTitleFrame((String)title, (JPanel)new JPanel(), (Dimension)new Dimension(300, 70), (boolean)true, (boolean)true, (boolean)true, (boolean)true);
        this.mainChartFrame.add((Component)this.mainChartPanel);
        this.nCagesAlongX = exp.spotsArray.nColumnsPerPlate / exp.spotsArray.nColumnsPerCage;
        this.nCagesAlongY = exp.spotsArray.nRowsPerPlate / exp.spotsArray.nRowsPerCage;
        this.panelHolder = new ChartPanel[this.nCagesAlongY][this.nCagesAlongX];
        this.mainChartPanel.setLayout(new GridLayout(this.nCagesAlongY, this.nCagesAlongX));
    }

    private NumberAxis setYaxis(int row, int col, XLSExportOptions xlsExportOptions) {
        NumberAxis yAxis = new NumberAxis();
        String yLegend = String.valueOf((char)((row *= this.exp.spotsArray.nRowsPerCage) + 65)) + "_" + Integer.toString(col *= this.exp.spotsArray.nColumnsPerCage);
        yAxis.setLabel(yLegend);
        if (xlsExportOptions.relativeToT0 || xlsExportOptions.relativeToMedianT0) {
            yAxis.setAutoRange(false);
            yAxis.setRange(-0.2, 1.2);
        } else {
            yAxis.setAutoRange(true);
            yAxis.setAutoRangeIncludesZero(false);
        }
        return yAxis;
    }

    public void displayData(final Experiment exp, final XLSExportOptions xlsExportOptions) {
        this.exp = exp;
        this.ymax = 0.0;
        this.ymin = 0.0;
        this.flagMaxMinSet = false;
        Paint[] chartColor = ChartColor.createDefaultPaintArray();
        XLSResultsArray xlsResultsArray = this.getDataAsResultsArray(exp, xlsExportOptions);
        XLSResultsArray xlsResultsArray2 = null;
        if (xlsExportOptions.exportType == EnumXLSExportType.AREA_SUMCLEAN) {
            xlsExportOptions.exportType = EnumXLSExportType.AREA_SUM;
            xlsResultsArray2 = this.getDataAsResultsArray(exp, xlsExportOptions);
            xlsExportOptions.exportType = EnumXLSExportType.AREA_SUMCLEAN;
        }
        int cageID = 0;
        for (int row = 0; row < this.nCagesAlongY; ++row) {
            for (int col = 0; col < this.nCagesAlongX; ++col) {
                if (xlsExportOptions.cageIndexFirst >= 0 && (cageID < xlsExportOptions.cageIndexFirst || cageID > xlsExportOptions.cageIndexLast)) {
                    ++cageID;
                    continue;
                }
                NumberAxis yAxis = this.setYaxis(row, col, xlsExportOptions);
                XYPlot subplot = this.getXYPlotOfOneCage(cageID, yAxis, chartColor, xlsResultsArray, xlsResultsArray2);
                CombinedRangeXYPlot combinedXYPlot = new CombinedRangeXYPlot((ValueAxis)yAxis);
                combinedXYPlot.add(subplot);
                JFreeChart chart = new JFreeChart(null, null, (Plot)combinedXYPlot, false);
                chart.setID("row:" + row + ":col:" + col + ":cageID:" + cageID);
                ChartPanel panel = new ChartPanel(chart, 200, 100, 50, 25, 1200, 600, true, true, true, true, false, true);
                panel.addChartMouseListener(new ChartMouseListener(){

                    public void chartMouseClicked(ChartMouseEvent e) {
                        Spot clikedSpot = ChartSpots.this.getClickedSpot(e);
                        ChartSpots.this.selectSpot(exp, clikedSpot);
                        ChartSpots.this.selectT(exp, xlsExportOptions, clikedSpot);
                        ChartSpots.this.selectKymograph(exp, clikedSpot);
                    }

                    public void chartMouseMoved(ChartMouseEvent e) {
                    }
                });
                this.panelHolder[row][col] = panel;
                this.mainChartPanel.add((Component)panel);
                ++cageID;
            }
        }
        this.mainChartFrame.pack();
        this.mainChartFrame.setLocation(this.pt);
        this.mainChartFrame.addToDesktopPane();
        this.mainChartFrame.setVisible(true);
    }

    public void setLocationRelativeToRectangle(Rectangle rectv, Point deltapt) {
        this.pt = new Point(rectv.x + deltapt.x, rectv.y + deltapt.y);
    }

    public void setUpperLeftLocation(Rectangle rectv) {
        this.pt = new Point(rectv.x, rectv.y);
    }

    private XYLineAndShapeRenderer getSubPlotRenderer(XYSeriesCollection xySeriesCollection, Paint[] chartColor) {
        XYLineAndShapeRenderer subPlotRenderer = new XYLineAndShapeRenderer(true, false);
        int maxcolor = chartColor.length;
        BasicStroke stroke = new BasicStroke(0.5f, 1, 1, 1.0f, new float[]{2.0f, 4.0f}, 0.0f);
        for (int i = 0; i < xySeriesCollection.getSeriesCount(); ++i) {
            String[] description = xySeriesCollection.getSeries(i).getDescription().split(":");
            int icolor = Integer.valueOf(description[3]);
            String key = (String)((Object)xySeriesCollection.getSeriesKey(i));
            if (key.contains("*")) {
                subPlotRenderer.setSeriesStroke(i, (Stroke)stroke);
            }
            subPlotRenderer.setSeriesPaint(i, chartColor[icolor %= maxcolor]);
        }
        return subPlotRenderer;
    }

    private XYPlot buildSubPlot(XYSeriesCollection xySeriesCollection, Paint[] chartColor) {
        String[] description = xySeriesCollection.getSeries(0).getDescription().split(":");
        XYLineAndShapeRenderer subPlotRenderer = this.getSubPlotRenderer(xySeriesCollection, chartColor);
        NumberAxis xAxis = new NumberAxis();
        XYPlot subplot = new XYPlot((XYDataset)xySeriesCollection, (ValueAxis)xAxis, null, (XYItemRenderer)subPlotRenderer);
        int nflies = Integer.valueOf(description[5]);
        if (nflies > 0) {
            subplot.setBackgroundPaint((Paint)Color.WHITE);
            subplot.setDomainGridlinePaint((Paint)Color.GRAY);
            subplot.setRangeGridlinePaint((Paint)Color.GRAY);
        } else {
            subplot.setBackgroundPaint((Paint)Color.LIGHT_GRAY);
            subplot.setDomainGridlinePaint((Paint)Color.WHITE);
            subplot.setRangeGridlinePaint((Paint)Color.WHITE);
        }
        return subplot;
    }

    private XLSResultsArray getDataAsResultsArray(Experiment exp, XLSExportOptions xlsExportOptions) {
        XLSExport xlsExport = new XLSExport();
        return xlsExport.getSpotsDataFromOneExperiment(exp, xlsExportOptions);
    }

    private void updateGlobalMaxMin() {
        if (!this.flagMaxMinSet) {
            this.globalYMax = this.ymax;
            this.globalYMin = this.ymin;
            this.globalXMax = this.xmax;
            this.flagMaxMinSet = true;
        } else {
            if (this.globalYMax < this.ymax) {
                this.globalYMax = this.ymax;
            }
            if (this.globalYMin >= this.ymin) {
                this.globalYMin = this.ymin;
            }
            if (this.globalXMax < this.xmax) {
                this.globalXMax = this.xmax;
            }
        }
    }

    private XYSeries getXYSeries(XLSResults results, String name) {
        XYSeries seriesXY = new XYSeries((Comparable)((Object)name), false);
        if (results.valuesOut != null && results.valuesOut.length > 0) {
            this.xmax = results.valuesOut.length;
            this.ymin = this.ymax = results.valuesOut[0];
            this.addPointsAndUpdateExtrema(seriesXY, results, 0);
        }
        return seriesXY;
    }

    private void addPointsAndUpdateExtrema(XYSeries seriesXY, XLSResults results, int startFrame) {
        int x = 0;
        for (double y : results.valuesOut) {
            seriesXY.add((double)(x + startFrame), y);
            if (this.ymax < y) {
                this.ymax = y;
            }
            if (this.ymin > y) {
                this.ymin = y;
            }
            ++x;
        }
    }

    private XYPlot getXYPlotOfOneCage(int cageID, NumberAxis yAxis, Paint[] chartColor, XLSResultsArray xlsResultsArray, XLSResultsArray xlsResultsArray2) {
        XYSeriesCollection xyDataSetList = this.getDataOfOneCage(xlsResultsArray, cageID, "");
        if (xlsResultsArray2 != null) {
            this.addXYSeriesCollection(xyDataSetList, this.getDataOfOneCage(xlsResultsArray2, cageID, "*"));
        }
        XYPlot subplot = this.buildSubPlot(xyDataSetList, chartColor);
        return subplot;
    }

    private XYSeriesCollection getDataOfOneCage(XLSResultsArray xlsResultsArray, int cageID, String token) {
        XYSeriesCollection xySeriesCollection = null;
        for (int i = 0; i < xlsResultsArray.size(); ++i) {
            XLSResults xlsResults = xlsResultsArray.getRow(i);
            if (cageID != xlsResults.cageID) continue;
            if (xySeriesCollection == null) {
                xySeriesCollection = new XYSeriesCollection();
            }
            XYSeries seriesXY = this.getXYSeries(xlsResults, xlsResults.name + token);
            seriesXY.setDescription("ID:" + xlsResults.cageID + ":Pos:" + xlsResults.cagePosition + ":nflies:" + xlsResults.nflies);
            xySeriesCollection.addSeries(seriesXY);
            this.updateGlobalMaxMin();
        }
        return xySeriesCollection;
    }

    private void addXYSeriesCollection(XYSeriesCollection destination, XYSeriesCollection source) {
        for (int j = 0; j < source.getSeriesCount(); ++j) {
            XYSeries xySeries = source.getSeries(j);
            destination.addSeries(xySeries);
        }
    }

    private Spot getClickedSpot(ChartMouseEvent e) {
        int index;
        MouseEvent trigger = e.getTrigger();
        if (trigger.getButton() != 1) {
            return null;
        }
        JFreeChart chart = e.getChart();
        MouseEvent mouseEvent = e.getTrigger();
        String[] chartID = chart.getID().split(":");
        int row = Integer.valueOf(chartID[1]);
        int col = Integer.valueOf(chartID[3]);
        ChartPanel panel = this.panelHolder[row][col];
        PlotRenderingInfo plotInfo = panel.getChartRenderingInfo().getPlotInfo();
        Point2D pointClicked = panel.translateScreenToJava2D(mouseEvent.getPoint());
        int subplotindex = plotInfo.getSubplotIndex(pointClicked);
        CombinedRangeXYPlot combinedXYPlot = (CombinedRangeXYPlot)chart.getPlot();
        List subplots = combinedXYPlot.getSubplots();
        Spot spotFound = null;
        String description = null;
        ChartEntity chartEntity = e.getEntity();
        if (chartEntity != null && chartEntity instanceof XYItemEntity) {
            XYItemEntity xyItemEntity = (XYItemEntity)chartEntity;
            int isel = xyItemEntity.getSeriesIndex();
            XYDataset xyDataset = xyItemEntity.getDataset();
            description = (String)((Object)xyDataset.getSeriesKey(isel));
            spotFound = this.exp.spotsArray.getSpotContainingName(description.substring(0, 5));
            spotFound.spot_CamData_T = xyItemEntity.getItem();
        } else if (subplotindex >= 0) {
            XYDataset xyDataset = ((XYPlot)subplots.get(subplotindex)).getDataset(0);
            description = (String)((Object)xyDataset.getSeriesKey(0));
            spotFound = this.exp.spotsArray.getSpotContainingName(description.substring(0, 5));
        } else {
            System.out.println("Graph clicked but source not found");
            return null;
        }
        String[] roiDescription = description.split("_");
        spotFound.spot_Kymograph_T = index = this.exp.spotsArray.getSpotIndexFromPlateCoordinates(roiDescription[1], roiDescription[2]);
        return spotFound;
    }

    private void selectSpot(Experiment exp, Spot spot) {
        Viewer v = exp.seqCamData.seq.getFirstViewer();
        if (v != null && spot != null) {
            ROI2D roi = spot.getRoi();
            exp.seqCamData.seq.setFocusedROI((ROI)roi);
        }
    }

    private void selectT(Experiment exp, XLSExportOptions xlsExportOptions, Spot spot) {
        Viewer v = exp.seqCamData.seq.getFirstViewer();
        if (v != null && spot != null && spot.spot_CamData_T > 0) {
            int ii = (int)((long)(spot.spot_CamData_T * xlsExportOptions.buildExcelStepMs) / exp.seqCamData.binDuration_ms);
            v.setPositionT(ii);
        }
    }

    private void selectKymograph(Experiment exp, Spot spot) {
        Viewer v;
        if (exp.seqSpotKymos != null && (v = exp.seqSpotKymos.seq.getFirstViewer()) != null && spot != null) {
            v.setPositionT(spot.spot_Kymograph_T);
        }
    }
}

