/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS.tools.toExcel;

import icy.gui.frame.progress.ProgressFrame;
import java.awt.Point;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import plugins.fmp.multiSPOTS.experiment.Experiment;
import plugins.fmp.multiSPOTS.experiment.cages.Cage;
import plugins.fmp.multiSPOTS.experiment.cages.FlyPosition;
import plugins.fmp.multiSPOTS.experiment.cages.FlyPositions;
import plugins.fmp.multiSPOTS.tools.Comparators;
import plugins.fmp.multiSPOTS.tools.JComponents.JComboBoxExperiment;
import plugins.fmp.multiSPOTS.tools.toExcel.EnumXLSExportType;
import plugins.fmp.multiSPOTS.tools.toExcel.XLSExport;
import plugins.fmp.multiSPOTS.tools.toExcel.XLSExportOptions;
import plugins.fmp.multiSPOTS.tools.toExcel.XLSUtils;

public class XLSExportMoveResults
extends XLSExport {
    JComboBoxExperiment expList = null;
    List<FlyPositions> rowsForOneExp = new ArrayList<FlyPositions>();

    public void exportToFile(String filename, XLSExportOptions opt) {
        System.out.println("XLSExpoportMove:exportToFile() start output");
        this.options = opt;
        this.expList = this.options.expList;
        boolean loadDrosoTrack = true;
        this.expList.loadListOfMeasuresFromAllExperiments(false, loadDrosoTrack);
        this.expList.chainExperimentsUsingKymoIndexes(this.options.collateSeries);
        this.expList.setFirstImageForAllExperiments(this.options.collateSeries);
        this.expAll = this.expList.get_MsTime_of_StartAndEnd_AllExperiments(this.options);
        ProgressFrame progress = new ProgressFrame("Export data to Excel");
        int nbexpts = this.expList.getItemCount();
        progress.setLength((double)nbexpts);
        try {
            int column = 1;
            int iSeries = 0;
            this.workbook = this.xlsInitWorkbook();
            for (int index = this.options.experimentIndexFirst; index <= this.options.experimentIndexLast; ++index) {
                Experiment exp = (Experiment)this.expList.getItemAt(index);
                exp.load_SpotsMeasures();
                if (exp.chainToPreviousExperiment != null) continue;
                progress.setMessage("Export experiment " + (index + 1) + " of " + nbexpts);
                String charSeries = CellReference.convertNumToColString((int)iSeries);
                if (this.options.xyImage) {
                    this.getMoveDataAndExport(exp, column, charSeries, EnumXLSExportType.XYIMAGE);
                }
                if (this.options.xyCage) {
                    this.getMoveDataAndExport(exp, column, charSeries, EnumXLSExportType.XYTOPCAGE);
                }
                if (this.options.xyCapillaries) {
                    this.getMoveDataAndExport(exp, column, charSeries, EnumXLSExportType.XYTIPCAPS);
                }
                if (this.options.ellipseAxes) {
                    this.getMoveDataAndExport(exp, column, charSeries, EnumXLSExportType.ELLIPSEAXES);
                }
                if (this.options.distance) {
                    this.getMoveDataAndExport(exp, column, charSeries, EnumXLSExportType.DISTANCE);
                }
                if (this.options.alive) {
                    this.getMoveDataAndExport(exp, column, charSeries, EnumXLSExportType.ISALIVE);
                }
                if (this.options.sleep) {
                    this.getMoveDataAndExport(exp, column, charSeries, EnumXLSExportType.SLEEP);
                }
                if (!this.options.collateSeries || exp.chainToPreviousExperiment == null) {
                    column += this.expList.maxSizeOfSpotsArrays + 2;
                }
                ++iSeries;
                progress.incPosition();
            }
            progress.setMessage("Save Excel file to disk... ");
            FileOutputStream fileOut = new FileOutputStream(filename);
            this.workbook.write((OutputStream)fileOut);
            fileOut.close();
            this.workbook.close();
            progress.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("XLSExpoportMove:exportToFile() - output finished");
    }

    private int getMoveDataAndExport(Experiment exp, int col0, String charSeries, EnumXLSExportType xlsExport) {
        this.getMoveDataFromOneSeriesOfExperiments(exp, xlsExport);
        XSSFSheet sheet = this.xlsInitSheet(xlsExport.toString(), xlsExport);
        int colmax = this.xlsExportResultsArrayToSheet(sheet, xlsExport, col0, charSeries);
        if (this.options.onlyalive) {
            this.trimDeadsFromRowMoveData(exp);
            sheet = this.xlsInitSheet(xlsExport.toString() + "_alive", xlsExport);
            this.xlsExportResultsArrayToSheet(sheet, xlsExport, col0, charSeries);
        }
        return colmax;
    }

    private void getMoveDescriptorsForOneExperiment(Experiment exp, EnumXLSExportType xlsOption) {
        this.expAll.cagesArray.copy(exp.cagesArray);
        this.expAll.spotsArray.copy(exp.spotsArray);
        this.expAll.firstImage_FileTime = exp.firstImage_FileTime;
        this.expAll.lastImage_FileTime = exp.lastImage_FileTime;
        this.expAll.setResultsDirectory(exp.getResultsDirectory());
        this.expAll.expDesc.copyExperimentFields(exp.expDesc);
        Experiment expi = exp.chainToNextExperiment;
        while (expi != null) {
            this.expAll.cagesArray.mergeLists(expi.cagesArray);
            this.expAll.lastImage_FileTime = expi.lastImage_FileTime;
            expi = expi.chainToNextExperiment;
        }
        this.expAll.seqCamData.firstImage_ms = this.expAll.firstImage_FileTime.toMillis();
        this.expAll.seqCamData.lastImage_ms = this.expAll.lastImage_FileTime.toMillis();
        int nFrames = (int)((this.expAll.seqCamData.lastImage_ms - this.expAll.seqCamData.firstImage_ms) / (long)this.options.buildExcelStepMs + 1L);
        int ncages = this.expAll.cagesArray.cagesList.size();
        this.rowsForOneExp = new ArrayList<FlyPositions>(ncages);
        for (int i = 0; i < ncages; ++i) {
            Cage cage = this.expAll.cagesArray.cagesList.get(i);
            FlyPositions row = new FlyPositions(cage.getRoi().getName(), xlsOption, nFrames, this.options.buildExcelStepMs);
            row.nflies = cage.cageNFlies;
            this.rowsForOneExp.add(row);
        }
        Collections.sort(this.rowsForOneExp, new Comparators.XYTaSeries_Name_Comparator());
    }

    private void getMoveDataFromOneSeriesOfExperiments(Experiment exp, EnumXLSExportType xlsOption) {
        this.getMoveDescriptorsForOneExperiment(exp, xlsOption);
        Experiment expi = exp.getFirstChainedExperiment(true);
        while (expi != null) {
            int len = 1 + (int)(expi.seqCamData.lastImage_ms - expi.seqCamData.firstImage_ms) / this.options.buildExcelStepMs;
            if (len == 0) continue;
            double pixelsize = 1.0;
            ArrayList<FlyPositions> resultsArrayList = new ArrayList<FlyPositions>(expi.cagesArray.cagesList.size());
            for (Cage cage : expi.cagesArray.cagesList) {
                FlyPositions results = new FlyPositions(cage.getRoi().getName(), xlsOption, len, this.options.buildExcelStepMs);
                results.nflies = cage.cageNFlies;
                if (results.nflies > 0) {
                    results.setPixelSize(pixelsize);
                    switch (xlsOption) {
                        case DISTANCE: {
                            results.excelComputeDistanceBetweenPoints(cage.flyPositions, (int)expi.seqCamData.binImage_ms, this.options.buildExcelStepMs);
                            break;
                        }
                        case ISALIVE: {
                            results.excelComputeIsAlive(cage.flyPositions, (int)expi.seqCamData.binImage_ms, this.options.buildExcelStepMs);
                            break;
                        }
                        case SLEEP: {
                            results.excelComputeSleep(cage.flyPositions, (int)expi.seqCamData.binImage_ms, this.options.buildExcelStepMs);
                            break;
                        }
                        case XYTOPCAGE: {
                            results.excelComputeNewPointsOrigin(cage.getCenterTopCage(), cage.flyPositions, (int)expi.seqCamData.binImage_ms, this.options.buildExcelStepMs);
                            break;
                        }
                        case ELLIPSEAXES: {
                            results.excelComputeEllipse(cage.flyPositions, (int)expi.seqCamData.binImage_ms, this.options.buildExcelStepMs);
                            break;
                        }
                    }
                    results.convertPixelsToPhysicalValues();
                    resultsArrayList.add(results);
                }
                this.addMoveResultsTo_rowsForOneExp(expi, resultsArrayList);
            }
            expi = expi.chainToNextExperiment;
        }
        for (FlyPositions row : this.rowsForOneExp) {
            row.checkIsAliveFromAliveArray();
        }
    }

    private FlyPositions getResultsArrayWithThatName(String testname, List<FlyPositions> resultsArrayList) {
        FlyPositions resultsFound = null;
        for (FlyPositions results : resultsArrayList) {
            if (!results.name.equals(testname)) continue;
            resultsFound = results;
            break;
        }
        return resultsFound;
    }

    private void addMoveResultsTo_rowsForOneExp(Experiment expi, List<FlyPositions> resultsArrayList) {
        long start_Ms = expi.seqCamData.firstImage_ms - this.expAll.seqCamData.firstImage_ms;
        long end_Ms = expi.seqCamData.lastImage_ms - this.expAll.seqCamData.firstImage_ms;
        if (this.options.fixedIntervals) {
            if (start_Ms < this.options.startAll_Ms) {
                start_Ms = this.options.startAll_Ms;
            }
            if (start_Ms > expi.seqCamData.lastImage_ms) {
                return;
            }
            if (end_Ms > this.options.endAll_Ms) {
                end_Ms = this.options.endAll_Ms;
            }
            if (end_Ms > expi.seqCamData.firstImage_ms) {
                return;
            }
        }
        long from_first_Ms = start_Ms + this.expAll.seqCamData.firstImage_ms;
        long from_lastMs = end_Ms + this.expAll.seqCamData.firstImage_ms;
        int to_first_index = (int)(from_first_Ms - this.expAll.seqCamData.firstImage_ms) / this.options.buildExcelStepMs;
        int to_nvalues = (int)((from_lastMs - from_first_Ms) / (long)this.options.buildExcelStepMs) + 1;
        block0: for (FlyPositions rowFlyPositions : this.rowsForOneExp) {
            int tofirst;
            int tolast;
            FlyPositions results = this.getResultsArrayWithThatName(rowFlyPositions.name, resultsArrayList);
            if (results != null) {
                int from_i;
                if (this.options.collateSeries && this.options.padIntervals && expi.chainToPreviousExperiment != null) {
                    this.padWithLastPreviousValue(rowFlyPositions, to_first_index);
                }
                for (long fromTime = from_first_Ms; fromTime <= from_lastMs && (from_i = (int)((fromTime - from_first_Ms) / (long)this.options.buildExcelStepMs)) < results.flyPositionList.size(); fromTime += (long)this.options.buildExcelStepMs) {
                    FlyPosition aVal = results.flyPositionList.get(from_i);
                    int to_i = (int)((fromTime - this.expAll.seqCamData.firstImage_ms) / (long)this.options.buildExcelStepMs);
                    if (to_i >= rowFlyPositions.flyPositionList.size()) continue block0;
                    if (to_i < 0) continue;
                    rowFlyPositions.flyPositionList.get(to_i).copy(aVal);
                }
                continue;
            }
            if (!this.options.collateSeries || !this.options.padIntervals || expi.chainToPreviousExperiment == null) continue;
            FlyPosition posok = this.padWithLastPreviousValue(rowFlyPositions, to_first_index);
            int nvalues = to_nvalues;
            if (posok == null) continue;
            if (nvalues > rowFlyPositions.flyPositionList.size()) {
                nvalues = rowFlyPositions.flyPositionList.size();
            }
            if ((tolast = (tofirst = to_first_index) + nvalues) > rowFlyPositions.flyPositionList.size()) {
                tolast = rowFlyPositions.flyPositionList.size();
            }
            for (int toi = tofirst; toi < tolast; ++toi) {
                rowFlyPositions.flyPositionList.get(toi).copy(posok);
            }
        }
    }

    private FlyPosition padWithLastPreviousValue(FlyPositions row, int transfer_first_index) {
        FlyPosition posok = null;
        int index = this.getIndexOfFirstNonEmptyValueBackwards(row, transfer_first_index);
        if (index >= 0) {
            posok = row.flyPositionList.get(index);
            for (int i = index + 1; i < transfer_first_index; ++i) {
                FlyPosition pos = row.flyPositionList.get(i);
                pos.copy(posok);
                pos.bPadded = true;
            }
        }
        return posok;
    }

    private int getIndexOfFirstNonEmptyValueBackwards(FlyPositions row, int fromindex) {
        int index = -1;
        for (int i = fromindex; i >= 0; --i) {
            FlyPosition pos = row.flyPositionList.get(i);
            if (Double.isNaN(pos.rectPosition.getX())) continue;
            index = i;
            break;
        }
        return index;
    }

    private void trimDeadsFromRowMoveData(Experiment exp) {
        for (Cage cage : exp.cagesArray.cagesList) {
            int cagenumber = Integer.valueOf(cage.getRoi().getName().substring(4));
            int ilastalive = 0;
            if (cage.cageNFlies > 0) {
                Experiment expi = exp;
                while (expi.chainToNextExperiment != null && expi.chainToNextExperiment.cagesArray.isFlyAlive(cagenumber)) {
                    expi = expi.chainToNextExperiment;
                }
                long lastIntervalFlyAlive_Ms = (long)expi.cagesArray.getLastIntervalFlyAlive(cagenumber) * expi.cagesArray.detectBin_Ms;
                long lastMinuteAlive = lastIntervalFlyAlive_Ms + expi.seqCamData.firstImage_ms - this.expAll.seqCamData.firstImage_ms;
                ilastalive = (int)(lastMinuteAlive / (long)this.options.buildExcelStepMs);
            }
            for (FlyPositions row : this.rowsForOneExp) {
                int rowCageNumber = Integer.valueOf(row.name.substring(4));
                if (rowCageNumber != cagenumber) continue;
                row.clearValues(ilastalive + 1);
            }
        }
    }

    private int xlsExportResultsArrayToSheet(XSSFSheet sheet, EnumXLSExportType xlsExportOption, int col0, String charSeries) {
        Point pt = new Point(col0, 0);
        this.writeExperiment_descriptors(this.expAll, charSeries, sheet, pt, xlsExportOption);
        pt = this.writeData2(sheet, xlsExportOption, pt);
        return pt.x;
    }

    private Point writeData2(XSSFSheet sheet, EnumXLSExportType option, Point pt_main) {
        int rowseries = pt_main.x + 2;
        int columndataarea = pt_main.y;
        Point pt = new Point(pt_main);
        this.writeRows(sheet, columndataarea, rowseries, pt);
        pt_main.x = pt.x + 1;
        return pt_main;
    }

    private void writeRows(XSSFSheet sheet, int column_dataArea, int rowSeries, Point pt) {
        boolean transpose = this.options.transpose;
        for (FlyPositions row : this.rowsForOneExp) {
            int i_from;
            pt.y = column_dataArea;
            int col = this.getRowIndexFromCageName(row.name) * 2;
            pt.x = rowSeries + col;
            if (row.nflies < 1) continue;
            long last = this.expAll.seqCamData.lastImage_ms - this.expAll.seqCamData.firstImage_ms;
            if (this.options.fixedIntervals) {
                last = this.options.endAll_Ms - this.options.startAll_Ms;
            }
            long coltime = 0L;
            while (coltime <= last && (i_from = (int)(coltime / (long)this.options.buildExcelStepMs)) < row.flyPositionList.size()) {
                double valueL = Double.NaN;
                double valueR = Double.NaN;
                FlyPosition pos = row.flyPositionList.get(i_from);
                switch (row.exportType) {
                    case DISTANCE: {
                        valueR = valueL = pos.distance;
                        break;
                    }
                    case ISALIVE: {
                        valueR = valueL = pos.bAlive ? 1.0 : 0.0;
                        break;
                    }
                    case SLEEP: {
                        valueR = valueL = pos.bSleep ? 1.0 : 0.0;
                        break;
                    }
                    case XYTOPCAGE: 
                    case XYIMAGE: 
                    case XYTIPCAPS: {
                        valueL = pos.rectPosition.getX() + pos.rectPosition.getWidth() / 2.0;
                        valueR = pos.rectPosition.getY() + pos.rectPosition.getHeight() / 2.0;
                        break;
                    }
                    case ELLIPSEAXES: {
                        valueL = pos.axis1;
                        valueR = pos.axis2;
                        break;
                    }
                }
                if (!Double.isNaN(valueL)) {
                    XLSUtils.setValue(sheet, pt, transpose, valueL);
                    if (pos.bPadded) {
                        XLSUtils.getCell(sheet, pt, transpose).setCellStyle((CellStyle)this.xssfCellStyle_red);
                    }
                }
                if (!Double.isNaN(valueR)) {
                    ++pt.x;
                    XLSUtils.setValue(sheet, pt, transpose, valueR);
                    if (pos.bPadded) {
                        XLSUtils.getCell(sheet, pt, transpose).setCellStyle((CellStyle)this.xssfCellStyle_red);
                    }
                    --pt.x;
                }
                coltime += (long)this.options.buildExcelStepMs;
                ++pt.y;
            }
            pt.x += 2;
        }
    }
}

