/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS.tools.toExcel;

import icy.gui.frame.progress.ProgressFrame;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.poi.ss.util.CellReference;
import plugins.fmp.multiSPOTS.experiment.Experiment;
import plugins.fmp.multiSPOTS.tools.toExcel.EnumXLSExportType;
import plugins.fmp.multiSPOTS.tools.toExcel.XLSExport;
import plugins.fmp.multiSPOTS.tools.toExcel.XLSExportOptions;

public class XLSExportSpotMeasures
extends XLSExport {
    public void exportToFile(String filename, XLSExportOptions opt) {
        System.out.println("XLSExpoportSpotAreas:exportToFile() - start output");
        this.options = opt;
        this.expList = this.options.expList;
        this.expList.loadListOfMeasuresFromAllExperiments(true, this.options.onlyalive);
        this.expList.chainExperimentsUsingKymoIndexes(this.options.collateSeries);
        this.expList.setFirstImageForAllExperiments(this.options.collateSeries);
        this.expAll = this.expList.get_MsTime_of_StartAndEnd_AllExperiments(this.options);
        ProgressFrame progress = new ProgressFrame("Export data to Excel");
        int nbexpts = this.expList.getItemCount();
        progress.setLength((double)nbexpts);
        try {
            int column = 1;
            int iSeries = 0;
            this.workbook = this.xlsInitWorkbook();
            for (int index = this.options.experimentIndexFirst; index <= this.options.experimentIndexLast; ++index) {
                Experiment exp = (Experiment)this.expList.getItemAt(index);
                exp.load_SpotsMeasures();
                if (exp.chainToPreviousExperiment != null) continue;
                progress.setMessage("Export experiment " + (index + 1) + " of " + nbexpts);
                String charSeries = CellReference.convertNumToColString((int)iSeries);
                int collast = column;
                if (this.options.spotAreas) {
                    collast = this.getDataAndExport(exp, column, charSeries, EnumXLSExportType.AREA_SUM);
                    this.getDataAndExport(exp, column, charSeries, EnumXLSExportType.AREA_FLYPRESENT);
                    this.getDataAndExport(exp, column, charSeries, EnumXLSExportType.AREA_SUMCLEAN);
                    this.getDataAndExport(exp, column, charSeries, EnumXLSExportType.AREA_OUT);
                    this.getDataAndExport(exp, column, charSeries, EnumXLSExportType.AREA_DIFF);
                    if (this.options.lrPI) {
                        this.getDataAndExport(exp, column, charSeries, EnumXLSExportType.AREA_SUM_LR);
                        this.getDataAndExport(exp, column, charSeries, EnumXLSExportType.AREA_SUMCLEAN_LR);
                    }
                }
                column = collast + 2;
                ++iSeries;
                progress.incPosition();
            }
            progress.setMessage("Save Excel file to disk... ");
            FileOutputStream fileOut = new FileOutputStream(filename);
            this.workbook.write((OutputStream)fileOut);
            fileOut.close();
            this.workbook.close();
            progress.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("XLSExpoportSpotAreas:exportToFile() XLS output finished");
    }
}

