/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.fft;

import net.imglib2.IterableInterval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealCursor;
import net.imglib2.algorithm.Benchmark;
import net.imglib2.algorithm.OutputAlgorithm;
import net.imglib2.img.Img;
import net.imglib2.img.ImgFactory;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.util.Util;
import net.imglib2.view.Views;

@Deprecated
public class Bandpass<T extends NumericType<T>>
implements OutputAlgorithm<RandomAccessibleInterval<T>>,
Benchmark {
    String errorMessage = "";
    boolean inPlace;
    boolean bandPass;
    RandomAccessibleInterval<T> input;
    Img<T> output;
    ImgFactory<T> imgFactory;
    int beginRadius;
    int endRadius;
    long processingTime;
    long[] origin;

    public Bandpass(RandomAccessibleInterval<T> input, int beginRadius, int endRadius, ImgFactory<T> imgFactory) {
        this.input = input;
        this.inPlace = false;
        this.bandPass = true;
        this.beginRadius = beginRadius;
        this.endRadius = endRadius;
        this.origin = new long[input.numDimensions()];
        this.origin[0] = input.dimension(0) - 1L;
        for (int d = 1; d < this.origin.length; ++d) {
            this.origin[d] = input.dimension(d) / 2L;
        }
    }

    public Bandpass(Img<T> img, int beginRadius, int endRadius) {
        this(img, beginRadius, endRadius, img.factory());
    }

    public void setImage(RandomAccessibleInterval<T> img) {
        this.input = img;
    }

    public void setInPlace(boolean inPlace) {
        this.inPlace = inPlace;
    }

    public void setBandPass(boolean bandPass) {
        this.bandPass = bandPass;
    }

    public void setOrigin(long[] position) {
        this.origin = (long[])position.clone();
    }

    public void setBandPassRadius(int beginRadius, int endRadius) {
        this.beginRadius = beginRadius;
        this.endRadius = endRadius;
    }

    public RandomAccessibleInterval<T> getInput() {
        return this.input;
    }

    public boolean getInPlace() {
        return this.inPlace;
    }

    public int getBeginBandPassRadius() {
        return this.beginRadius;
    }

    public int getEndBandPassRadius() {
        return this.endRadius;
    }

    public long[] getOrigin() {
        return this.origin;
    }

    @Override
    public boolean process() {
        IterableInterval<T> iterableInput;
        long startTime = System.currentTimeMillis();
        if (this.inPlace) {
            iterableInput = Views.iterable(this.input);
        } else {
            this.output = this.imgFactory.create(this.input, ((NumericType)Views.iterable(this.input).firstElement()).createVariable());
            iterableInput = this.output;
        }
        RealCursor cursor = iterableInput.cursor();
        long[] pos = new long[iterableInput.numDimensions()];
        boolean actAsBandPass = this.bandPass;
        while (cursor.hasNext()) {
            cursor.fwd();
            cursor.localize(pos);
            double dist = Util.distance(this.origin, pos);
            if (actAsBandPass) {
                if (!(dist < (double)this.beginRadius) && !(dist > (double)this.endRadius)) continue;
                ((NumericType)cursor.get()).setZero();
                continue;
            }
            if (!(dist >= (double)this.beginRadius) || !(dist <= (double)this.endRadius)) continue;
            ((NumericType)cursor.get()).setZero();
        }
        this.processingTime = System.currentTimeMillis() - startTime;
        return true;
    }

    @Override
    public RandomAccessibleInterval<T> getResult() {
        if (this.inPlace) {
            return this.input;
        }
        return this.output;
    }

    @Override
    public long getProcessingTime() {
        return this.processingTime;
    }

    @Override
    public boolean checkInput() {
        return true;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }
}

