/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.morphology.distance;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealCursor;
import net.imglib2.algorithm.morphology.distance.Distance;
import net.imglib2.algorithm.morphology.distance.EuclidianDistanceAnisotropic;
import net.imglib2.algorithm.morphology.distance.EuclidianDistanceIsotropic;
import net.imglib2.img.Img;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.img.cell.CellImgFactory;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.integer.LongType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.util.Intervals;
import net.imglib2.util.ValuePair;
import net.imglib2.view.Views;
import net.imglib2.view.composite.RealComposite;

public class DistanceTransform {
    public static <T extends RealType<T>> void transform(RandomAccessibleInterval<T> source, DISTANCE_TYPE distanceType, double ... weights) {
        DistanceTransform.transform(source, source, distanceType, weights);
    }

    public static <T extends RealType<T>> void transform(RandomAccessibleInterval<T> source, DISTANCE_TYPE distanceType, ExecutorService es, int nTasks, double ... weights) throws InterruptedException, ExecutionException {
        DistanceTransform.transform(source, source, distanceType, es, nTasks, weights);
    }

    public static <T extends RealType<T>, U extends RealType<U>> void transform(RandomAccessible<T> source, RandomAccessibleInterval<U> target, DISTANCE_TYPE distanceType, double ... weights) {
        DistanceTransform.transform(source, target, target, distanceType, weights);
    }

    public static <T extends RealType<T>, U extends RealType<U>> void transform(RandomAccessible<T> source, RandomAccessibleInterval<U> target, DISTANCE_TYPE distanceType, ExecutorService es, int nTasks, double ... weights) throws InterruptedException, ExecutionException {
        DistanceTransform.transform(source, target, target, distanceType, es, nTasks, weights);
    }

    public static <T extends RealType<T>, U extends RealType<U>, V extends RealType<V>> void transform(RandomAccessible<T> source, RandomAccessibleInterval<U> tmp, RandomAccessibleInterval<V> target, DISTANCE_TYPE distanceType, double ... weights) {
        boolean isIsotropic = weights.length <= 1;
        double[] w = weights.length == source.numDimensions() ? weights : DoubleStream.generate(() -> weights.length == 0 ? 1.0 : weights[0]).limit(source.numDimensions()).toArray();
        switch (distanceType) {
            case EUCLIDIAN: {
                DistanceTransform.transform(source, tmp, target, isIsotropic ? new EuclidianDistanceIsotropic(w[0]) : new EuclidianDistanceAnisotropic(w));
                break;
            }
            case L1: {
                DistanceTransform.transformL1(source, tmp, target, w);
                break;
            }
        }
    }

    public static <T extends RealType<T>, U extends RealType<U>, V extends RealType<V>> void transform(RandomAccessible<T> source, RandomAccessibleInterval<U> tmp, RandomAccessibleInterval<V> target, DISTANCE_TYPE distanceType, ExecutorService es, int nTasks, double ... weights) throws InterruptedException, ExecutionException {
        boolean isIsotropic = weights.length <= 1;
        double[] w = weights.length == source.numDimensions() ? weights : DoubleStream.generate(() -> weights.length == 0 ? 1.0 : weights[0]).limit(source.numDimensions()).toArray();
        switch (distanceType) {
            case EUCLIDIAN: {
                DistanceTransform.transform(source, tmp, target, isIsotropic ? new EuclidianDistanceIsotropic(w[0]) : new EuclidianDistanceAnisotropic(w), es, nTasks);
                break;
            }
            case L1: {
                DistanceTransform.transformL1(source, tmp, target, es, nTasks, w);
                break;
            }
        }
    }

    public static <T extends RealType<T>> void transform(RandomAccessibleInterval<T> source, Distance d) {
        DistanceTransform.transform(source, source, d);
    }

    public static <T extends RealType<T>> void transform(RandomAccessibleInterval<T> source, Distance d, ExecutorService es, int nTasks) throws InterruptedException, ExecutionException {
        DistanceTransform.transform(source, source, d, es, nTasks);
    }

    public static <T extends RealType<T>, U extends RealType<U>> void transform(RandomAccessible<T> source, RandomAccessibleInterval<U> target, Distance d) {
        DistanceTransform.transform(source, target, target, d);
    }

    public static <T extends RealType<T>, U extends RealType<U>> void transform(RandomAccessible<T> source, RandomAccessibleInterval<U> target, Distance d, ExecutorService es, int nTasks) throws InterruptedException, ExecutionException {
        DistanceTransform.transform(source, target, target, d, es, nTasks);
    }

    public static <T extends RealType<T>, U extends RealType<U>, V extends RealType<V>> void transform(RandomAccessible<T> source, RandomAccessibleInterval<U> tmp, RandomAccessibleInterval<V> target, Distance d) {
        assert (source.numDimensions() == target.numDimensions()) : "Dimension mismatch";
        int nDim = source.numDimensions();
        int lastDim = nDim - 1;
        if (nDim == 1) {
            DistanceTransform.transformAlongDimension(Views.addDimension(source), Views.interval(Views.addDimension(target), new FinalInterval(target.dimension(0), 1L)), d, 0);
        } else {
            DistanceTransform.transformAlongDimension(source, tmp, d, 0);
        }
        for (int dim = 1; dim < nDim; ++dim) {
            if (dim == lastDim) {
                DistanceTransform.transformAlongDimension(tmp, target, d, dim);
                continue;
            }
            DistanceTransform.transformAlongDimension(tmp, tmp, d, dim);
        }
    }

    public static <T extends RealType<T>, U extends RealType<U>, V extends RealType<V>> void transform(RandomAccessible<T> source, RandomAccessibleInterval<U> tmp, RandomAccessibleInterval<V> target, Distance d, ExecutorService es, int nTasks) throws InterruptedException, ExecutionException {
        assert (source.numDimensions() == target.numDimensions()) : "Dimension mismatch";
        int nDim = source.numDimensions();
        int lastDim = nDim - 1;
        if (nDim == 1) {
            DistanceTransform.transformAlongDimensionParallel(Views.addDimension(source), Views.interval(Views.addDimension(target), new FinalInterval(target.dimension(0), 1L)), d, 0, es, nTasks);
        } else {
            DistanceTransform.transformAlongDimensionParallel(source, tmp, d, 0, es, nTasks);
        }
        for (int dim = 1; dim < nDim; ++dim) {
            if (dim == lastDim) {
                DistanceTransform.transformAlongDimensionParallel(tmp, target, d, dim, es, nTasks);
                continue;
            }
            DistanceTransform.transformAlongDimensionParallel(tmp, tmp, d, dim, es, nTasks);
        }
    }

    private static <T extends RealType<T>, U extends RealType<U>, V extends RealType<V>> void transformL1(RandomAccessible<T> source, RandomAccessibleInterval<U> tmp, RandomAccessibleInterval<V> target, double ... weights) {
        assert (source.numDimensions() == target.numDimensions()) : "Dimension mismatch";
        int nDim = source.numDimensions();
        int lastDim = nDim - 1;
        if (nDim == 1) {
            DistanceTransform.transformL1AlongDimension(Views.addDimension(source), Views.interval(Views.addDimension(target), new FinalInterval(target.dimension(0), 1L)), 0, weights[0]);
        } else {
            DistanceTransform.transformL1AlongDimension(source, tmp, 0, weights[0]);
        }
        for (int dim = 1; dim < nDim; ++dim) {
            if (dim == lastDim) {
                DistanceTransform.transformL1AlongDimension(tmp, target, dim, weights[dim]);
                continue;
            }
            DistanceTransform.transformL1AlongDimension(tmp, tmp, dim, weights[dim]);
        }
    }

    private static <T extends RealType<T>, U extends RealType<U>, V extends RealType<V>> void transformL1(RandomAccessible<T> source, RandomAccessibleInterval<U> tmp, RandomAccessibleInterval<V> target, ExecutorService es, int nTasks, double ... weights) throws InterruptedException, ExecutionException {
        assert (source.numDimensions() == target.numDimensions()) : "Dimension mismatch";
        int nDim = source.numDimensions();
        int lastDim = nDim - 1;
        if (nDim == 1) {
            DistanceTransform.transformL1AlongDimensionParallel(Views.addDimension(source), Views.interval(Views.addDimension(target), new FinalInterval(target.dimension(0), 1L)), 0, weights[0], es, nTasks);
        } else {
            DistanceTransform.transformL1AlongDimensionParallel(source, tmp, 0, weights[0], es, nTasks);
        }
        for (int dim = 1; dim < nDim; ++dim) {
            if (dim == lastDim) {
                DistanceTransform.transformL1AlongDimensionParallel(tmp, target, dim, weights[dim], es, nTasks);
                continue;
            }
            DistanceTransform.transformL1AlongDimensionParallel(tmp, tmp, dim, weights[dim], es, nTasks);
        }
    }

    private static <T extends RealType<T>, U extends RealType<U>> void transformAlongDimension(RandomAccessible<T> source, RandomAccessibleInterval<U> target, Distance d, int dim) {
        int lastDim = target.numDimensions() - 1;
        long size = target.dimension(dim);
        RealComposite tmp = (RealComposite)Views.collapseReal(DistanceTransform.createAppropriateOneDimensionalImage(size, new DoubleType())).randomAccess().get();
        RealCursor s = Views.flatIterable(Views.collapseReal(dim == lastDim ? Views.interval(source, target) : Views.permute(Views.interval(source, target), dim, lastDim))).cursor();
        RealCursor t = Views.flatIterable(Views.collapseReal(dim == lastDim ? target : Views.permute(target, dim, lastDim))).cursor();
        RealComposite lowerBoundDistanceIndex = (RealComposite)Views.collapseReal(DistanceTransform.createAppropriateOneDimensionalImage(size, new LongType())).randomAccess().get();
        RealComposite envelopeIntersectLocation = (RealComposite)Views.collapseReal(DistanceTransform.createAppropriateOneDimensionalImage(size + 1L, new DoubleType())).randomAccess().get();
        while (s.hasNext()) {
            RealComposite sourceComp = (RealComposite)s.next();
            RealComposite targetComp = (RealComposite)t.next();
            for (long i = 0L; i < size; ++i) {
                ((DoubleType)tmp.get(i)).set(((RealType)sourceComp.get(i)).getRealDouble());
            }
            DistanceTransform.transformSingleColumn(tmp, targetComp, lowerBoundDistanceIndex, envelopeIntersectLocation, d, dim, size);
        }
    }

    private static <T extends RealType<T>, U extends RealType<U>> void transformAlongDimensionParallel(RandomAccessible<T> source, RandomAccessibleInterval<U> target, Distance d, int dim, ExecutorService es, int nTasks) throws InterruptedException, ExecutionException {
        int largestDim = DistanceTransform.getLargestDimension(Views.hyperSlice(target, dim, target.min(dim)));
        if (largestDim >= dim) {
            ++largestDim;
        }
        long size = target.dimension(dim);
        long stepPerChunk = Math.max(size / (long)nTasks, 1L);
        long[] min = Intervals.minAsLongArray(target);
        long[] max = Intervals.maxAsLongArray(target);
        long largestDimMin = target.min(largestDim);
        long largestDimMax = target.max(largestDim);
        ArrayList<Callable<T>> tasks = new ArrayList<Callable<T>>();
        long m = largestDimMin;
        long M = largestDimMin + stepPerChunk - 1L;
        while (m <= largestDimMax) {
            min[largestDim] = m;
            max[largestDim] = Math.min(M, largestDimMax);
            FinalInterval fi = new FinalInterval(min, max);
            tasks.add(() -> {
                DistanceTransform.transformAlongDimension(source, Views.interval(target, fi), d, dim);
                return null;
            });
            m += stepPerChunk;
            M += stepPerChunk;
        }
        DistanceTransform.invokeAllAndWait(es, tasks);
    }

    private static <T extends RealType<T>, U extends RealType<U>> void transformSingleColumn(RealComposite<T> source, RealComposite<U> target, RealComposite<LongType> lowerBoundDistanceIndex, RealComposite<DoubleType> envelopeIntersectLocation, Distance d, int dim, long size) {
        long envelopeIndexAtK;
        long position;
        long k = 0L;
        ((LongType)lowerBoundDistanceIndex.get(0L)).set(0L);
        ((DoubleType)envelopeIntersectLocation.get(0L)).set(Double.NEGATIVE_INFINITY);
        ((DoubleType)envelopeIntersectLocation.get(1L)).set(Double.POSITIVE_INFINITY);
        for (position = 1L; position < size; ++position) {
            envelopeIndexAtK = ((LongType)lowerBoundDistanceIndex.get(k)).get();
            double sourceAtPosition = ((RealType)source.get(position)).getRealDouble();
            double s = d.intersect(envelopeIndexAtK, ((RealType)source.get(envelopeIndexAtK)).getRealDouble(), position, sourceAtPosition, dim);
            double envelopeValueAtK = ((DoubleType)envelopeIntersectLocation.get(k)).get();
            while (s <= envelopeValueAtK) {
                envelopeIndexAtK = ((LongType)lowerBoundDistanceIndex.get(--k)).get();
                s = d.intersect(envelopeIndexAtK, ((RealType)source.get(envelopeIndexAtK)).getRealDouble(), position, sourceAtPosition, dim);
                envelopeValueAtK = ((DoubleType)envelopeIntersectLocation.get(k)).get();
            }
            ((LongType)lowerBoundDistanceIndex.get(++k)).set(position);
            ((DoubleType)envelopeIntersectLocation.get(k)).set(s);
            ((DoubleType)envelopeIntersectLocation.get(k + 1L)).set(Double.POSITIVE_INFINITY);
        }
        k = 0L;
        for (position = 0L; position < size; ++position) {
            while (((DoubleType)envelopeIntersectLocation.get(k + 1L)).get() < (double)position) {
                ++k;
            }
            envelopeIndexAtK = ((LongType)lowerBoundDistanceIndex.get(k)).get();
            ((RealType)target.get(position)).setReal(d.evaluate(position, envelopeIndexAtK, ((RealType)source.get(envelopeIndexAtK)).getRealDouble(), dim));
        }
    }

    private static <T extends RealType<T>, U extends RealType<U>> void transformL1AlongDimension(RandomAccessible<T> source, RandomAccessibleInterval<U> target, int dim, double weight) {
        int lastDim = target.numDimensions() - 1;
        long size = target.dimension(dim);
        RealComposite tmp = (RealComposite)Views.collapseReal(DistanceTransform.createAppropriateOneDimensionalImage(size, new DoubleType())).randomAccess().get();
        RealCursor s = Views.flatIterable(Views.collapseReal(dim == lastDim ? Views.interval(source, target) : Views.permute(Views.interval(source, target), dim, lastDim))).cursor();
        RealCursor t = Views.flatIterable(Views.collapseReal(dim == lastDim ? target : Views.permute(target, dim, lastDim))).cursor();
        while (s.hasNext()) {
            RealComposite sourceComp = (RealComposite)s.next();
            RealComposite targetComp = (RealComposite)t.next();
            for (long i = 0L; i < size; ++i) {
                ((DoubleType)tmp.get(i)).set(((RealType)sourceComp.get(i)).getRealDouble());
            }
            DistanceTransform.transformL1SingleColumn(tmp, targetComp, weight, size);
        }
    }

    private static <T extends RealType<T>, U extends RealType<U>> void transformL1AlongDimensionParallel(RandomAccessible<T> source, RandomAccessibleInterval<U> target, int dim, double weight, ExecutorService es, int nTasks) throws InterruptedException, ExecutionException {
        int largestDim = DistanceTransform.getLargestDimension(Views.hyperSlice(target, dim, target.min(dim)));
        if (largestDim >= dim) {
            ++largestDim;
        }
        long size = target.dimension(dim);
        long stepPerChunk = Math.max(size / (long)nTasks, 1L);
        long[] min = Intervals.minAsLongArray(target);
        long[] max = Intervals.maxAsLongArray(target);
        long largestDimMin = target.min(largestDim);
        long largestDimMax = target.max(largestDim);
        ArrayList<Callable<T>> tasks = new ArrayList<Callable<T>>();
        long m = largestDimMin;
        long M = largestDimMin + stepPerChunk - 1L;
        while (m <= largestDimMax) {
            min[largestDim] = m;
            max[largestDim] = Math.min(M, largestDimMax);
            FinalInterval fi = new FinalInterval(min, max);
            tasks.add(() -> {
                DistanceTransform.transformL1AlongDimension(source, Views.interval(target, fi), dim, weight);
                return null;
            });
            m += stepPerChunk;
            M += stepPerChunk;
        }
        DistanceTransform.invokeAllAndWait(es, tasks);
    }

    private static <T extends RealType<T>, U extends RealType<U>> void transformL1SingleColumn(RealComposite<T> source, RealComposite<U> target, double weight, long size) {
        double other;
        long i;
        ((RealType)target.get(0L)).setReal(((RealType)source.get(0L)).getRealDouble());
        for (i = 1L; i < size; ++i) {
            other = ((RealType)target.get(i - 1L)).getRealDouble();
            ((RealType)target.get(i)).setReal(Math.min(((RealType)source.get(i)).getRealDouble(), other + weight));
        }
        for (i = size - 2L; i > -1L; --i) {
            other = ((RealType)target.get(i + 1L)).getRealDouble();
            RealType t = (RealType)target.get(i);
            t.setReal(Math.min(t.getRealDouble(), other + weight));
        }
    }

    private static <T> void invokeAllAndWait(ExecutorService es, Collection<Callable<T>> tasks) throws InterruptedException, ExecutionException {
        List<Future<T>> futures = es.invokeAll(tasks);
        for (Future<T> f : futures) {
            f.get();
        }
    }

    private static <T extends NativeType<T> & RealType<T>> Img<T> createAppropriateOneDimensionalImage(long size, T t) {
        long[] dim = new long[]{1L, size};
        return size > Integer.MAX_VALUE ? new CellImgFactory<T>(t, Integer.MAX_VALUE).create(dim) : new ArrayImgFactory<T>(t).create(dim);
    }

    public static int getLargestDimension(Interval interval) {
        return (Integer)IntStream.range(0, interval.numDimensions()).mapToObj(i -> new ValuePair<Integer, Long>(i, interval.dimension(i))).max((p1, p2) -> Long.compare((Long)p1.getB(), (Long)p2.getB())).get().getA();
    }

    public static enum DISTANCE_TYPE {
        EUCLIDIAN,
        L1;

    }
}

