/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.neighborhood;

import java.util.Iterator;
import net.imglib2.AbstractEuclideanSpace;
import net.imglib2.AbstractLocalizable;
import net.imglib2.Cursor;
import net.imglib2.Interval;
import net.imglib2.Positionable;
import net.imglib2.RandomAccess;
import net.imglib2.RealPositionable;
import net.imglib2.algorithm.neighborhood.Neighborhood;
import net.imglib2.algorithm.neighborhood.RectangleNeighborhoodFactory;
import net.imglib2.util.IntervalIndexer;

public class RectangleNeighborhoodSkipCenter<T>
extends AbstractLocalizable
implements Neighborhood<T> {
    private final long[] currentMin;
    private final long[] currentMax;
    private final long[] dimensions;
    private final RandomAccess<T> sourceRandomAccess;
    private final Interval structuringElementBoundingBox;
    private final long maxIndex;
    private final long midIndex;

    public static <T> RectangleNeighborhoodFactory<T> factory() {
        return new RectangleNeighborhoodFactory<T>(){

            @Override
            public Neighborhood<T> create(long[] position, long[] currentMin, long[] currentMax, Interval span, RandomAccess<T> sourceRandomAccess) {
                return new RectangleNeighborhoodSkipCenter(position, currentMin, currentMax, span, sourceRandomAccess);
            }
        };
    }

    RectangleNeighborhoodSkipCenter(long[] position, long[] currentMin, long[] currentMax, Interval span, RandomAccess<T> sourceRandomAccess) {
        super(position);
        this.currentMin = currentMin;
        this.currentMax = currentMax;
        this.dimensions = new long[this.n];
        span.dimensions(this.dimensions);
        long mi = this.dimensions[0];
        for (int d = 1; d < this.n; ++d) {
            mi *= this.dimensions[d];
        }
        this.maxIndex = mi;
        long[] centerOffset = new long[this.n];
        for (int d = 0; d < this.n; ++d) {
            centerOffset[d] = -span.min(d);
        }
        this.midIndex = IntervalIndexer.positionToIndex(centerOffset, this.dimensions) + 1L;
        this.sourceRandomAccess = sourceRandomAccess;
        this.structuringElementBoundingBox = span;
    }

    @Override
    public Interval getStructuringElementBoundingBox() {
        return this.structuringElementBoundingBox;
    }

    @Override
    public long size() {
        return this.maxIndex - 1L;
    }

    @Override
    public T firstElement() {
        return this.cursor().next();
    }

    @Override
    public Object iterationOrder() {
        return this;
    }

    @Override
    public double realMin(int d) {
        return this.currentMin[d];
    }

    @Override
    public void realMin(double[] min) {
        for (int d = 0; d < this.n; ++d) {
            min[d] = this.currentMin[d];
        }
    }

    @Override
    public void realMin(RealPositionable min) {
        for (int d = 0; d < this.n; ++d) {
            min.setPosition(this.currentMin[d], d);
        }
    }

    @Override
    public double realMax(int d) {
        return this.currentMax[d];
    }

    @Override
    public void realMax(double[] max) {
        for (int d = 0; d < this.n; ++d) {
            max[d] = this.currentMax[d];
        }
    }

    @Override
    public void realMax(RealPositionable max) {
        for (int d = 0; d < this.n; ++d) {
            max.setPosition(this.currentMax[d], d);
        }
    }

    @Override
    public Iterator<T> iterator() {
        return this.cursor();
    }

    @Override
    public long min(int d) {
        return this.currentMin[d];
    }

    @Override
    public void min(long[] min) {
        for (int d = 0; d < this.n; ++d) {
            min[d] = this.currentMin[d];
        }
    }

    @Override
    public void min(Positionable min) {
        for (int d = 0; d < this.n; ++d) {
            min.setPosition(this.currentMin[d], d);
        }
    }

    @Override
    public long max(int d) {
        return this.currentMax[d];
    }

    @Override
    public void max(long[] max) {
        for (int d = 0; d < this.n; ++d) {
            max[d] = this.currentMax[d];
        }
    }

    @Override
    public void max(Positionable max) {
        for (int d = 0; d < this.n; ++d) {
            max.setPosition(this.currentMax[d], d);
        }
    }

    @Override
    public void dimensions(long[] dimensions) {
        for (int d = 0; d < this.n; ++d) {
            dimensions[d] = this.dimensions[d];
        }
    }

    @Override
    public long dimension(int d) {
        return this.dimensions[d];
    }

    @Override
    public LocalCursor cursor() {
        return new LocalCursor(this.sourceRandomAccess.copyRandomAccess());
    }

    @Override
    public LocalCursor localizingCursor() {
        return this.cursor();
    }

    public final class LocalCursor
    extends AbstractEuclideanSpace
    implements Cursor<T> {
        private final RandomAccess<T> source;
        private long index;
        private long maxIndexOnLine;

        public LocalCursor(RandomAccess<T> source) {
            super(source.numDimensions());
            this.source = source;
            this.reset();
        }

        protected LocalCursor(LocalCursor c) {
            super(c.numDimensions());
            this.source = c.source.copyRandomAccess();
            this.index = c.index;
        }

        @Override
        public T get() {
            return this.source.get();
        }

        @Override
        public void fwd() {
            this.source.fwd(0);
            if (++this.index > this.maxIndexOnLine) {
                this.nextLine();
            }
            if (this.index == RectangleNeighborhoodSkipCenter.this.midIndex) {
                this.fwd();
            }
        }

        private void nextLine() {
            this.source.setPosition(RectangleNeighborhoodSkipCenter.this.currentMin[0], 0);
            this.maxIndexOnLine += RectangleNeighborhoodSkipCenter.this.dimensions[0];
            for (int d = 1; d < this.n; ++d) {
                this.source.fwd(d);
                if (this.source.getLongPosition(d) <= RectangleNeighborhoodSkipCenter.this.currentMax[d]) break;
                this.source.setPosition(RectangleNeighborhoodSkipCenter.this.currentMin[d], d);
            }
        }

        @Override
        public void jumpFwd(long steps) {
            for (long i = 0L; i < steps; ++i) {
                this.fwd();
            }
        }

        @Override
        public T next() {
            this.fwd();
            return this.get();
        }

        @Override
        public void remove() {
        }

        @Override
        public void reset() {
            this.source.setPosition(RectangleNeighborhoodSkipCenter.this.currentMin);
            this.source.bck(0);
            this.index = 0L;
            this.maxIndexOnLine = RectangleNeighborhoodSkipCenter.this.dimensions[0];
        }

        @Override
        public boolean hasNext() {
            return this.index < RectangleNeighborhoodSkipCenter.this.maxIndex;
        }

        @Override
        public float getFloatPosition(int d) {
            return this.source.getFloatPosition(d);
        }

        @Override
        public double getDoublePosition(int d) {
            return this.source.getDoublePosition(d);
        }

        @Override
        public int getIntPosition(int d) {
            return this.source.getIntPosition(d);
        }

        @Override
        public long getLongPosition(int d) {
            return this.source.getLongPosition(d);
        }

        @Override
        public void localize(long[] position) {
            this.source.localize(position);
        }

        @Override
        public void localize(float[] position) {
            this.source.localize(position);
        }

        @Override
        public void localize(double[] position) {
            this.source.localize(position);
        }

        @Override
        public void localize(int[] position) {
            this.source.localize(position);
        }

        @Override
        public LocalCursor copy() {
            return new LocalCursor(this);
        }

        @Override
        public LocalCursor copyCursor() {
            return this.copy();
        }
    }
}

