/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.region.localneighborhood;

import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.region.localneighborhood.AbstractNeighborhood;
import net.imglib2.algorithm.region.localneighborhood.EllipseCursor;
import net.imglib2.algorithm.region.localneighborhood.Utils;
import net.imglib2.outofbounds.OutOfBoundsFactory;
import net.imglib2.outofbounds.OutOfBoundsMirrorFactory;

public class EllipseNeighborhood<T>
extends AbstractNeighborhood<T> {
    public EllipseNeighborhood(RandomAccessibleInterval<T> source, long[] center, long[] radiuses, OutOfBoundsFactory<T, RandomAccessibleInterval<T>> outOfBounds) {
        super(source.numDimensions(), outOfBounds);
        this.setSpan(radiuses);
        this.setPosition(center);
        this.updateSource(source);
    }

    public EllipseNeighborhood(RandomAccessibleInterval<T> source, long[] center, long[] radiuses) {
        this(source, center, radiuses, new OutOfBoundsMirrorFactory(OutOfBoundsMirrorFactory.Boundary.DOUBLE));
    }

    @Override
    public long size() {
        long pixel_count = 0L;
        int[] local_rxs = new int[(int)(this.span[1] + 1L)];
        Utils.getXYEllipseBounds((int)this.span[0], (int)this.span[1], local_rxs);
        int local_rx = local_rxs[0];
        pixel_count += (long)(2 * local_rx + 1);
        int i = 1;
        while ((long)i <= this.span[1]) {
            local_rx = local_rxs[i];
            pixel_count += (long)(2 * (2 * local_rx + 1));
            ++i;
        }
        return pixel_count;
    }

    @Override
    public EllipseCursor<T> cursor() {
        return new EllipseCursor(this);
    }

    @Override
    public EllipseCursor<T> localizingCursor() {
        return this.cursor();
    }

    @Override
    public EllipseCursor<T> iterator() {
        return this.cursor();
    }

    @Override
    public EllipseNeighborhood<T> copy() {
        return new EllipseNeighborhood<T>(this.source, this.center, this.span, this.outOfBounds);
    }
}

