/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.cache.img;

import net.imglib2.Dimensions;
import net.imglib2.cache.Cache;
import net.imglib2.cache.CacheLoader;
import net.imglib2.cache.LoaderCache;
import net.imglib2.cache.img.CachedCellImg;
import net.imglib2.cache.img.CellLoader;
import net.imglib2.cache.img.LoadedCellCacheLoader;
import net.imglib2.cache.img.ReadOnlyCachedCellImgOptions;
import net.imglib2.cache.ref.GuardedStrongRefLoaderCache;
import net.imglib2.cache.ref.SoftRefLoaderCache;
import net.imglib2.img.basictypeaccess.ArrayDataAccessFactory;
import net.imglib2.img.basictypeaccess.DataAccess;
import net.imglib2.img.basictypeaccess.array.ArrayDataAccess;
import net.imglib2.img.cell.Cell;
import net.imglib2.img.cell.CellGrid;
import net.imglib2.img.cell.CellImgFactory;
import net.imglib2.type.NativeType;
import net.imglib2.type.PrimitiveType;
import net.imglib2.util.Fraction;

public class ReadOnlyCachedCellImgFactory {
    private final ReadOnlyCachedCellImgOptions factoryOptions;

    public ReadOnlyCachedCellImgFactory() {
        this(ReadOnlyCachedCellImgOptions.options());
    }

    public ReadOnlyCachedCellImgFactory(ReadOnlyCachedCellImgOptions optional) {
        this.factoryOptions = optional;
    }

    public <T extends NativeType<T>> CachedCellImg<T, ?> create(long[] dim, T type, CellLoader<T> loader) {
        return this.createInternal(dim, null, loader, type, null);
    }

    public <T extends NativeType<T>> CachedCellImg<T, ?> create(long[] dim, T type, CellLoader<T> loader, ReadOnlyCachedCellImgOptions additionalOptions) {
        return this.createInternal(dim, null, loader, type, additionalOptions);
    }

    public <T extends NativeType<T>, A extends DataAccess> CachedCellImg<T, A> createWithCacheLoader(long[] dim, T type, CacheLoader<Long, Cell<A>> backingLoader) {
        return this.createInternal(dim, backingLoader, null, type, null);
    }

    public <T extends NativeType<T>, A extends DataAccess> CachedCellImg<T, A> createWithCacheLoader(long[] dim, T type, CacheLoader<Long, Cell<A>> backingLoader, ReadOnlyCachedCellImgOptions additionalOptions) {
        return this.createInternal(dim, backingLoader, null, type, additionalOptions);
    }

    private <T extends NativeType<T>, A extends ArrayDataAccess<A>> CachedCellImg<T, ?> createInternal(long[] dimensions, CacheLoader<Long, ? extends Cell<?>> cacheLoader, CellLoader<T> cellLoader, T type, ReadOnlyCachedCellImgOptions additionalOptions) {
        LoaderCache<Long, Cell<Object>> loaderCache;
        ReadOnlyCachedCellImgOptions.Values options = this.factoryOptions.append((ReadOnlyCachedCellImgOptions)additionalOptions).values;
        PrimitiveType primitiveType = type.getNativeTypeFactory().getPrimitiveType();
        Fraction entitiesPerPixel = type.getEntitiesPerPixel();
        CellGrid grid = this.createCellGrid(dimensions, entitiesPerPixel, options);
        Object accessType = ArrayDataAccessFactory.get(primitiveType, options.accessFlags());
        CacheLoader<Long, ? extends Cell<?>> loader = cacheLoader != null ? cacheLoader : LoadedCellCacheLoader.get(grid, cellLoader, type, options.accessFlags());
        switch (options.cacheType()) {
            case BOUNDED: {
                loaderCache = new GuardedStrongRefLoaderCache(options.maxCacheSize());
                break;
            }
            default: {
                loaderCache = new SoftRefLoaderCache();
            }
        }
        Cache cache = loaderCache.withLoader(loader);
        return new CachedCellImg(grid, type, cache, accessType);
    }

    private CellGrid createCellGrid(long[] dimensions, Fraction entitiesPerPixel, ReadOnlyCachedCellImgOptions.Values options) {
        Dimensions.verify(dimensions);
        int n = dimensions.length;
        int[] cellDimensions = CellImgFactory.getCellDimensions(options.cellDimensions(), n, entitiesPerPixel);
        return new CellGrid(dimensions, cellDimensions);
    }
}

