/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.roi.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import net.imglib2.AbstractWrappedInterval;
import net.imglib2.Cursor;
import net.imglib2.Interval;
import net.imglib2.IterableInterval;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.roi.IterableRegion;
import net.imglib2.roi.Regions;
import net.imglib2.roi.util.TrueCursor;
import net.imglib2.type.BooleanType;
import net.imglib2.view.Views;

public class IterableRegionOnBooleanRAI<T extends BooleanType<T>>
extends AbstractWrappedInterval<RandomAccessibleInterval<T>>
implements IterableRegion<T> {
    private final long size;
    private final IterableInterval<T> sourceIterable;
    private final InsideIterable inside;

    public IterableRegionOnBooleanRAI(RandomAccessibleInterval<T> interval) {
        this(interval, Regions.countTrue(interval));
    }

    public IterableRegionOnBooleanRAI(RandomAccessibleInterval<T> interval, long size) {
        super(interval);
        this.size = size;
        this.sourceIterable = Views.iterable(interval);
        this.inside = new InsideIterable();
    }

    @Override
    public RandomAccess<T> randomAccess() {
        return ((RandomAccessibleInterval)this.sourceInterval).randomAccess();
    }

    @Override
    public RandomAccess<T> randomAccess(Interval interval) {
        return ((RandomAccessibleInterval)this.sourceInterval).randomAccess(interval);
    }

    @Override
    public Cursor<T> cursor() {
        return ((RandomAccessibleInterval)this.sourceInterval).cursor();
    }

    @Override
    public Cursor<T> localizingCursor() {
        return ((RandomAccessibleInterval)this.sourceInterval).localizingCursor();
    }

    @Override
    public Object iterationOrder() {
        return ((RandomAccessibleInterval)this.sourceInterval).iterationOrder();
    }

    @Override
    public long size() {
        return ((RandomAccessibleInterval)this.sourceInterval).size();
    }

    @Override
    public T getType() {
        return (T)((BooleanType)((RandomAccessibleInterval)this.sourceInterval).getType());
    }

    @Override
    public IterableInterval<Void> inside() {
        return this.inside;
    }

    private final class InsideIterable
    extends AbstractWrappedInterval<Interval>
    implements IterableInterval<Void> {
        InsideIterable() {
            super(IterableRegionOnBooleanRAI.this);
        }

        @Override
        public long size() {
            return IterableRegionOnBooleanRAI.this.size;
        }

        @Override
        public Void firstElement() {
            if (this.size() == 0L) {
                throw new NoSuchElementException();
            }
            return (Void)this.cursor().next();
        }

        @Override
        public Object iterationOrder() {
            return this;
        }

        @Override
        public Iterator<Void> iterator() {
            return this.cursor();
        }

        @Override
        public Cursor<Void> cursor() {
            return new TrueCursor(IterableRegionOnBooleanRAI.this.sourceIterable.cursor(), IterableRegionOnBooleanRAI.this.size);
        }

        @Override
        public Cursor<Void> localizingCursor() {
            return new TrueCursor(IterableRegionOnBooleanRAI.this.sourceIterable.localizingCursor(), IterableRegionOnBooleanRAI.this.size);
        }

        @Override
        public Void getType() {
            return null;
        }
    }
}

