/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ui;

import java.awt.image.BufferedImage;
import net.imglib2.concatenate.Concatenable;
import net.imglib2.display.screenimage.awt.ARGBScreenImage;
import net.imglib2.realtransform.AffineGet;
import net.imglib2.ui.AbstractRenderer;
import net.imglib2.ui.AffineTransformType;
import net.imglib2.ui.InterruptibleProjector;
import net.imglib2.ui.PainterThread;
import net.imglib2.ui.RenderTarget;
import net.imglib2.ui.util.GuiUtil;

public abstract class AbstractSimpleRenderer<A extends AffineGet & Concatenable<AffineGet>>
extends AbstractRenderer<A> {
    protected InterruptibleProjector projector;
    protected final boolean doubleBuffered;
    protected ARGBScreenImage[] screenImages;
    protected BufferedImage[] bufferedImages;
    protected final int numRenderingThreads;

    public AbstractSimpleRenderer(AffineTransformType<A> transformType, RenderTarget display, PainterThread painterThread, boolean doubleBuffered, int numRenderingThreads) {
        super(transformType, display, painterThread);
        this.doubleBuffered = doubleBuffered;
        this.numRenderingThreads = numRenderingThreads;
        this.screenImages = new ARGBScreenImage[2];
        this.bufferedImages = new BufferedImage[2];
        this.projector = null;
    }

    protected synchronized boolean checkResize() {
        int componentW = this.display.getWidth();
        int componentH = this.display.getHeight();
        if (componentW <= 0 || componentH <= 0) {
            return false;
        }
        if (this.screenImages[0] == null || this.screenImages[0].dimension(0) != (long)componentW || this.screenImages[0].dimension(1) != (long)componentH) {
            for (int b = 0; b < (this.doubleBuffered ? 2 : 1); ++b) {
                this.screenImages[b] = new ARGBScreenImage(componentW, componentH);
                this.bufferedImages[b] = GuiUtil.getBufferedImage(this.screenImages[b]);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean paint(A viewerTransform) {
        InterruptibleProjector p;
        BufferedImage bufferedImage;
        ARGBScreenImage screenImage;
        if (!this.checkResize()) {
            return false;
        }
        AbstractSimpleRenderer abstractSimpleRenderer = this;
        synchronized (abstractSimpleRenderer) {
            screenImage = this.screenImages[0];
            bufferedImage = this.bufferedImages[0];
            this.projector = p = this.createProjector(viewerTransform, screenImage);
        }
        boolean success = p.map();
        AbstractSimpleRenderer abstractSimpleRenderer2 = this;
        synchronized (abstractSimpleRenderer2) {
            if (success) {
                this.display.setBufferedImage(bufferedImage);
                if (this.doubleBuffered) {
                    this.screenImages[0] = this.screenImages[1];
                    this.screenImages[1] = screenImage;
                    this.bufferedImages[0] = this.bufferedImages[1];
                    this.bufferedImages[1] = bufferedImage;
                }
            }
        }
        return success;
    }

    protected abstract InterruptibleProjector createProjector(A var1, ARGBScreenImage var2);
}

