/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ui.overlay;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;
import net.imglib2.ui.OverlayRenderer;

public class LogoPainter
implements OverlayRenderer {
    private final BufferedImage imgLib2Overlay;
    private final int border;
    private final int[] overlaySize = new int[2];
    private int canvasW = 1;
    private int canvasH = 1;

    public LogoPainter() {
        this(LogoPainter.class.getResource("/imglib2-logo-35x40.png"), 5);
    }

    public LogoPainter(String overlayFilename, int border) {
        this.imgLib2Overlay = this.loadImgLib2Overlay(overlayFilename);
        this.border = border;
        if (this.imgLib2Overlay != null) {
            this.overlaySize[0] = this.imgLib2Overlay.getWidth();
            this.overlaySize[1] = this.imgLib2Overlay.getHeight();
        }
    }

    public LogoPainter(URL overlayUrl, int border) {
        this.imgLib2Overlay = this.loadImgLib2Overlay(overlayUrl);
        this.border = border;
        if (this.imgLib2Overlay != null) {
            this.overlaySize[0] = this.imgLib2Overlay.getWidth();
            this.overlaySize[1] = this.imgLib2Overlay.getHeight();
        }
    }

    @Override
    public void drawOverlays(Graphics g) {
        if (this.imgLib2Overlay != null && this.canvasW + this.border >= this.overlaySize[0] && this.canvasH + this.border >= this.overlaySize[1]) {
            int x = this.canvasW - this.overlaySize[0] - this.border;
            int y = this.border;
            g.drawImage(this.imgLib2Overlay, x, y, this.overlaySize[0], this.overlaySize[1], null);
        }
    }

    @Override
    public void setCanvasSize(int width, int height) {
        this.canvasW = width;
        this.canvasH = height;
    }

    private BufferedImage loadImgLib2Overlay(String overlayFilename) {
        try {
            return ImageIO.read(new File(overlayFilename));
        }
        catch (IOException e) {
            return null;
        }
    }

    private BufferedImage loadImgLib2Overlay(URL overlayUrl) {
        try {
            return ImageIO.read(overlayUrl);
        }
        catch (IOException e) {
            return null;
        }
    }
}

