/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.view.composite;

import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPositionable;
import net.imglib2.img.Img;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.img.list.ListImgFactory;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.view.composite.AbstractNumericComposite;
import net.imglib2.view.composite.CompositeFactory;

public class RealComposite<T extends RealType<T>>
extends AbstractNumericComposite<T, RealComposite<T>>
implements RealPositionable,
RealLocalizable {
    public RealComposite(RandomAccess<T> sourceAccess, int length) {
        super(sourceAccess, length);
    }

    @Override
    public RealComposite<T> createVariable() {
        RealType t = (RealType)this.sourceAccess.get();
        Img img = NativeType.class.isInstance(t) ? new ArrayImgFactory<NativeType>((NativeType)((Object)t)).create(new long[]{this.length}) : new ListImgFactory<RealType>(t).create(new long[]{this.length});
        return new RealComposite(img.randomAccess(), this.length);
    }

    @Override
    public RealComposite<T> copy() {
        return new RealComposite<T>(this.sourceAccess.copy(), this.length);
    }

    @Override
    public void fwd(int d) {
        ((RealType)this.get(d)).inc();
    }

    @Override
    public void bck(int d) {
        ((RealType)this.get(d)).dec();
    }

    @Override
    public void move(int distance, int d) {
        RealType t = (RealType)this.get(d);
        t.setReal(t.getRealDouble() + (double)distance);
    }

    @Override
    public void move(long distance, int d) {
        RealType t = (RealType)this.get(d);
        t.setReal(t.getRealDouble() + (double)distance);
    }

    @Override
    public void move(Localizable distance) {
        this.sourceAccess.setPosition(0, this.d);
        for (int d = 0; d < this.length; ++d) {
            RealType t = (RealType)this.sourceAccess.get();
            t.setReal(t.getRealDouble() + distance.getDoublePosition(d));
            this.sourceAccess.fwd(this.d);
        }
    }

    @Override
    public void move(int[] distance) {
        this.sourceAccess.setPosition(0, this.d);
        for (int d = 0; d < this.length; ++d) {
            RealType t = (RealType)this.sourceAccess.get();
            t.setReal(t.getRealDouble() + (double)distance[d]);
            this.sourceAccess.fwd(this.d);
        }
    }

    @Override
    public void move(long[] distance) {
        this.sourceAccess.setPosition(0, this.d);
        for (int d = 0; d < this.length; ++d) {
            RealType t = (RealType)this.sourceAccess.get();
            t.setReal(t.getRealDouble() + (double)distance[d]);
            this.sourceAccess.fwd(this.d);
        }
    }

    @Override
    public void setPosition(Localizable position) {
        this.sourceAccess.setPosition(0, this.d);
        for (int d = 0; d < this.length; ++d) {
            ((RealType)this.sourceAccess.get()).setReal(position.getDoublePosition(d));
            this.sourceAccess.fwd(this.d);
        }
    }

    @Override
    public void setPosition(int[] position) {
        this.sourceAccess.setPosition(0, this.d);
        for (int d = 0; d < this.length; ++d) {
            ((RealType)this.sourceAccess.get()).setReal(position[d]);
            this.sourceAccess.fwd(this.d);
        }
    }

    @Override
    public void setPosition(long[] position) {
        this.sourceAccess.setPosition(0, this.d);
        for (int d = 0; d < this.length; ++d) {
            ((RealType)this.sourceAccess.get()).setReal(position[d]);
            this.sourceAccess.fwd(this.d);
        }
    }

    @Override
    public void setPosition(int position, int d) {
        ((RealType)this.get(d)).setReal(position);
    }

    @Override
    public void setPosition(long position, int d) {
        ((RealType)this.get(d)).setReal(position);
    }

    @Override
    public int numDimensions() {
        return this.length;
    }

    @Override
    public double getDoublePosition(int d) {
        return ((RealType)this.get(d)).getRealDouble();
    }

    @Override
    public void move(float distance, int d) {
        RealType t = (RealType)this.get(d);
        t.setReal(t.getRealDouble() + (double)distance);
    }

    @Override
    public void move(double distance, int d) {
        RealType t = (RealType)this.get(d);
        t.setReal(t.getRealDouble() + distance);
    }

    @Override
    public void move(RealLocalizable distance) {
        this.sourceAccess.setPosition(0, this.d);
        for (int d = 0; d < this.length; ++d) {
            RealType t = (RealType)this.sourceAccess.get();
            t.setReal(t.getRealDouble() + distance.getDoublePosition(d));
            this.sourceAccess.fwd(this.d);
        }
    }

    @Override
    public void move(float[] distance) {
        this.sourceAccess.setPosition(0, this.d);
        for (int d = 0; d < this.length; ++d) {
            RealType t = (RealType)this.sourceAccess.get();
            t.setReal(t.getRealDouble() + (double)distance[d]);
            this.sourceAccess.fwd(this.d);
        }
    }

    @Override
    public void move(double[] distance) {
        this.sourceAccess.setPosition(0, this.d);
        for (int d = 0; d < this.length; ++d) {
            RealType t = (RealType)this.sourceAccess.get();
            t.setReal(t.getRealDouble() + distance[d]);
            this.sourceAccess.fwd(this.d);
        }
    }

    @Override
    public void setPosition(RealLocalizable position) {
        this.sourceAccess.setPosition(0, this.d);
        for (int d = 0; d < this.length; ++d) {
            ((RealType)this.sourceAccess.get()).setReal(position.getDoublePosition(d));
            this.sourceAccess.fwd(this.d);
        }
    }

    @Override
    public void setPosition(float[] position) {
        this.sourceAccess.setPosition(0, this.d);
        for (int d = 0; d < this.length; ++d) {
            ((RealType)this.sourceAccess.get()).setReal(position[d]);
            this.sourceAccess.fwd(this.d);
        }
    }

    @Override
    public void setPosition(double[] position) {
        this.sourceAccess.setPosition(0, this.d);
        for (int d = 0; d < this.length; ++d) {
            ((RealType)this.sourceAccess.get()).setReal(position[d]);
            this.sourceAccess.fwd(this.d);
        }
    }

    @Override
    public void setPosition(float position, int d) {
        ((RealType)this.get(d)).setReal(position);
    }

    @Override
    public void setPosition(double position, int d) {
        ((RealType)this.get(d)).setReal(position);
    }

    public static class Factory<T extends RealType<T>>
    implements CompositeFactory<T, RealComposite<T>> {
        protected final int numChannels;

        public Factory(int numChannels) {
            this.numChannels = numChannels;
        }

        @Override
        public RealComposite<T> create(RandomAccess<T> sourceAccess) {
            return new RealComposite<T>(sourceAccess, this.numChannels);
        }
    }
}

