/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.gradient;

import java.util.function.ToDoubleFunction;
import net.imglib2.Interval;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.converter.AbstractConvertedRandomAccess;
import net.imglib2.converter.AbstractConvertedRandomAccessible;
import net.imglib2.type.Type;
import net.imglib2.type.operators.MulFloatingPoint;

public class ScaleAsFunctionOfPosition<T extends Type<T> & MulFloatingPoint>
extends AbstractConvertedRandomAccessible<T, T> {
    private final ToDoubleFunction<Localizable> scalingFunction;

    public ScaleAsFunctionOfPosition(RandomAccessibleInterval<T> source, ToDoubleFunction<Localizable> scalingFunction) {
        super(source);
        this.scalingFunction = scalingFunction;
    }

    @Override
    public ScaledRandomAccess<T> randomAccess() {
        return new ScaledRandomAccess(this.source.randomAccess(), this.scalingFunction);
    }

    @Override
    public AbstractConvertedRandomAccess<T, T> randomAccess(Interval interval) {
        return this.randomAccess();
    }

    public static class ScaledRandomAccess<T extends Type<T> & MulFloatingPoint>
    extends AbstractConvertedRandomAccess<T, T> {
        private final T t;
        private final ToDoubleFunction<Localizable> scalingFunction;

        public ScaledRandomAccess(RandomAccess<T> source, ToDoubleFunction<Localizable> scalingFunction) {
            super(source);
            this.t = ((Type)source.get()).createVariable();
            this.scalingFunction = scalingFunction;
        }

        @Override
        public T get() {
            this.t.set((Type)((Type)this.source.get()));
            ((MulFloatingPoint)this.t).mul(this.scalingFunction.applyAsDouble(this.source));
            return this.t;
        }

        @Override
        public ScaledRandomAccess<T> copy() {
            return new ScaledRandomAccess(this.source.copyRandomAccess(), this.scalingFunction);
        }
    }
}

