/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.kdtree;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;
import net.imglib2.KDTreeNode;

public class KDTreeNodeIterable<T>
implements Iterable<KDTreeNode<T>> {
    private final ArrayList<KDTreeNode<T>> singleNodes;
    private final ArrayList<KDTreeNode<T>> subtrees;

    public KDTreeNodeIterable(ArrayList<KDTreeNode<T>> singleNodes, ArrayList<KDTreeNode<T>> subtrees) {
        this.singleNodes = singleNodes;
        this.subtrees = subtrees;
    }

    @Override
    public Iterator<KDTreeNode<T>> iterator() {
        return new Iter(this.singleNodes, this.subtrees);
    }

    private static class Iter<T>
    implements Iterator<KDTreeNode<T>> {
        private final ArrayList<KDTreeNode<T>> nodes;
        private int nextNodeIndex;
        private final ArrayList<KDTreeNode<T>> subtrees;
        private int nextSubtreeIndex;
        private final ArrayDeque<KDTreeNode<T>> stack;

        private Iter(ArrayList<KDTreeNode<T>> nodes, ArrayList<KDTreeNode<T>> subtrees) {
            this.nodes = nodes;
            this.subtrees = subtrees;
            this.nextNodeIndex = 0;
            this.nextSubtreeIndex = 0;
            this.stack = new ArrayDeque();
        }

        @Override
        public boolean hasNext() {
            return !this.stack.isEmpty() || this.nextSubtreeIndex < this.subtrees.size() || this.nextNodeIndex < this.nodes.size();
        }

        @Override
        public KDTreeNode<T> next() {
            if (!this.stack.isEmpty()) {
                KDTreeNode<T> current = this.stack.pop();
                if (current.left != null) {
                    this.stack.push(current.left);
                }
                if (current.right != null) {
                    this.stack.push(current.right);
                }
                return current;
            }
            if (this.nextSubtreeIndex < this.subtrees.size()) {
                KDTreeNode<T> current = this.subtrees.get(this.nextSubtreeIndex++);
                if (current.left != null) {
                    this.stack.push(current.left);
                }
                if (current.right != null) {
                    this.stack.push(current.right);
                }
                return current;
            }
            if (this.nextNodeIndex < this.nodes.size()) {
                return this.nodes.get(this.nextNodeIndex++);
            }
            return null;
        }

        @Override
        public void remove() {
        }
    }
}

