/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.labeling;

import gnu.trove.list.array.TIntArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import net.imglib2.FinalInterval;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealCursor;
import net.imglib2.iterator.IntervalIterator;
import net.imglib2.roi.labeling.ImgLabeling;
import net.imglib2.roi.labeling.LabelingMapping;
import net.imglib2.type.numeric.IntegerType;
import net.imglib2.view.Views;

public final class ConnectedComponents {
    public static <T extends IntegerType<T>, L, I extends IntegerType<I>> void labelAllConnectedComponents(RandomAccessible<T> input, ImgLabeling<L, I> labeling, Iterator<L> labelGenerator, StructuringElement se) {
        int numThreads = Runtime.getRuntime().availableProcessors();
        ExecutorService service = Executors.newFixedThreadPool(numThreads);
        ConnectedComponents.labelAllConnectedComponents(input, labeling, labelGenerator, se, service);
        service.shutdown();
    }

    public static <T extends IntegerType<T>, L, I extends IntegerType<I>> void labelAllConnectedComponents(RandomAccessible<T> input, ImgLabeling<L, I> labeling, Iterator<L> labelGenerator, StructuringElement se, ExecutorService service) {
        RandomAccessibleInterval<I> output = labeling.getIndexImg();
        for (IntegerType i : Views.iterable(output)) {
            i.setZero();
        }
        int numLabels = ConnectedComponents.labelAllConnectedComponents(input, output, se) + 1;
        final ArrayList labelSets = new ArrayList();
        labelSets.add(new HashSet());
        for (int i = 1; i < numLabels; ++i) {
            HashSet<L> set = new HashSet<L>();
            set.add(labelGenerator.next());
            labelSets.add(set);
        }
        new LabelingMapping.SerialisationAccess<L>(labeling.getMapping()){
            {
                super(x0);
                super.setLabelSets(labelSets);
            }
        };
    }

    public static <T extends IntegerType<T>, L extends IntegerType<L>> int labelAllConnectedComponents(RandomAccessible<T> input, RandomAccessibleInterval<L> output, StructuringElement se) {
        int numThreads = Runtime.getRuntime().availableProcessors();
        ExecutorService service = Executors.newFixedThreadPool(numThreads);
        int result = ConnectedComponents.labelAllConnectedComponents(input, output, se, service);
        service.shutdown();
        return result;
    }

    public static <T extends IntegerType<T>, L extends IntegerType<L>> int labelAllConnectedComponents(RandomAccessible<T> input, RandomAccessibleInterval<L> output, StructuringElement se, ExecutorService service) {
        int n = output.numDimensions();
        int splitDim = n - 1;
        long[] min = new long[n];
        long[] max = new long[n];
        output.min(min);
        output.max(max);
        long splitDimMax = max[splitDim];
        int numThreads = Runtime.getRuntime().availableProcessors();
        int numTasks = numThreads > 1 ? numThreads * 2 : 1;
        numTasks = (int)Math.max(1L, Math.min((long)numTasks, output.dimension(splitDim) / 4L));
        long taskSize = output.dimension(splitDim) / (long)numTasks;
        Fragment[] fragments = new Fragment[numTasks];
        CollectNeighborLabels collectNeighborLabels = se.getFactory().newInstance(n);
        for (int i = 0; i < numTasks; ++i) {
            max[splitDim] = i == numTasks - 1 ? splitDimMax : min[splitDim] + taskSize - 1L;
            fragments[i] = new Fragment<T, L>(input, Views.interval(output, min, max), collectNeighborLabels);
            int n2 = splitDim;
            min[n2] = min[n2] + taskSize;
        }
        ArrayList futures = new ArrayList();
        for (final Fragment fragment : fragments) {
            futures.add(service.submit(new Runnable(){

                @Override
                public void run() {
                    fragment.mark();
                }
            }));
        }
        ConnectedComponents.getAllFutures(futures);
        TIntArrayList merged = ConnectedComponents.mergeCanonicalLists(fragments);
        for (int i = 1; i < numTasks; ++i) {
            fragments[i].linkToPreviousFragment(fragments[i - 1], merged);
        }
        int numComponents = ConnectedComponents.splitCanonicalLists(fragments, merged);
        for (final Fragment fragment : fragments) {
            futures.add(service.submit(new Runnable(){

                @Override
                public void run() {
                    fragment.relabel();
                }
            }));
        }
        ConnectedComponents.getAllFutures(futures);
        return numComponents;
    }

    private static <T extends IntegerType<T>, L extends IntegerType<L>> TIntArrayList mergeCanonicalLists(Fragment<T, L>[] fragments) {
        int size = 0;
        for (Fragment<T, L> fragment : fragments) {
            ((Fragment)fragment).offset = size;
            size += ((Fragment)fragment).canonicalLabels.size() - 1;
        }
        TIntArrayList merged = new TIntArrayList(size + 1);
        merged.add(0);
        for (Fragment<T, L> fragment : fragments) {
            TIntArrayList fl = ((Fragment)fragment).canonicalLabels;
            int o = ((Fragment)fragment).offset;
            for (int i = 1; i < fl.size(); ++i) {
                merged.add(fl.get(i) + o);
            }
        }
        return merged;
    }

    private static <T extends IntegerType<T>, L extends IntegerType<L>> int splitCanonicalLists(Fragment<T, L>[] fragments, TIntArrayList merged) {
        int nextLabel = 1;
        for (int i = 1; i < merged.size(); ++i) {
            if (merged.get(i) == i) {
                merged.set(i, nextLabel++);
                continue;
            }
            merged.set(i, merged.get(merged.get(i)));
        }
        for (Fragment<T, L> fragment : fragments) {
            TIntArrayList fl = ((Fragment)fragment).canonicalLabels;
            int o = ((Fragment)fragment).offset;
            for (int i = 1; i < fl.size(); ++i) {
                fl.set(i, merged.get(i + o));
            }
        }
        return nextLabel - 1;
    }

    private static void getAllFutures(List<Future<?>> futures) {
        for (Future<?> future : futures) {
            try {
                future.get();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
        futures.clear();
    }

    private static final class Collect8NeighborLabels<L extends IntegerType<L>>
    implements CollectNeighborLabels<L> {
        private final int n;
        private final long[][] offsets;
        private final long[] pos;
        private final long[] previousFragmentPos;
        private final int numPreviousFragmentOffsets;
        private static final CollectNeighborLabelsFactory factory = new CollectNeighborLabelsFactory(){

            @Override
            public <L extends IntegerType<L>> CollectNeighborLabels<L> newInstance(int n) {
                return new Collect8NeighborLabels(n);
            }
        };

        private Collect8NeighborLabels(int n) {
            this.n = n;
            int nOffsets = 0;
            for (int d = 0; d < n; ++d) {
                nOffsets = 3 * nOffsets + 1;
            }
            this.numPreviousFragmentOffsets = (int)Math.pow(3.0, n - 1);
            this.offsets = new long[nOffsets][];
            this.pos = new long[n];
            this.previousFragmentPos = new long[n];
            long[] min = new long[n];
            Arrays.fill(min, -1L);
            long[] max = new long[n];
            Arrays.fill(max, 1L);
            IntervalIterator idx = new IntervalIterator(new FinalInterval(min, max));
            for (int i = 0; i < this.offsets.length; ++i) {
                int d;
                this.offsets[i] = new long[n];
                block2: while (true) {
                    idx.fwd();
                    idx.localize(this.offsets[i]);
                    d = n - 1;
                    while (true) {
                        if (d < 0) continue block2;
                        if (this.offsets[i][d] < 0L) break block2;
                        --d;
                    }
                    break;
                }
                for (d = 0; d < n; ++d) {
                    long[] lArray = this.offsets[i];
                    int n2 = d;
                    lArray[n2] = lArray[n2] - this.pos[d];
                    int n3 = d;
                    this.pos[n3] = this.pos[n3] + this.offsets[i][d];
                }
                if (i != this.numPreviousFragmentOffsets - 1) continue;
                for (d = 0; d < n; ++d) {
                    this.previousFragmentPos[d] = -this.pos[d];
                }
            }
            for (int d = 0; d < n; ++d) {
                this.pos[d] = -this.pos[d];
            }
        }

        @Override
        public void collect(RandomAccess<L> la, TIntArrayList neighborLabels, long[] labelsMin, long[] labelsMax) {
            for (int d = 0; d < this.n; ++d) {
                if (la.getLongPosition(d) > labelsMin[d] && la.getLongPosition(d) < labelsMax[d]) continue;
                this.collectChecked(la, neighborLabels, labelsMin, labelsMax);
                return;
            }
            this.collectUnchecked(la, neighborLabels);
        }

        private void collectChecked(RandomAccess<L> la, TIntArrayList neighborLabels, long[] labelsMin, long[] labelsMax) {
            neighborLabels.clear();
            block0: for (int i = 0; i < this.offsets.length; ++i) {
                la.move(this.offsets[i]);
                for (int d = 0; d < this.n; ++d) {
                    if (la.getLongPosition(d) < labelsMin[d] || la.getLongPosition(d) > labelsMax[d]) continue block0;
                }
                int l = ((IntegerType)la.get()).getInteger();
                if (l == 0) continue;
                neighborLabels.add(l);
            }
            la.move(this.pos);
        }

        private void collectUnchecked(RandomAccess<L> la, TIntArrayList neighborLabels) {
            neighborLabels.clear();
            for (int i = 0; i < this.offsets.length; ++i) {
                la.move(this.offsets[i]);
                int l = ((IntegerType)la.get()).getInteger();
                if (l == 0) continue;
                neighborLabels.add(l);
            }
            la.move(this.pos);
        }

        @Override
        public void collectAtPreviousFragmentBorder(RandomAccess<L> la, TIntArrayList neighborLabels, long[] labelsMin, long[] labelsMax) {
            for (int d = 0; d < this.n - 1; ++d) {
                if (la.getLongPosition(d) > labelsMin[d] && la.getLongPosition(d) < labelsMax[d]) continue;
                this.collectAtPreviousFragmentBorderChecked(la, neighborLabels, labelsMin, labelsMax);
                return;
            }
            this.collectAtPreviousFragmentBorderUnchecked(la, neighborLabels);
        }

        private void collectAtPreviousFragmentBorderChecked(RandomAccess<L> la, TIntArrayList neighborLabels, long[] labelsMin, long[] labelsMax) {
            neighborLabels.clear();
            block0: for (int i = 0; i < this.numPreviousFragmentOffsets; ++i) {
                la.move(this.offsets[i]);
                for (int d = 0; d < this.n - 1; ++d) {
                    if (la.getLongPosition(d) < labelsMin[d] || la.getLongPosition(d) > labelsMax[d]) continue block0;
                }
                int l = ((IntegerType)la.get()).getInteger();
                if (l == 0) continue;
                neighborLabels.add(l);
            }
            la.move(this.previousFragmentPos);
        }

        private void collectAtPreviousFragmentBorderUnchecked(RandomAccess<L> la, TIntArrayList neighborLabels) {
            neighborLabels.clear();
            for (int i = 0; i < this.numPreviousFragmentOffsets; ++i) {
                la.move(this.offsets[i]);
                int l = ((IntegerType)la.get()).getInteger();
                if (l == 0) continue;
                neighborLabels.add(l);
            }
            la.move(this.previousFragmentPos);
        }

        static /* synthetic */ CollectNeighborLabelsFactory access$100() {
            return factory;
        }
    }

    private static final class Collect4NeighborLabels<L extends IntegerType<L>>
    implements CollectNeighborLabels<L> {
        private final int n;
        private static final CollectNeighborLabelsFactory factory = new CollectNeighborLabelsFactory(){

            @Override
            public <L extends IntegerType<L>> CollectNeighborLabels<L> newInstance(int n) {
                return new Collect4NeighborLabels(n);
            }
        };

        private Collect4NeighborLabels(int n) {
            this.n = n;
        }

        @Override
        public void collect(RandomAccess<L> la, TIntArrayList neighborLabels, long[] labelsMin, long[] labelsMax) {
            neighborLabels.clear();
            for (int d = 0; d < this.n; ++d) {
                if (la.getLongPosition(d) <= labelsMin[d]) continue;
                la.bck(d);
                int l = ((IntegerType)la.get()).getInteger();
                if (l != 0) {
                    neighborLabels.add(l);
                }
                la.fwd(d);
            }
        }

        @Override
        public void collectAtPreviousFragmentBorder(RandomAccess<L> la, TIntArrayList neighborLabels, long[] labelsMin, long[] labelsMax) {
            neighborLabels.clear();
            la.bck(this.n - 1);
            int l = ((IntegerType)la.get()).getInteger();
            if (l != 0) {
                neighborLabels.add(l);
            }
            la.fwd(this.n - 1);
        }

        static /* synthetic */ CollectNeighborLabelsFactory access$000() {
            return factory;
        }
    }

    private static interface CollectNeighborLabelsFactory {
        public <L extends IntegerType<L>> CollectNeighborLabels<L> newInstance(int var1);
    }

    private static interface CollectNeighborLabels<L extends IntegerType<L>> {
        public void collect(RandomAccess<L> var1, TIntArrayList var2, long[] var3, long[] var4);

        public void collectAtPreviousFragmentBorder(RandomAccess<L> var1, TIntArrayList var2, long[] var3, long[] var4);
    }

    private static final class Fragment<T extends IntegerType<T>, L extends IntegerType<L>> {
        private final int n;
        private final TIntArrayList canonicalLabels;
        private final RandomAccessible<T> input;
        private final RandomAccessibleInterval<L> output;
        private final CollectNeighborLabels<L> collectNeighborLabels;
        private int offset;

        public Fragment(RandomAccessible<T> input, RandomAccessibleInterval<L> output, CollectNeighborLabels<L> collectNeighborLabels) {
            this.n = output.numDimensions();
            this.input = input;
            this.output = output;
            this.collectNeighborLabels = collectNeighborLabels;
            this.canonicalLabels = new TIntArrayList(1000);
            this.canonicalLabels.add(0);
        }

        public void mark() {
            long[] min = new long[this.n];
            long[] max = new long[this.n];
            this.output.min(min);
            this.output.max(max);
            TIntArrayList neighborLabels = new TIntArrayList(this.n);
            TIntArrayList updateLabels = new TIntArrayList(10);
            RealCursor in = Views.flatIterable(Views.interval(this.input, this.output)).localizingCursor();
            RandomAccess la = this.output.randomAccess();
            while (in.hasNext()) {
                int i;
                if (((IntegerType)in.next()).getInteger() <= 0) continue;
                la.setPosition((Localizable)((Object)in));
                this.collectNeighborLabels.collect(la, neighborLabels, min, max);
                int numLabeledNeighbors = neighborLabels.size();
                if (numLabeledNeighbors == 0) {
                    int label = this.canonicalLabels.size();
                    this.canonicalLabels.add(label);
                    ((IntegerType)la.get()).setInteger(label);
                    continue;
                }
                if (numLabeledNeighbors == 1) {
                    ((IntegerType)la.get()).setInteger(this.canonicalLabels.get(neighborLabels.get(0)));
                    continue;
                }
                int canonical = this.canonicalLabels.get(neighborLabels.get(0));
                boolean makeCanonical = false;
                for (i = 1; i < neighborLabels.size(); ++i) {
                    if (this.canonicalLabels.get(neighborLabels.get(i)) == canonical) continue;
                    makeCanonical = true;
                    break;
                }
                if (makeCanonical) {
                    updateLabels.clear();
                    canonical = Integer.MAX_VALUE;
                    for (i = 0; i < neighborLabels.size(); ++i) {
                        int label = neighborLabels.get(i);
                        while (this.canonicalLabels.get(label) != label) {
                            updateLabels.add(label);
                            canonical = Math.min(canonical, label);
                            label = this.canonicalLabels.get(label);
                        }
                        updateLabels.add(label);
                        canonical = Math.min(canonical, label);
                    }
                    for (i = 0; i < updateLabels.size(); ++i) {
                        this.canonicalLabels.set(updateLabels.get(i), canonical);
                    }
                }
                ((IntegerType)la.get()).setInteger(canonical);
            }
        }

        public void linkToPreviousFragment(Fragment<T, L> previous, TIntArrayList merged) {
            int previousOffset = previous.offset;
            int splitDim = this.n - 1;
            long[] min = new long[this.n];
            long[] max = new long[this.n];
            this.output.min(min);
            this.output.max(max);
            max[splitDim] = min[splitDim];
            TIntArrayList neighborLabels = new TIntArrayList(this.n);
            TIntArrayList updateLabels = new TIntArrayList(10);
            RealCursor in = Views.iterable(Views.interval(this.output, min, max)).localizingCursor();
            int n = splitDim;
            min[n] = min[n] - 1L;
            RandomAccess la = this.output.randomAccess(new FinalInterval(min, max));
            while (in.hasNext()) {
                int i;
                int label = ((IntegerType)in.next()).getInteger();
                if (label == 0) continue;
                label += this.offset;
                la.setPosition((Localizable)((Object)in));
                this.collectNeighborLabels.collectAtPreviousFragmentBorder(la, neighborLabels, min, max);
                int numLabeledNeighbors = neighborLabels.size();
                if (numLabeledNeighbors == 0) continue;
                for (int i2 = 0; i2 < numLabeledNeighbors; ++i2) {
                    neighborLabels.set(i2, neighborLabels.get(i2) + previousOffset);
                }
                int canonical = merged.get(label);
                boolean makeCanonical = false;
                for (i = 0; i < neighborLabels.size(); ++i) {
                    if (merged.get(neighborLabels.get(i)) == canonical) continue;
                    neighborLabels.add(label);
                    makeCanonical = true;
                    break;
                }
                if (!makeCanonical) continue;
                updateLabels.clear();
                canonical = Integer.MAX_VALUE;
                for (i = 0; i < neighborLabels.size(); ++i) {
                    label = neighborLabels.get(i);
                    while (merged.get(label) != label) {
                        updateLabels.add(label);
                        canonical = Math.min(canonical, label);
                        label = merged.get(label);
                    }
                    updateLabels.add(label);
                    canonical = Math.min(canonical, label);
                }
                for (i = 0; i < updateLabels.size(); ++i) {
                    merged.set(updateLabels.get(i), canonical);
                }
            }
        }

        public void relabel() {
            for (IntegerType label : Views.iterable(this.output)) {
                label.setInteger(this.canonicalLabels.get(label.getInteger()));
            }
        }
    }

    public static enum StructuringElement {
        FOUR_CONNECTED(Collect4NeighborLabels.access$000()),
        EIGHT_CONNECTED(Collect8NeighborLabels.access$100());

        private final CollectNeighborLabelsFactory factory;

        private StructuringElement(CollectNeighborLabelsFactory factory) {
            this.factory = factory;
        }

        public CollectNeighborLabelsFactory getFactory() {
            return this.factory;
        }
    }
}

