/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.linalg.eigen;

import java.util.Optional;
import net.imglib2.algorithm.linalg.eigen.EigenValues;
import net.imglib2.algorithm.linalg.matrix.RealCompositeSquareMatrix;
import net.imglib2.type.numeric.ComplexType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.view.composite.Composite;
import org.ojalgo.matrix.decomposition.Eigenvalue;

public class EigenValuesSquare<T extends RealType<T>, U extends ComplexType<U>>
implements EigenValues<T, U> {
    private final int nDim;
    private final double[] evs;
    private final RealCompositeSquareMatrix<T> m;
    private final Eigenvalue<Double> ed;
    private final Optional<double[]> emptyOptional = Optional.empty();

    public EigenValuesSquare(int nDim) {
        this.nDim = nDim;
        this.evs = new double[nDim];
        this.m = new RealCompositeSquareMatrix(null, nDim);
        this.ed = Eigenvalue.PRIMITIVE.make(this.m, false);
    }

    @Override
    public void compute(Composite<T> tensor, Composite<U> evs) {
        this.m.setData(tensor);
        this.ed.computeValuesOnly(this.m);
        this.ed.getEigenvalues(this.evs, this.emptyOptional);
        for (int d = 0; d < this.evs.length; ++d) {
            ((ComplexType)evs.get(d)).setReal(this.evs[d]);
        }
    }

    @Override
    public EigenValuesSquare<T, U> copy() {
        return new EigenValuesSquare<T, U>(this.nDim);
    }
}

