/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.math;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealCursor;
import net.imglib2.algorithm.Benchmark;
import net.imglib2.algorithm.OutputAlgorithm;
import net.imglib2.img.Img;
import net.imglib2.img.NativeImg;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.type.logic.BitType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.view.Views;

public class PickImagePeaks<T extends RealType<T>>
implements OutputAlgorithm<Img<BitType>>,
Benchmark {
    private final RandomAccessibleInterval<T> image;
    private long pTime;
    private Img<BitType> peakImage;
    private final ArrayList<long[]> peakLocList;
    private final double[] suppressAxis;
    private double suppressSum;
    private boolean allowBorderPeak = false;

    public PickImagePeaks(RandomAccessibleInterval<T> inputImage) {
        this.image = inputImage;
        this.pTime = 0L;
        this.peakLocList = new ArrayList();
        this.peakImage = null;
        this.suppressAxis = new double[inputImage.numDimensions()];
        Arrays.fill(this.suppressAxis, 0.0);
        this.suppressSum = 0.0;
    }

    private void doSuppression() {
        if (this.peakLocList.size() > 0 && this.suppressSum >= 1.0) {
            ArrayList<Peak> suppressionList = new ArrayList<Peak>();
            RandomAccess imCursor = this.image.randomAccess();
            for (long[] pos : this.peakLocList) {
                imCursor.setPosition(pos);
                RealType type = (RealType)((RealType)imCursor.get()).copy();
                suppressionList.add(new Peak(this, pos, type));
            }
            Collections.sort(suppressionList);
            this.peakLocList.clear();
            for (Peak p : suppressionList) {
                boolean isOK = true;
                for (long[] pos : this.peakLocList) {
                    if (!(p.distanceFactor(pos) < 1.0)) continue;
                    isOK = false;
                    break;
                }
                if (!isOK) continue;
                this.peakLocList.add(p.getPosition());
            }
        }
    }

    @Override
    public boolean checkInput() {
        return true;
    }

    @Override
    public String getErrorMessage() {
        return null;
    }

    @Override
    public boolean process() {
        long sTime = System.currentTimeMillis();
        RealCursor cursor = Views.iterable(this.image).localizingCursor();
        RandomAccess localCursor = this.image.randomAccess();
        long[] dimensions = new long[this.image.numDimensions()];
        this.image.dimensions(dimensions);
        long[] pos = new long[dimensions.length];
        long[] checkPos = new long[pos.length];
        ArrayImgFactory<BitType> peakFactory = new ArrayImgFactory<BitType>(new BitType());
        this.peakImage = peakFactory.create(dimensions);
        NativeImg imImage = peakFactory.create(dimensions);
        RealCursor imImagePullCursor = imImage.localizingCursor();
        RandomAccess imImagePushCursor = this.allowBorderPeak ? Views.extendValue(imImage, new BitType(true)).randomAccess() : imImage.randomAccess();
        RandomAccess peakImageCursor = this.peakImage.randomAccess();
        this.peakLocList.clear();
        for (int d = 0; d < pos.length; ++d) {
            cursor.reset();
            while (cursor.hasNext()) {
                cursor.fwd();
                cursor.localize(pos);
                imImagePushCursor.setPosition(pos);
                System.arraycopy(pos, 0, checkPos, 0, pos.length);
                int n = d;
                checkPos[n] = checkPos[n] - 1L;
                if (checkPos[d] < 0L) {
                    ((BitType)imImagePushCursor.get()).set(false);
                    continue;
                }
                localCursor.setPosition(checkPos);
                RealType t0 = (RealType)cursor.get();
                RealType tc = (RealType)localCursor.get();
                ((BitType)imImagePushCursor.get()).set(tc.compareTo(t0) >= 0);
            }
            imImagePullCursor.reset();
            while (imImagePullCursor.hasNext()) {
                imImagePullCursor.fwd();
                imImagePullCursor.localize(pos);
                peakImageCursor.setPosition(pos);
                System.arraycopy(pos, 0, checkPos, 0, pos.length);
                int n = d;
                checkPos[n] = checkPos[n] + 1L;
                if (!this.allowBorderPeak && checkPos[d] >= dimensions[d]) {
                    ((BitType)peakImageCursor.get()).set(false);
                    continue;
                }
                if (d != 0 && !((BitType)peakImageCursor.get()).get()) continue;
                imImagePushCursor.setPosition(checkPos);
                ((BitType)peakImageCursor.get()).set(!((BitType)imImagePullCursor.get()).get() && ((BitType)imImagePushCursor.get()).get());
            }
        }
        this.pTime = System.currentTimeMillis() - sTime;
        return true;
    }

    @Override
    public long getProcessingTime() {
        return this.pTime;
    }

    @Override
    public Img<BitType> getResult() {
        return this.peakImage;
    }

    public ArrayList<long[]> getPeakList() {
        if (this.peakLocList.isEmpty() && this.peakImage != null) {
            RealCursor pkCursor = this.peakImage.localizingCursor();
            this.peakLocList.clear();
            while (pkCursor.hasNext()) {
                pkCursor.fwd();
                if (!((BitType)pkCursor.get()).get()) continue;
                long[] pos = new long[this.image.numDimensions()];
                pkCursor.localize(pos);
                this.peakLocList.add(pos);
            }
            this.doSuppression();
        }
        return this.peakLocList;
    }

    public void setSuppression(double r) {
        Arrays.fill(this.suppressAxis, r);
        this.suppressSum = (double)this.suppressAxis.length * r;
    }

    public void setAllowBorderPeak(boolean allowBorderPeak) {
        this.allowBorderPeak = allowBorderPeak;
    }

    public void setSuppression(double[] r) {
        System.arraycopy(r, 0, this.suppressAxis, 0, this.suppressAxis.length);
        this.suppressSum = 0.0;
        for (double a : r) {
            this.suppressSum += a;
        }
    }

    private static class Peak
    implements Comparable<Peak> {
        private final T peakVal;
        private final long[] pos;
        final /* synthetic */ PickImagePeaks this$0;

        public Peak(long[] inPos, T val) {
            this.this$0 = var1_1;
            this.peakVal = val;
            this.pos = inPos;
        }

        @Override
        public int compareTo(Peak inPeak) {
            if (this.peakVal.compareTo(inPeak.peakVal) == 1) {
                return -1;
            }
            if (this.peakVal.compareTo(inPeak.peakVal) == 0) {
                return 0;
            }
            return 1;
        }

        public long[] getPosition() {
            return this.pos;
        }

        public double distanceFactor(long[] inPos) {
            double val2 = 0.0;
            for (int i = 0; i < this.pos.length; ++i) {
                double val = (double)(this.pos[i] - inPos[i]) / this.this$0.suppressAxis[i];
                val2 += val * val;
            }
            return Math.sqrt(val2);
        }
    }
}

