/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.morphology.distance;

import java.util.Arrays;
import java.util.stream.DoubleStream;
import net.imglib2.algorithm.morphology.distance.Distance;

public class EuclidianDistanceAnisotropic
implements Distance {
    private final double[] weights;
    private final double[] oneOverTwoTimesWeights;

    public EuclidianDistanceAnisotropic(double ... weights) {
        this.weights = weights;
        this.oneOverTwoTimesWeights = Arrays.stream(weights).map(w -> 0.5 / w).toArray();
    }

    public EuclidianDistanceAnisotropic(int nDim, double weight) {
        this(DoubleStream.generate(() -> weight).limit(nDim).toArray());
    }

    @Override
    public double evaluate(double x, double xShift, double yShift, int dim) {
        double diff = x - xShift;
        return this.weights[dim] * diff * diff + yShift;
    }

    @Override
    public double intersect(double xShift1, double yShift1, double xShift2, double yShift2, int dim) {
        double a = this.weights[dim];
        return this.oneOverTwoTimesWeights[dim] * (a * xShift2 * xShift2 + yShift2 - (a * xShift1 * xShift1 + yShift1)) / (xShift2 - xShift1);
    }
}

