/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.neighborhood;

import java.util.Arrays;
import java.util.Iterator;
import net.imglib2.AbstractEuclideanSpace;
import net.imglib2.AbstractInterval;
import net.imglib2.Cursor;
import net.imglib2.FinalInterval;
import net.imglib2.FlatIterationOrder;
import net.imglib2.Interval;
import net.imglib2.IterableInterval;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.neighborhood.Neighborhood;
import net.imglib2.algorithm.neighborhood.PairOfPointsNeighborhood;
import net.imglib2.algorithm.neighborhood.PairOfPointsNeighborhoodCursor;
import net.imglib2.algorithm.neighborhood.PairOfPointsNeighborhoodFactory;
import net.imglib2.algorithm.neighborhood.PairOfPointsNeighborhoodRandomAccess;
import net.imglib2.algorithm.neighborhood.PairOfPointsNeighborhoodUnsafe;
import net.imglib2.algorithm.neighborhood.Shape;
import net.imglib2.util.Intervals;
import net.imglib2.util.Util;

public class PairOfPointsShape
implements Shape {
    private final long[] offset;

    public PairOfPointsShape(long[] offset) {
        this.offset = offset;
    }

    public <T> NeighborhoodsIterableInterval<T> neighborhoods(RandomAccessibleInterval<T> source) {
        PairOfPointsNeighborhoodFactory f = PairOfPointsNeighborhoodUnsafe.factory();
        return new NeighborhoodsIterableInterval<T>(source, this.offset, f);
    }

    public <T> NeighborhoodsAccessible<T> neighborhoodsRandomAccessible(RandomAccessible<T> source) {
        PairOfPointsNeighborhoodFactory f = PairOfPointsNeighborhoodUnsafe.factory();
        return new NeighborhoodsAccessible<T>(source, this.offset, f);
    }

    @Override
    public <T> IterableInterval<Neighborhood<T>> neighborhoodsSafe(RandomAccessibleInterval<T> source) {
        PairOfPointsNeighborhoodFactory f = PairOfPointsNeighborhood.factory();
        return new NeighborhoodsIterableInterval<T>(source, this.offset, f);
    }

    public <T> NeighborhoodsAccessible<T> neighborhoodsRandomAccessibleSafe(RandomAccessible<T> source) {
        PairOfPointsNeighborhoodFactory f = PairOfPointsNeighborhood.factory();
        return new NeighborhoodsAccessible<T>(source, this.offset, f);
    }

    public long[] getOffset() {
        return (long[])this.offset.clone();
    }

    public String toString() {
        return "PairOfPointsShape, offset = " + Util.printCoordinates(this.offset);
    }

    @Override
    public Interval getStructuringElementBoundingBox(int numDimensions) {
        long[] zeroMin = new long[numDimensions];
        Arrays.fill(zeroMin, 0L);
        return Intervals.union(new FinalInterval(zeroMin, zeroMin), new FinalInterval(this.offset, this.offset));
    }

    public static final class NeighborhoodsAccessible<T>
    extends AbstractEuclideanSpace
    implements RandomAccessible<Neighborhood<T>> {
        final RandomAccessible<T> source;
        final PairOfPointsNeighborhoodFactory<T> factory;
        private final long[] offset;

        public NeighborhoodsAccessible(RandomAccessible<T> source, long[] offset, PairOfPointsNeighborhoodFactory<T> factory) {
            super(source.numDimensions());
            this.source = source;
            this.offset = offset;
            this.factory = factory;
        }

        @Override
        public RandomAccess<Neighborhood<T>> randomAccess() {
            return new PairOfPointsNeighborhoodRandomAccess<T>(this.source, this.offset, this.factory);
        }

        @Override
        public RandomAccess<Neighborhood<T>> randomAccess(Interval interval) {
            return this.randomAccess();
        }

        @Override
        public int numDimensions() {
            return this.source.numDimensions();
        }
    }

    public static final class NeighborhoodsIterableInterval<T>
    extends AbstractInterval
    implements IterableInterval<Neighborhood<T>> {
        final RandomAccessibleInterval<T> source;
        final PairOfPointsNeighborhoodFactory<T> factory;
        final long[] offset;

        public NeighborhoodsIterableInterval(RandomAccessibleInterval<T> source, long[] offset, PairOfPointsNeighborhoodFactory<T> factory) {
            super(source);
            this.source = source;
            this.offset = offset;
            this.factory = factory;
        }

        @Override
        public Cursor<Neighborhood<T>> cursor() {
            return new PairOfPointsNeighborhoodCursor<T>(this.source, this.offset, this.factory);
        }

        @Override
        public long size() {
            return 2L;
        }

        @Override
        public Neighborhood<T> firstElement() {
            return (Neighborhood)this.cursor().next();
        }

        @Override
        public Object iterationOrder() {
            return new FlatIterationOrder(this);
        }

        @Override
        public Iterator<Neighborhood<T>> iterator() {
            return this.cursor();
        }

        @Override
        public Cursor<Neighborhood<T>> localizingCursor() {
            return this.cursor();
        }
    }
}

