/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.neighborhood;

import net.imglib2.Interval;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.algorithm.neighborhood.Neighborhood;
import net.imglib2.algorithm.neighborhood.PeriodicLineNeighborhoodFactory;
import net.imglib2.algorithm.neighborhood.PeriodicLineNeighborhoodLocalizableSampler;

public class PeriodicLineNeighborhoodRandomAccess<T>
extends PeriodicLineNeighborhoodLocalizableSampler<T>
implements RandomAccess<Neighborhood<T>> {
    public PeriodicLineNeighborhoodRandomAccess(RandomAccessible<T> source, long span, int[] increments, PeriodicLineNeighborhoodFactory<T> factory, Interval interval) {
        super(source, span, increments, factory, interval);
    }

    public PeriodicLineNeighborhoodRandomAccess(RandomAccessible<T> source, long span, int[] increments, PeriodicLineNeighborhoodFactory<T> factory) {
        super(source, span, increments, factory, null);
    }

    private PeriodicLineNeighborhoodRandomAccess(PeriodicLineNeighborhoodRandomAccess<T> c) {
        super(c);
    }

    @Override
    public void fwd(int d) {
        int n = d;
        this.currentPos[n] = this.currentPos[n] + 1L;
    }

    @Override
    public void bck(int d) {
        int n = d;
        this.currentPos[n] = this.currentPos[n] - 1L;
    }

    @Override
    public void move(int distance, int d) {
        int n = d;
        this.currentPos[n] = this.currentPos[n] + (long)distance;
    }

    @Override
    public void move(long distance, int d) {
        int n = d;
        this.currentPos[n] = this.currentPos[n] + distance;
    }

    @Override
    public void move(Localizable localizable) {
        int d = 0;
        while (d < this.n) {
            long distance = localizable.getLongPosition(d);
            int n = d++;
            this.currentPos[n] = this.currentPos[n] + distance;
        }
    }

    @Override
    public void move(int[] distance) {
        for (int d = 0; d < this.n; ++d) {
            int n = d;
            this.currentPos[n] = this.currentPos[n] + (long)distance[d];
        }
    }

    @Override
    public void move(long[] distance) {
        for (int d = 0; d < this.n; ++d) {
            int n = d;
            this.currentPos[n] = this.currentPos[n] + distance[d];
        }
    }

    @Override
    public void setPosition(Localizable localizable) {
        for (int d = 0; d < this.n; ++d) {
            long position;
            this.currentPos[d] = position = localizable.getLongPosition(d);
        }
    }

    @Override
    public void setPosition(int[] position) {
        for (int d = 0; d < this.n; ++d) {
            this.currentPos[d] = position[d];
        }
    }

    @Override
    public void setPosition(long[] position) {
        for (int d = 0; d < this.n; ++d) {
            this.currentPos[d] = position[d];
        }
    }

    @Override
    public void setPosition(int position, int d) {
        this.currentPos[d] = position;
    }

    @Override
    public void setPosition(long position, int d) {
        this.currentPos[d] = position;
    }

    @Override
    public PeriodicLineNeighborhoodRandomAccess<T> copy() {
        return new PeriodicLineNeighborhoodRandomAccess<T>(this);
    }

    @Override
    public PeriodicLineNeighborhoodRandomAccess<T> copyRandomAccess() {
        return this.copy();
    }
}

