/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.pde;

import java.util.Vector;
import mpicbg.util.Util;
import net.imglib2.RandomAccess;
import net.imglib2.RealCursor;
import net.imglib2.algorithm.MultiThreadedBenchmarkAlgorithm;
import net.imglib2.algorithm.OutputAlgorithm;
import net.imglib2.algorithm.gauss.Gauss;
import net.imglib2.algorithm.pde.Gradient;
import net.imglib2.exception.IncompatibleTypeException;
import net.imglib2.img.Img;
import net.imglib2.multithreading.Chunk;
import net.imglib2.multithreading.SimpleMultiThreading;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.FloatType;

public class CoherenceEnhancingDiffusionTensor2D<T extends RealType<T>>
extends MultiThreadedBenchmarkAlgorithm
implements OutputAlgorithm<Img<FloatType>> {
    private static final String BASE_ERROR_MESSAGE = "[" + CoherenceEnhancingDiffusionTensor2D.class.getSimpleName() + "] ";
    private final Img<T> input;
    private Img<FloatType> D;
    private final double sigma = 2.0;
    private final double rho = 4.0;
    private final double alpha = 0.001;
    private final double C = 1.0;
    private final int m = 1;

    public CoherenceEnhancingDiffusionTensor2D(Img<T> input) {
        this.input = input;
    }

    @Override
    public Img<FloatType> getResult() {
        return this.D;
    }

    @Override
    public boolean process() {
        Chunk chunk;
        int i;
        long[] tensorDims = new long[this.input.numDimensions() + 1];
        for (int i2 = 0; i2 < this.input.numDimensions(); ++i2) {
            tensorDims[i2] = this.input.dimension(i2);
        }
        tensorDims[this.input.numDimensions()] = 3L;
        try {
            this.D = this.input.factory().imgFactory(new FloatType()).create(tensorDims);
        }
        catch (IncompatibleTypeException e) {
            this.errorMessage = BASE_ERROR_MESSAGE + "Failed to create tensor holder:\n" + e.getMessage();
            return false;
        }
        Img<FloatType> smoothed = Gauss.toFloat(new double[]{2.0, 2.0}, this.input);
        boolean[] doDimension = new boolean[this.input.numDimensions()];
        doDimension[0] = true;
        doDimension[1] = true;
        Gradient<FloatType> gradientCalculator = new Gradient<FloatType>(smoothed, doDimension);
        gradientCalculator.process();
        Object gradient = gradientCalculator.getResult();
        final Img<FloatType> J = this.D.factory().create(this.D);
        final int newDim = this.input.numDimensions();
        Vector<Chunk> chunks = SimpleMultiThreading.divideIntoChunks(this.input.size(), this.numThreads);
        Thread[] threads = SimpleMultiThreading.newThreads(this.numThreads);
        for (i = 0; i < threads.length; ++i) {
            chunk = chunks.get(i);
            threads[i] = new Thread("" + BASE_ERROR_MESSAGE + "thread " + i, (Img)gradient, J, chunk, newDim){
                final /* synthetic */ Img val$gradient;
                final /* synthetic */ Img val$J;
                final /* synthetic */ Chunk val$chunk;
                final /* synthetic */ int val$newDim;
                {
                    this.val$gradient = img;
                    this.val$J = img2;
                    this.val$chunk = chunk;
                    this.val$newDim = n;
                    super(x0);
                }

                @Override
                public void run() {
                    RealCursor cursor = CoherenceEnhancingDiffusionTensor2D.this.input.localizingCursor();
                    RandomAccess grad_ra = this.val$gradient.randomAccess();
                    RandomAccess J_ra = this.val$J.randomAccess();
                    cursor.jumpFwd(this.val$chunk.getStartPosition());
                    for (long k = 0L; k < this.val$chunk.getLoopSize(); ++k) {
                        cursor.fwd();
                        for (int i = 0; i < CoherenceEnhancingDiffusionTensor2D.this.input.numDimensions(); ++i) {
                            grad_ra.setPosition(cursor.getLongPosition(i), i);
                            J_ra.setPosition(cursor.getLongPosition(i), i);
                        }
                        grad_ra.setPosition(0, this.val$newDim);
                        float ux = ((FloatType)grad_ra.get()).get();
                        grad_ra.fwd(this.val$newDim);
                        float uy = ((FloatType)grad_ra.get()).get();
                        J_ra.setPosition(0, this.val$newDim);
                        ((FloatType)J_ra.get()).set(ux * ux);
                        J_ra.fwd(this.val$newDim);
                        ((FloatType)J_ra.get()).set(ux * uy);
                        J_ra.fwd(this.val$newDim);
                        ((FloatType)J_ra.get()).set(uy * uy);
                    }
                }
            };
        }
        SimpleMultiThreading.startAndJoin(threads);
        Gauss.inFloat(new double[]{4.0, 4.0, 0.0}, J);
        for (i = 0; i < threads.length; ++i) {
            chunk = chunks.get(i);
            threads[i] = new Thread("" + BASE_ERROR_MESSAGE + "thread " + i){

                @Override
                public void run() {
                    RealCursor cursor = CoherenceEnhancingDiffusionTensor2D.this.input.localizingCursor();
                    RandomAccess J_ra = J.randomAccess();
                    RandomAccess D_ra = CoherenceEnhancingDiffusionTensor2D.this.D.randomAccess();
                    cursor.jumpFwd(chunk.getStartPosition());
                    for (long k = 0L; k < chunk.getLoopSize(); ++k) {
                        double lambda2;
                        double lambda1;
                        cursor.fwd();
                        for (int j = 0; j < CoherenceEnhancingDiffusionTensor2D.this.input.numDimensions(); ++j) {
                            D_ra.setPosition(cursor.getLongPosition(j), j);
                            J_ra.setPosition(cursor.getLongPosition(j), j);
                        }
                        J_ra.setPosition(0, newDim);
                        float Jxx = ((FloatType)J_ra.get()).get();
                        J_ra.fwd(newDim);
                        float Jxy = ((FloatType)J_ra.get()).get();
                        J_ra.fwd(newDim);
                        float Jyy = ((FloatType)J_ra.get()).get();
                        double tmp = Math.sqrt((Jxx - Jyy) * (Jxx - Jyy) + 4.0f * Jxy * Jxy);
                        double v2x = 2.0f * Jxy;
                        double v2y = (double)(Jyy - Jxx) + tmp;
                        double mag = Math.sqrt(v2x * v2x + v2y * v2y);
                        double v1x = -(v2y /= mag);
                        double v1y = v2x /= mag;
                        double mu1 = 0.5 * ((double)(Jxx + Jyy) + tmp);
                        double mu2 = 0.5 * ((double)(Jxx + Jyy) - tmp);
                        if (Math.abs(mu2) > Math.abs(mu1)) {
                            lambda1 = mu1;
                            lambda2 = mu2;
                        } else {
                            lambda1 = mu2;
                            lambda2 = mu1;
                        }
                        double di = lambda2 - lambda1;
                        double scale = Util.pow((double)(di * di), (int)1);
                        double newLambda1 = 0.001 + 0.999 * Math.exp(-1.0 / scale);
                        double newLambda2 = 0.001;
                        double Dxx = newLambda1 * v1x * v1x + newLambda2 * v2x * v2x;
                        double Dxy = newLambda1 * v1x * v1y + newLambda2 * v2x * v2x;
                        double Dyy = newLambda1 * v1y * v1y + newLambda2 * v2y * v2y;
                        D_ra.setPosition(0, 2);
                        ((FloatType)D_ra.get()).setReal(Dxx);
                        D_ra.fwd(2);
                        ((FloatType)D_ra.get()).setReal(Dxy);
                        D_ra.fwd(2);
                        ((FloatType)D_ra.get()).setReal(Dyy);
                    }
                }
            };
        }
        SimpleMultiThreading.startAndJoin(threads);
        return true;
    }

    @Override
    public boolean checkInput() {
        return true;
    }
}

