/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.pde;

import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealCursor;
import net.imglib2.algorithm.MultiThreadedBenchmarkAlgorithm;
import net.imglib2.algorithm.OutputAlgorithm;
import net.imglib2.img.Img;
import net.imglib2.img.ImgFactory;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.util.Util;
import net.imglib2.view.Views;

public class Gradient<T extends RealType<T>>
extends MultiThreadedBenchmarkAlgorithm
implements OutputAlgorithm<Img<FloatType>> {
    private final RandomAccessibleInterval<T> input;
    private Img<FloatType> output;
    private final boolean[] doDimension;

    @Deprecated
    public Gradient(Img<T> input, boolean[] doDimension) {
        this(input, Util.getSuitableImgFactory(input, new FloatType()), doDimension);
    }

    public Gradient(RandomAccessibleInterval<T> input, ImgFactory<FloatType> imgFactory, boolean[] doDimension) {
        this.input = input;
        this.doDimension = doDimension;
        long[] dimensions = new long[input.numDimensions() + 1];
        for (int i = 0; i < dimensions.length - 1; ++i) {
            dimensions[i] = input.dimension(i);
        }
        dimensions[dimensions.length - 1] = input.numDimensions();
        this.output = imgFactory.create(dimensions);
    }

    @Override
    public boolean checkInput() {
        return true;
    }

    @Override
    public boolean process() {
        long start = System.currentTimeMillis();
        RealCursor in = Views.iterable(this.input).localizingCursor();
        RandomAccess oc = this.output.randomAccess();
        RealType zero = (RealType)((RealType)Views.iterable(this.input).firstElement()).createVariable();
        RandomAccess ra = Views.extendValue(this.input, zero).randomAccess();
        int newdim = this.input.numDimensions();
        while (in.hasNext()) {
            int i;
            in.fwd();
            ra.setPosition((Localizable)((Object)in));
            for (i = 0; i < this.input.numDimensions(); ++i) {
                oc.setPosition(in.getLongPosition(i), i);
            }
            oc.setPosition(0, newdim);
            float central = ((RealType)in.get()).getRealFloat();
            for (i = 0; i < this.input.numDimensions(); ++i) {
                if (!this.doDimension[i]) continue;
                ra.fwd(i);
                float diff = central - ((RealType)ra.get()).getRealFloat();
                ra.bck(i);
                ((FloatType)oc.get()).set(diff);
                oc.fwd(newdim);
            }
        }
        this.processingTime = System.currentTimeMillis() - start;
        return true;
    }

    @Override
    public Img<FloatType> getResult() {
        return this.output;
    }
}

