/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.region;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import net.imglib2.Cursor;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;

public class BresenhamLine<T>
implements Cursor<T> {
    private Localizable P1;
    private Localizable P2;
    private Iterator<long[]> iterator;
    private long[] current;
    private final RandomAccess<T> ra;

    public BresenhamLine(RandomAccessible<T> source) {
        this.ra = source.randomAccess();
    }

    public BresenhamLine(RandomAccessible<T> source, Localizable P1, Localizable P2) {
        this(source.randomAccess(), P1, P2);
    }

    public BresenhamLine(RandomAccess<T> ra, Localizable P1, Localizable P2) {
        this.ra = ra;
        this.P1 = P1;
        this.P2 = P2;
        this.reset(P1, P2);
    }

    public void reset(Localizable P1, Localizable P2) {
        this.iterator = BresenhamLine.generateCoords(P1, P2).iterator();
    }

    @Override
    public T get() {
        return this.ra.get();
    }

    @Override
    public void fwd() {
        this.current = this.iterator.next();
        this.ra.setPosition(this.current);
    }

    @Override
    public void reset() {
        this.reset(this.P1, this.P2);
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public void localize(long[] position) {
        for (int d = 0; d < this.current.length; ++d) {
            position[d] = this.current[d];
        }
    }

    @Override
    public long getLongPosition(int d) {
        return this.current[d];
    }

    @Override
    public BresenhamLine<T> copy() {
        return new BresenhamLine<T>(this.ra, this.P1, this.P2);
    }

    @Override
    public BresenhamLine<T> copyCursor() {
        return this.copy();
    }

    @Override
    public void localize(float[] position) {
        for (int d = 0; d < this.current.length; ++d) {
            position[d] = this.current[d];
        }
    }

    @Override
    public void localize(double[] position) {
        for (int d = 0; d < this.current.length; ++d) {
            position[d] = this.current[d];
        }
    }

    @Override
    public float getFloatPosition(int d) {
        return this.current[d];
    }

    @Override
    public double getDoublePosition(int d) {
        return this.current[d];
    }

    @Override
    public int numDimensions() {
        return this.current.length;
    }

    @Override
    public void jumpFwd(long steps) {
        int i = 0;
        while ((long)i < steps) {
            this.current = this.iterator.next();
            ++i;
        }
        this.ra.setPosition(this.current);
    }

    @Override
    public T next() {
        this.fwd();
        return this.get();
    }

    @Override
    public void remove() {
    }

    @Override
    public void localize(int[] position) {
        for (int d = 0; d < this.current.length; ++d) {
            position[d] = (int)this.current[d];
        }
    }

    @Override
    public int getIntPosition(int d) {
        return (int)this.current[d];
    }

    public static final ArrayList<long[]> generateCoords(Localizable start, Localizable end) {
        int nd = start.numDimensions();
        long[] dxs = new long[nd];
        long[] as = new long[nd];
        float[] signs = new float[nd];
        for (int d = 0; d < nd; ++d) {
            dxs[d] = end.getLongPosition(d) - start.getLongPosition(d);
            as[d] = Math.abs(dxs[d]) << 1;
            signs[d] = Math.signum(dxs[d]);
        }
        int dm = -1;
        long am = -1L;
        long maxDelta = -1L;
        for (int d = 0; d < nd; ++d) {
            if (as[d] >= am) {
                dm = d;
                am = as[d];
            }
            if (Math.abs(dxs[d]) <= maxDelta) continue;
            maxDelta = Math.abs(dxs[d]);
        }
        long[] xd = new long[nd];
        for (int d = 0; d < nd; ++d) {
            xd[d] = as[d] - (as[dm] >> 1);
        }
        long[] x = new long[nd];
        start.localize(x);
        ArrayList<long[]> coords = new ArrayList<long[]>((int)maxDelta);
        block3: while (true) {
            int d;
            coords.add(x);
            x = Arrays.copyOf(x, x.length);
            if (x[dm] == end.getLongPosition(dm)) {
                return coords;
            }
            for (d = 0; d < nd; ++d) {
                if (d == dm || xd[d] < 0L) continue;
                int n = d;
                x[n] = (long)((float)x[n] + signs[d]);
                int n2 = d;
                xd[n2] = xd[n2] - as[dm];
            }
            int n = dm;
            x[n] = (long)((float)x[n] + signs[dm]);
            d = 0;
            while (true) {
                if (d >= nd) continue block3;
                if (d != dm) {
                    int n3 = d;
                    xd[n3] = xd[n3] + as[d];
                }
                ++d;
            }
            break;
        }
    }
}

