/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.region.localneighborhood;

import java.util.Iterator;
import net.imglib2.Cursor;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.region.localneighborhood.AbstractNeighborhood;
import net.imglib2.algorithm.region.localneighborhood.BufferedRectangularNeighborhoodCursor;
import net.imglib2.outofbounds.OutOfBoundsFactory;
import net.imglib2.type.Type;

public class BufferedRectangularNeighborhood<T extends Type<T>>
extends AbstractNeighborhood<T> {
    private int size;

    public BufferedRectangularNeighborhood(RandomAccessibleInterval<T> source, OutOfBoundsFactory<T, RandomAccessibleInterval<T>> outOfBounds, long[] spans) {
        this(source.numDimensions(), outOfBounds, spans);
        this.updateSource(source);
    }

    public BufferedRectangularNeighborhood(int numDims, OutOfBoundsFactory<T, RandomAccessibleInterval<T>> outOfBounds, long[] spans) {
        super(numDims, outOfBounds);
        this.setSpan(spans);
        this.size = 1;
        for (long s : spans) {
            this.size = (int)((long)this.size * s);
        }
    }

    @Override
    public Cursor<T> cursor() {
        return new BufferedRectangularNeighborhoodCursor(this);
    }

    @Override
    public Cursor<T> localizingCursor() {
        return this.cursor();
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public Iterator<T> iterator() {
        return this.cursor();
    }

    @Override
    public BufferedRectangularNeighborhood<T> copy() {
        if (this.source != null) {
            return new BufferedRectangularNeighborhood<T>(this.source, this.outOfBounds, this.span);
        }
        return new BufferedRectangularNeighborhood<T>(this.n, this.outOfBounds, this.span);
    }
}

