/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.region.localneighborhood;

import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.region.localneighborhood.AbstractNeighborhood;
import net.imglib2.algorithm.region.localneighborhood.EllipsoidCursor;
import net.imglib2.algorithm.region.localneighborhood.Utils;
import net.imglib2.outofbounds.OutOfBoundsFactory;
import net.imglib2.outofbounds.OutOfBoundsPeriodicFactory;

public class EllipsoidNeighborhood<T>
extends AbstractNeighborhood<T> {
    public EllipsoidNeighborhood(RandomAccessibleInterval<T> source, long[] center, long[] radiuses, OutOfBoundsFactory<T, RandomAccessibleInterval<T>> outOfBounds) {
        super(source.numDimensions(), outOfBounds);
        if (this.numDimensions() < 2) {
            throw new IllegalArgumentException("[EllipsoidNeighborhood] source must be at least of dimension 3.");
        }
        this.setSpan(radiuses);
        this.setPosition(center);
        this.updateSource(source);
    }

    public EllipsoidNeighborhood(RandomAccessibleInterval<T> source, long[] center, long[] radiuses) {
        this(source, center, radiuses, new OutOfBoundsPeriodicFactory());
    }

    @Override
    public long size() {
        int largeAxisDim;
        int smallAxisdim;
        long pixel_count = 0L;
        long nzplanes = this.span[2];
        if (this.span[1] < this.span[0]) {
            smallAxisdim = 1;
            largeAxisDim = 0;
        } else {
            smallAxisdim = 0;
            largeAxisDim = 1;
        }
        int[] local_rys = new int[(int)(nzplanes + 1L)];
        int[] local_rxs = new int[(int)(this.span[largeAxisDim] + 1L)];
        Utils.getXYEllipseBounds((int)this.span[largeAxisDim], (int)this.span[2], local_rys);
        Utils.getXYEllipseBounds((int)this.span[smallAxisdim], (int)this.span[largeAxisDim], local_rxs);
        int local_ry = local_rys[0];
        int local_rx = local_rxs[0];
        pixel_count += (long)(2 * local_rx + 1);
        for (int i = 1; i <= local_ry; ++i) {
            local_rx = local_rxs[i];
            pixel_count += (long)(2 * (2 * local_rx + 1));
        }
        int j = 1;
        while ((long)j <= nzplanes) {
            local_ry = local_rys[j];
            if (local_ry != 0) {
                Utils.getXYEllipseBounds(Math.round((float)local_ry * (float)this.span[smallAxisdim] / (float)this.span[largeAxisDim]), local_ry, local_rxs);
                local_rx = local_rxs[0];
                pixel_count += (long)(2 * (2 * local_rx + 1));
                for (int i = 1; i <= local_ry; ++i) {
                    local_rx = local_rxs[i];
                    pixel_count += (long)(4 * (2 * local_rx + 1));
                }
            }
            ++j;
        }
        return pixel_count;
    }

    @Override
    public EllipsoidCursor<T> cursor() {
        return new EllipsoidCursor(this);
    }

    @Override
    public EllipsoidCursor<T> localizingCursor() {
        return this.cursor();
    }

    @Override
    public EllipsoidCursor<T> iterator() {
        return this.cursor();
    }

    @Override
    public EllipsoidNeighborhood<T> copy() {
        return new EllipsoidNeighborhood<T>(this.source, this.center, this.span, this.outOfBounds);
    }
}

