/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.cache.img;

import java.util.Arrays;
import java.util.Set;
import java.util.function.Function;
import net.imglib2.Cursor;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.cache.CacheLoader;
import net.imglib2.img.AbstractNativeImg;
import net.imglib2.img.Img;
import net.imglib2.img.ImgFactory;
import net.imglib2.img.basictypeaccess.AccessFlags;
import net.imglib2.img.basictypeaccess.array.ArrayDataAccess;
import net.imglib2.img.basictypeaccess.array.ByteArray;
import net.imglib2.img.basictypeaccess.array.CharArray;
import net.imglib2.img.basictypeaccess.array.DirtyByteArray;
import net.imglib2.img.basictypeaccess.array.DirtyCharArray;
import net.imglib2.img.basictypeaccess.array.DirtyDoubleArray;
import net.imglib2.img.basictypeaccess.array.DirtyFloatArray;
import net.imglib2.img.basictypeaccess.array.DirtyIntArray;
import net.imglib2.img.basictypeaccess.array.DirtyLongArray;
import net.imglib2.img.basictypeaccess.array.DirtyShortArray;
import net.imglib2.img.basictypeaccess.array.DoubleArray;
import net.imglib2.img.basictypeaccess.array.FloatArray;
import net.imglib2.img.basictypeaccess.array.IntArray;
import net.imglib2.img.basictypeaccess.array.LongArray;
import net.imglib2.img.basictypeaccess.array.ShortArray;
import net.imglib2.img.basictypeaccess.volatiles.array.DirtyVolatileByteArray;
import net.imglib2.img.basictypeaccess.volatiles.array.DirtyVolatileCharArray;
import net.imglib2.img.basictypeaccess.volatiles.array.DirtyVolatileDoubleArray;
import net.imglib2.img.basictypeaccess.volatiles.array.DirtyVolatileFloatArray;
import net.imglib2.img.basictypeaccess.volatiles.array.DirtyVolatileIntArray;
import net.imglib2.img.basictypeaccess.volatiles.array.DirtyVolatileLongArray;
import net.imglib2.img.basictypeaccess.volatiles.array.DirtyVolatileShortArray;
import net.imglib2.img.basictypeaccess.volatiles.array.VolatileByteArray;
import net.imglib2.img.basictypeaccess.volatiles.array.VolatileCharArray;
import net.imglib2.img.basictypeaccess.volatiles.array.VolatileDoubleArray;
import net.imglib2.img.basictypeaccess.volatiles.array.VolatileFloatArray;
import net.imglib2.img.basictypeaccess.volatiles.array.VolatileIntArray;
import net.imglib2.img.basictypeaccess.volatiles.array.VolatileLongArray;
import net.imglib2.img.basictypeaccess.volatiles.array.VolatileShortArray;
import net.imglib2.img.cell.Cell;
import net.imglib2.img.cell.CellGrid;
import net.imglib2.type.NativeType;
import net.imglib2.type.PrimitiveType;
import net.imglib2.util.Fraction;
import net.imglib2.view.Views;

public class RandomAccessibleCacheLoader<T extends NativeType<T>, A extends ArrayDataAccess<A>, CA extends ArrayDataAccess<CA>>
implements CacheLoader<Long, Cell<CA>> {
    private final CellGrid grid;
    private final RandomAccessible<T> source;
    private final T type;
    private final A creator;
    private final Fraction entitiesPerPixel;
    private final Function<A, CA> rewrap;

    public RandomAccessibleCacheLoader(CellGrid grid, RandomAccessible<T> source, T type, A creator, Function<A, CA> rewrap) {
        this.grid = grid;
        this.source = source;
        this.type = type;
        this.creator = creator;
        this.rewrap = rewrap;
        this.entitiesPerPixel = type.getEntitiesPerPixel();
    }

    @Override
    public Cell<CA> get(Long key) throws Exception {
        long index = key;
        int n = this.grid.numDimensions();
        long[] cellMin = new long[n];
        long[] cellMax = new long[n];
        CellGrid.CellDimensionsAndSteps dimsAndSteps = this.grid.getCellDimensions(index, cellMin);
        Arrays.setAll(cellMax, d -> cellMin[d] + (long)dimsAndSteps.dimensions()[d] - 1L);
        long numEntities = this.entitiesPerPixel.mulCeil(dimsAndSteps.numPixels());
        ArrayDataAccess data = (ArrayDataAccess)this.creator.createArray((int)numEntities);
        NativeType t = this.createType(data);
        t.updateIndex(0);
        for (NativeType s : Views.interval(this.source, cellMin, cellMax)) {
            t.set((NativeType)s);
            t.incIndex();
        }
        return new Cell<CA>(dimsAndSteps, cellMin, this.rewrap.apply(data));
    }

    public static <T extends NativeType<T>, A extends ArrayDataAccess<A>, CA extends ArrayDataAccess<CA>> RandomAccessibleCacheLoader<T, A, CA> get(CellGrid grid, RandomAccessible<T> source, Set<AccessFlags> flags) {
        return RandomAccessibleCacheLoader.get(grid, source, (NativeType)source.randomAccess().get(), flags);
    }

    public static <T extends NativeType<T>, A extends ArrayDataAccess<A>, CA extends ArrayDataAccess<CA>> RandomAccessibleCacheLoader<T, A, CA> get(CellGrid grid, RandomAccessible<T> source, T type, Set<AccessFlags> flags) {
        PrimitiveType primitiveType = type.getNativeTypeFactory().getPrimitiveType();
        boolean dirty = flags.contains((Object)AccessFlags.DIRTY);
        boolean volatil = flags.contains((Object)AccessFlags.VOLATILE);
        switch (primitiveType) {
            case BYTE: {
                return dirty ? (volatil ? new RandomAccessibleCacheLoader<T, ByteArray, DirtyVolatileByteArray>(grid, source, type, new ByteArray(0), a -> new DirtyVolatileByteArray(a.getCurrentStorageArray(), true)) : new RandomAccessibleCacheLoader<T, ByteArray, DirtyByteArray>(grid, source, type, new ByteArray(0), a -> new DirtyByteArray(a.getCurrentStorageArray()))) : (volatil ? new RandomAccessibleCacheLoader<T, ByteArray, VolatileByteArray>(grid, source, type, new ByteArray(0), a -> new VolatileByteArray(a.getCurrentStorageArray(), true)) : new RandomAccessibleCacheLoader<T, ByteArray, ByteArray>(grid, source, type, new ByteArray(0), a -> a));
            }
            case CHAR: {
                return dirty ? (volatil ? new RandomAccessibleCacheLoader<T, CharArray, DirtyVolatileCharArray>(grid, source, type, new CharArray(0), a -> new DirtyVolatileCharArray(a.getCurrentStorageArray(), true)) : new RandomAccessibleCacheLoader<T, CharArray, DirtyCharArray>(grid, source, type, new CharArray(0), a -> new DirtyCharArray(a.getCurrentStorageArray()))) : (volatil ? new RandomAccessibleCacheLoader<T, CharArray, VolatileCharArray>(grid, source, type, new CharArray(0), a -> new VolatileCharArray(a.getCurrentStorageArray(), true)) : new RandomAccessibleCacheLoader<T, CharArray, CharArray>(grid, source, type, new CharArray(0), a -> a));
            }
            case DOUBLE: {
                return dirty ? (volatil ? new RandomAccessibleCacheLoader<T, DoubleArray, DirtyVolatileDoubleArray>(grid, source, type, new DoubleArray(0), a -> new DirtyVolatileDoubleArray(a.getCurrentStorageArray(), true)) : new RandomAccessibleCacheLoader<T, DoubleArray, DirtyDoubleArray>(grid, source, type, new DoubleArray(0), a -> new DirtyDoubleArray(a.getCurrentStorageArray()))) : (volatil ? new RandomAccessibleCacheLoader<T, DoubleArray, VolatileDoubleArray>(grid, source, type, new DoubleArray(0), a -> new VolatileDoubleArray(a.getCurrentStorageArray(), true)) : new RandomAccessibleCacheLoader<T, DoubleArray, DoubleArray>(grid, source, type, new DoubleArray(0), a -> a));
            }
            case FLOAT: {
                return dirty ? (volatil ? new RandomAccessibleCacheLoader<T, FloatArray, DirtyVolatileFloatArray>(grid, source, type, new FloatArray(0), a -> new DirtyVolatileFloatArray(a.getCurrentStorageArray(), true)) : new RandomAccessibleCacheLoader<T, FloatArray, DirtyFloatArray>(grid, source, type, new FloatArray(0), a -> new DirtyFloatArray(a.getCurrentStorageArray()))) : (volatil ? new RandomAccessibleCacheLoader<T, FloatArray, VolatileFloatArray>(grid, source, type, new FloatArray(0), a -> new VolatileFloatArray(a.getCurrentStorageArray(), true)) : new RandomAccessibleCacheLoader<T, FloatArray, FloatArray>(grid, source, type, new FloatArray(0), a -> a));
            }
            case INT: {
                return dirty ? (volatil ? new RandomAccessibleCacheLoader<T, IntArray, DirtyVolatileIntArray>(grid, source, type, new IntArray(0), a -> new DirtyVolatileIntArray(a.getCurrentStorageArray(), true)) : new RandomAccessibleCacheLoader<T, IntArray, DirtyIntArray>(grid, source, type, new IntArray(0), a -> new DirtyIntArray(a.getCurrentStorageArray()))) : (volatil ? new RandomAccessibleCacheLoader<T, IntArray, VolatileIntArray>(grid, source, type, new IntArray(0), a -> new VolatileIntArray(a.getCurrentStorageArray(), true)) : new RandomAccessibleCacheLoader<T, IntArray, IntArray>(grid, source, type, new IntArray(0), a -> a));
            }
            case LONG: {
                return dirty ? (volatil ? new RandomAccessibleCacheLoader<T, LongArray, DirtyVolatileLongArray>(grid, source, type, new LongArray(0), a -> new DirtyVolatileLongArray(a.getCurrentStorageArray(), true)) : new RandomAccessibleCacheLoader<T, LongArray, DirtyLongArray>(grid, source, type, new LongArray(0), a -> new DirtyLongArray(a.getCurrentStorageArray()))) : (volatil ? new RandomAccessibleCacheLoader<T, LongArray, VolatileLongArray>(grid, source, type, new LongArray(0), a -> new VolatileLongArray(a.getCurrentStorageArray(), true)) : new RandomAccessibleCacheLoader<T, LongArray, LongArray>(grid, source, type, new LongArray(0), a -> a));
            }
            case SHORT: {
                return dirty ? (volatil ? new RandomAccessibleCacheLoader<T, ShortArray, DirtyVolatileShortArray>(grid, source, type, new ShortArray(0), a -> new DirtyVolatileShortArray(a.getCurrentStorageArray(), true)) : new RandomAccessibleCacheLoader<T, ShortArray, DirtyShortArray>(grid, source, type, new ShortArray(0), a -> new DirtyShortArray(a.getCurrentStorageArray()))) : (volatil ? new RandomAccessibleCacheLoader<T, ShortArray, VolatileShortArray>(grid, source, type, new ShortArray(0), a -> new VolatileShortArray(a.getCurrentStorageArray(), true)) : new RandomAccessibleCacheLoader<T, ShortArray, ShortArray>(grid, source, type, new ShortArray(0), a -> a));
            }
        }
        return null;
    }

    private T createType(A access) {
        Object t = this.type.getNativeTypeFactory().createLinkedType(new NoImg(access));
        t.updateContainer(null);
        return t;
    }

    static class NoImg<T extends NativeType<T>, A>
    extends AbstractNativeImg<T, A> {
        private final A data;

        public NoImg(A data) {
            super(new long[]{1L}, new Fraction());
            this.data = data;
        }

        @Override
        public A update(Object updater) {
            return this.data;
        }

        @Override
        public ImgFactory<T> factory() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Img<T> copy() {
            throw new UnsupportedOperationException();
        }

        @Override
        public RandomAccess<T> randomAccess() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Cursor<T> cursor() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Cursor<T> localizingCursor() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object iterationOrder() {
            throw new UnsupportedOperationException();
        }
    }
}

