/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.loops;

import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.LongConsumer;
import net.imglib2.Cursor;
import net.imglib2.loops.ClassCopyProvider;
import net.imglib2.loops.ListUtils;
import net.imglib2.loops.LoopBuilder;

public final class FastCursorLoops {
    private static final List<ClassCopyProvider<LongConsumer>> factories = Arrays.asList(new ClassCopyProvider<LongConsumer>(OneCursorLoop.class, LongConsumer.class, new Class[0]), new ClassCopyProvider<LongConsumer>(TwoCursorLoop.class, LongConsumer.class, new Class[0]), new ClassCopyProvider<LongConsumer>(ThreeCursorLoop.class, LongConsumer.class, new Class[0]), new ClassCopyProvider<LongConsumer>(FourCursorLoop.class, LongConsumer.class, new Class[0]), new ClassCopyProvider<LongConsumer>(FiveCursorLoop.class, LongConsumer.class, new Class[0]), new ClassCopyProvider<LongConsumer>(SixCursorLoop.class, LongConsumer.class, new Class[0]));

    private FastCursorLoops() {
    }

    public static LongConsumer createLoop(Object action, List<? extends Cursor<?>> cursors) {
        Object[] arguments = ListUtils.concatAsArray(action, cursors);
        ClassCopyProvider<LongConsumer> factory = factories.get(cursors.size() - 1);
        List<Class> key = ListUtils.map(Object::getClass, arguments);
        return factory.newInstanceForKey(key, arguments);
    }

    public static class SixCursorLoop<A, B, C, D, E, F>
    implements LongConsumer {
        private final LoopBuilder.SixConsumer<A, B, C, D, E, F> action;
        private final Cursor<A> cursorA;
        private final Cursor<B> cursorB;
        private final Cursor<C> cursorC;
        private final Cursor<D> cursorD;
        private final Cursor<E> cursorE;
        private final Cursor<F> cursorF;

        public SixCursorLoop(LoopBuilder.SixConsumer<A, B, C, D, E, F> action, Cursor<A> cursorA, Cursor<B> cursorB, Cursor<C> cursorC, Cursor<D> cursorD, Cursor<E> cursorE, Cursor<F> cursorF) {
            this.action = action;
            this.cursorA = cursorA;
            this.cursorB = cursorB;
            this.cursorC = cursorC;
            this.cursorD = cursorD;
            this.cursorE = cursorE;
            this.cursorF = cursorF;
        }

        @Override
        public void accept(long n) {
            while (--n >= 0L) {
                this.action.accept(this.cursorA.next(), this.cursorB.next(), this.cursorC.next(), this.cursorD.next(), this.cursorE.next(), this.cursorF.next());
            }
        }
    }

    public static class FiveCursorLoop<A, B, C, D, E>
    implements LongConsumer {
        private final LoopBuilder.FiveConsumer<A, B, C, D, E> action;
        private final Cursor<A> cursorA;
        private final Cursor<B> cursorB;
        private final Cursor<C> cursorC;
        private final Cursor<D> cursorD;
        private final Cursor<E> cursorE;

        public FiveCursorLoop(LoopBuilder.FiveConsumer<A, B, C, D, E> action, Cursor<A> cursorA, Cursor<B> cursorB, Cursor<C> cursorC, Cursor<D> cursorD, Cursor<E> cursorE) {
            this.action = action;
            this.cursorA = cursorA;
            this.cursorB = cursorB;
            this.cursorC = cursorC;
            this.cursorD = cursorD;
            this.cursorE = cursorE;
        }

        @Override
        public void accept(long n) {
            while (--n >= 0L) {
                this.action.accept(this.cursorA.next(), this.cursorB.next(), this.cursorC.next(), this.cursorD.next(), this.cursorE.next());
            }
        }
    }

    public static class FourCursorLoop<A, B, C, D>
    implements LongConsumer {
        private final LoopBuilder.FourConsumer<A, B, C, D> action;
        private final Cursor<A> cursorA;
        private final Cursor<B> cursorB;
        private final Cursor<C> cursorC;
        private final Cursor<D> cursorD;

        public FourCursorLoop(LoopBuilder.FourConsumer<A, B, C, D> action, Cursor<A> cursorA, Cursor<B> cursorB, Cursor<C> cursorC, Cursor<D> cursorD) {
            this.action = action;
            this.cursorA = cursorA;
            this.cursorB = cursorB;
            this.cursorC = cursorC;
            this.cursorD = cursorD;
        }

        @Override
        public void accept(long n) {
            while (--n >= 0L) {
                this.action.accept(this.cursorA.next(), this.cursorB.next(), this.cursorC.next(), this.cursorD.next());
            }
        }
    }

    public static class ThreeCursorLoop<A, B, C>
    implements LongConsumer {
        private final LoopBuilder.TriConsumer<A, B, C> action;
        private final Cursor<A> cursorA;
        private final Cursor<B> cursorB;
        private final Cursor<C> cursorC;

        public ThreeCursorLoop(LoopBuilder.TriConsumer<A, B, C> action, Cursor<A> cursorA, Cursor<B> cursorB, Cursor<C> cursorC) {
            this.action = action;
            this.cursorA = cursorA;
            this.cursorB = cursorB;
            this.cursorC = cursorC;
        }

        @Override
        public void accept(long n) {
            while (--n >= 0L) {
                this.action.accept(this.cursorA.next(), this.cursorB.next(), this.cursorC.next());
            }
        }
    }

    public static class TwoCursorLoop<A, B>
    implements LongConsumer {
        private final BiConsumer<A, B> action;
        private final Cursor<A> cursorA;
        private final Cursor<B> cursorB;

        public TwoCursorLoop(BiConsumer<A, B> action, Cursor<A> cursorA, Cursor<B> cursorB) {
            this.action = action;
            this.cursorA = cursorA;
            this.cursorB = cursorB;
        }

        @Override
        public void accept(long n) {
            while (--n >= 0L) {
                this.action.accept(this.cursorA.next(), this.cursorB.next());
            }
        }
    }

    public static class OneCursorLoop<A>
    implements LongConsumer {
        private final Consumer<A> action;
        private final Cursor<A> cursorA;

        public OneCursorLoop(Consumer<A> action, Cursor<A> cursorA) {
            this.action = action;
            this.cursorA = cursorA;
        }

        @Override
        public void accept(long n) {
            while (--n >= 0L) {
                this.action.accept(this.cursorA.next());
            }
        }
    }
}

