/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.realtransform;

import java.util.function.Supplier;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPositionable;
import net.imglib2.RealRandomAccess;
import net.imglib2.RealRandomAccessible;
import net.imglib2.converter.Converters;
import net.imglib2.position.FunctionRandomAccessible;
import net.imglib2.realtransform.AffineGet;
import net.imglib2.realtransform.PositionFieldTransform;
import net.imglib2.realtransform.RealTransform;
import net.imglib2.realtransform.Scale;
import net.imglib2.realtransform.ScaleAndTranslation;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.view.Views;
import net.imglib2.view.composite.RealComposite;

public class DisplacementFieldTransform
extends PositionFieldTransform {
    protected final int numTargetDimensions;

    public DisplacementFieldTransform(RealRandomAccess<? extends RealLocalizable> displacementsAccess) {
        super(displacementsAccess);
        this.numTargetDimensions = ((RealLocalizable)this.access.get()).numDimensions() < this.access.numDimensions() ? ((RealLocalizable)this.access.get()).numDimensions() : this.access.numDimensions();
    }

    public DisplacementFieldTransform(RealRandomAccessible<? extends RealLocalizable> displacements) {
        super(displacements);
        this.numTargetDimensions = ((RealLocalizable)this.access.get()).numDimensions() < this.access.numDimensions() ? ((RealLocalizable)this.access.get()).numDimensions() : this.access.numDimensions();
    }

    public <T extends RealType<T>> DisplacementFieldTransform(RandomAccessibleInterval<T> displacements) {
        super(displacements);
        this.numTargetDimensions = ((RealLocalizable)this.access.get()).numDimensions() < this.access.numDimensions() ? ((RealLocalizable)this.access.get()).numDimensions() : this.access.numDimensions();
    }

    public <T extends RealType<T>> DisplacementFieldTransform(RandomAccessibleInterval<T> displacements, AffineGet pixelToPhysical) {
        super(displacements, pixelToPhysical);
        this.numTargetDimensions = ((RealLocalizable)this.access.get()).numDimensions() < this.access.numDimensions() ? ((RealLocalizable)this.access.get()).numDimensions() : this.access.numDimensions();
    }

    public <T extends RealType<T>> DisplacementFieldTransform(RandomAccessibleInterval<T> displacements, double ... spacing) {
        super(displacements, spacing);
        this.numTargetDimensions = ((RealLocalizable)this.access.get()).numDimensions() < this.access.numDimensions() ? ((RealLocalizable)this.access.get()).numDimensions() : this.access.numDimensions();
    }

    public <T extends RealType<T>> DisplacementFieldTransform(RandomAccessibleInterval<T> displacements, double[] spacing, double[] offset) {
        super(displacements, spacing, offset);
        this.numTargetDimensions = ((RealLocalizable)this.access.get()).numDimensions() < this.access.numDimensions() ? ((RealLocalizable)this.access.get()).numDimensions() : this.access.numDimensions();
    }

    @Override
    public int numTargetDimensions() {
        return this.numTargetDimensions;
    }

    @Override
    public void apply(double[] source, double[] target) {
        this.access.setPosition(source);
        RealLocalizable comp = (RealLocalizable)this.access.get();
        for (int d = 0; d < this.numTargetDimensions(); ++d) {
            target[d] = comp.getDoublePosition(d) + source[d];
        }
    }

    @Override
    public void apply(float[] source, float[] target) {
        this.access.setPosition(source);
        RealLocalizable comp = (RealLocalizable)this.access.get();
        for (int d = 0; d < this.numTargetDimensions(); ++d) {
            target[d] = comp.getFloatPosition(d) + source[d];
        }
    }

    @Override
    public void apply(RealLocalizable source, RealPositionable target) {
        this.access.setPosition(source);
        RealLocalizable comp = (RealLocalizable)this.access.get();
        for (int d = 0; d < this.numTargetDimensions(); ++d) {
            target.setPosition(comp.getDoublePosition(d) + source.getDoublePosition(d), d);
        }
    }

    @Override
    public RealTransform copy() {
        return new DisplacementFieldTransform((RealRandomAccess<? extends RealLocalizable>)this.access.copy());
    }

    public static RandomAccessibleInterval<DoubleType> createDisplacementField(RealTransform transform, Interval interval, double[] spacing) {
        return DisplacementFieldTransform.createDisplacementField(transform, interval, new Scale(spacing), () -> DoubleType.createVector(transform.numTargetDimensions()));
    }

    public static RandomAccessibleInterval<DoubleType> createDisplacementField(RealTransform transform, Interval interval, double[] spacing, double[] offset) {
        return DisplacementFieldTransform.createDisplacementField(transform, interval, new ScaleAndTranslation(spacing, offset), () -> DoubleType.createVector(transform.numTargetDimensions()));
    }

    public static <T extends RealType<T>> RandomAccessibleInterval<T> createDisplacementField(RealTransform transform, Interval interval, double[] spacing, double[] offset, Supplier<RealComposite<T>> supplier) {
        return DisplacementFieldTransform.createDisplacementField(transform, interval, new ScaleAndTranslation(spacing, offset), supplier);
    }

    public static <T extends RealType<T>> RandomAccessibleInterval<T> createDisplacementField(RealTransform transform, Interval interval, RealTransform gridTransform, Supplier<RealComposite<T>> supplier) {
        int nd = transform.numTargetDimensions();
        FunctionRandomAccessible<RealComposite<T>> transformedGrid = new FunctionRandomAccessible<RealComposite<T>>(nd, () -> {
            RealTransform copy = gridTransform.copy();
            return (x, y) -> copy.apply((RealLocalizable)x, (RealPositionable)y);
        }, supplier);
        RandomAccessible<RealComposite<T>> displacements = Converters.convert2(transformedGrid, () -> {
            RealTransform copy = transform.copy();
            return (x, y) -> {
                copy.apply((RealLocalizable)x, (RealPositionable)y);
                for (int d = 0; d < nd; ++d) {
                    y.move(-x.getDoublePosition(d), d);
                }
            };
        }, supplier);
        long[] dfieldDims = new long[interval.numDimensions() + 1];
        dfieldDims[0] = interval.numDimensions();
        for (int i = 0; i < interval.numDimensions(); ++i) {
            dfieldDims[i + 1] = interval.dimension(i);
        }
        return Views.interval(Views.interleave(displacements), new FinalInterval(dfieldDims));
    }
}

