/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.roi.boundary;

import net.imglib2.RandomAccessibleInterval;
import net.imglib2.converter.AbstractConvertedRandomAccess;
import net.imglib2.type.BooleanType;
import net.imglib2.type.logic.BoolType;

public final class BoundaryRandomAccess4<T extends BooleanType<T>>
extends AbstractConvertedRandomAccess<T, BoolType> {
    private final int n;
    private final long[] min;
    private final long[] max;
    private final BoolType type;

    public BoundaryRandomAccess4(RandomAccessibleInterval<T> sourceInterval) {
        super(sourceInterval.randomAccess());
        this.n = sourceInterval.numDimensions();
        this.min = new long[this.n];
        this.max = new long[this.n];
        sourceInterval.min(this.min);
        sourceInterval.max(this.max);
        this.type = new BoolType();
    }

    private BoundaryRandomAccess4(BoundaryRandomAccess4<T> ba) {
        super(ba.source.copyRandomAccess());
        this.n = ba.n;
        this.min = ba.min;
        this.max = ba.max;
        this.type = ba.type.copy();
    }

    @Override
    public BoolType get() {
        if (((BooleanType)this.source.get()).get()) {
            int d;
            for (d = 0; d < this.n; ++d) {
                long pos = this.getLongPosition(d);
                if (pos > this.min[d] && pos < this.max[d]) continue;
                this.type.set(true);
                return this.type;
            }
            for (d = 0; d < this.n; ++d) {
                this.bck(d);
                if (!((BooleanType)this.source.get()).get()) {
                    this.fwd(d);
                    this.type.set(true);
                    return this.type;
                }
                this.fwd(d);
                this.fwd(d);
                if (!((BooleanType)this.source.get()).get()) {
                    this.bck(d);
                    this.type.set(true);
                    return this.type;
                }
                this.bck(d);
            }
        }
        this.type.set(false);
        return this.type;
    }

    @Override
    public BoolType getType() {
        return this.type;
    }

    @Override
    public BoundaryRandomAccess4<T> copy() {
        return new BoundaryRandomAccess4<T>(this);
    }
}

