/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.roi.geom.real;

import java.util.Collection;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;
import net.imglib2.RealPointSampleList;
import net.imglib2.roi.geom.real.NNSRealPointCollection;
import net.imglib2.roi.geom.real.WritableRealPointCollection;

public class RealPointSampleListWritableRealPointCollection<L extends RealLocalizable>
extends NNSRealPointCollection<L>
implements WritableRealPointCollection<L> {
    public RealPointSampleListWritableRealPointCollection(Collection<L> points) {
        this(RealPointSampleListWritableRealPointCollection.createRPSL(points));
    }

    public RealPointSampleListWritableRealPointCollection(RealPointSampleList<L> points) {
        super(points);
    }

    @Override
    public void addPoint(L point) {
        if (point.numDimensions() != this.n) {
            throw new IllegalArgumentException("Point must have " + this.n + " dimensions");
        }
        double[] pos = new double[this.n];
        point.localize(pos);
        ((RealPointSampleList)this.points()).add(new RealPoint(pos), point);
    }

    private static final <R extends RealLocalizable> RealPointSampleList<R> createRPSL(Collection<R> points) {
        RealPointSampleList<RealLocalizable> rpsl = new RealPointSampleList<RealLocalizable>(((RealLocalizable)points.iterator().next()).numDimensions());
        for (RealLocalizable p : points) {
            rpsl.add(new RealPoint(p), p);
        }
        return rpsl;
    }
}

