/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.roi.geom.real;

import net.imglib2.RealLocalizable;
import net.imglib2.roi.BoundaryType;
import net.imglib2.roi.Masks;
import net.imglib2.roi.RealMaskRealInterval;
import net.imglib2.util.Util;

public interface SuperEllipsoid
extends RealMaskRealInterval {
    public double exponent();

    public double semiAxisLength(int var1);

    public RealLocalizable center();

    @Override
    default public Class<?> maskType() {
        return SuperEllipsoid.class;
    }

    @Override
    public boolean equals(Object var1);

    public static int hashCode(SuperEllipsoid ellipsoid) {
        int result = 22;
        for (int i = 0; i < ellipsoid.numDimensions(); ++i) {
            result = (int)((double)result + (13.0 * ellipsoid.center().getDoublePosition(i) + 13.0 * ellipsoid.semiAxisLength(i)));
        }
        result = (int)((double)result + ellipsoid.exponent());
        if (ellipsoid.boundaryType() == BoundaryType.CLOSED) {
            result += 5;
        } else if (ellipsoid.boundaryType() == BoundaryType.OPEN) {
            result += 8;
        }
        return result;
    }

    public static boolean equals(SuperEllipsoid ellipsoid1, SuperEllipsoid ellipsoid2) {
        if (ellipsoid1 == null && ellipsoid2 == null) {
            return true;
        }
        if (ellipsoid1 == null || ellipsoid2 == null || !Masks.sameTypesAndDimensions(ellipsoid1, ellipsoid2) || ellipsoid1.exponent() != ellipsoid2.exponent()) {
            return false;
        }
        for (int d = 0; d < ellipsoid1.numDimensions(); ++d) {
            if (ellipsoid1.semiAxisLength(d) == ellipsoid2.semiAxisLength(d)) continue;
            return false;
        }
        return Util.locationsEqual(ellipsoid1.center(), ellipsoid2.center());
    }
}

