/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.roi.util;

import net.imglib2.AbstractLocalizable;
import net.imglib2.Interval;
import net.imglib2.Localizable;
import net.imglib2.Positionable;
import net.imglib2.RealPositionable;
import net.imglib2.roi.util.PositionableLocalizable;

public class PositionableInterval
extends AbstractLocalizable
implements Positionable,
Interval {
    protected final long[] currentOffset;
    protected final long[] initialMin;
    protected final long[] initialMax;
    private final PositionableLocalizable origin;

    public PositionableInterval(Interval initial) {
        super(initial.numDimensions());
        this.currentOffset = new long[this.n];
        this.initialMin = new long[this.n];
        this.initialMax = new long[this.n];
        initial.min(this.initialMin);
        initial.max(this.initialMax);
        this.origin = new Origin();
    }

    protected PositionableInterval(PositionableInterval other) {
        super(other.numDimensions());
        this.currentOffset = (long[])other.currentOffset.clone();
        this.initialMin = (long[])other.initialMin.clone();
        this.initialMax = (long[])other.initialMax.clone();
        this.origin = new Origin();
    }

    public PositionableLocalizable origin() {
        return this.origin;
    }

    @Override
    public void fwd(int d) {
        int n = d;
        this.position[n] = this.position[n] + 1L;
        int n2 = d;
        this.currentOffset[n2] = this.currentOffset[n2] + 1L;
    }

    @Override
    public void bck(int d) {
        int n = d;
        this.position[n] = this.position[n] - 1L;
        int n2 = d;
        this.currentOffset[n2] = this.currentOffset[n2] - 1L;
    }

    @Override
    public void move(int distance, int d) {
        int n = d;
        this.position[n] = this.position[n] + (long)distance;
        int n2 = d;
        this.currentOffset[n2] = this.currentOffset[n2] + (long)distance;
    }

    @Override
    public void move(long distance, int d) {
        int n = d;
        this.position[n] = this.position[n] + distance;
        int n2 = d;
        this.currentOffset[n2] = this.currentOffset[n2] + distance;
    }

    @Override
    public void move(Localizable localizable) {
        int d = 0;
        while (d < this.n) {
            long distance = localizable.getLongPosition(d);
            int n = d;
            this.position[n] = this.position[n] + distance;
            int n2 = d++;
            this.currentOffset[n2] = this.currentOffset[n2] + distance;
        }
    }

    @Override
    public void move(int[] distance) {
        for (int d = 0; d < this.n; ++d) {
            int n = d;
            this.position[n] = this.position[n] + (long)distance[d];
            int n2 = d;
            this.currentOffset[n2] = this.currentOffset[n2] + (long)distance[d];
        }
    }

    @Override
    public void move(long[] distance) {
        for (int d = 0; d < this.n; ++d) {
            int n = d;
            this.position[n] = this.position[n] + distance[d];
            int n2 = d;
            this.currentOffset[n2] = this.currentOffset[n2] + distance[d];
        }
    }

    @Override
    public void setPosition(Localizable localizable) {
        int d = 0;
        while (d < this.n) {
            long distance = localizable.getLongPosition(d) - this.position[d];
            int n = d;
            this.position[n] = this.position[n] + distance;
            int n2 = d++;
            this.currentOffset[n2] = this.currentOffset[n2] + distance;
        }
    }

    @Override
    public void setPosition(int[] pos) {
        int d = 0;
        while (d < this.n) {
            long distance = (long)pos[d] - this.position[d];
            int n = d;
            this.position[n] = this.position[n] + distance;
            int n2 = d++;
            this.currentOffset[n2] = this.currentOffset[n2] + distance;
        }
    }

    @Override
    public void setPosition(long[] pos) {
        int d = 0;
        while (d < this.n) {
            long distance = pos[d] - this.position[d];
            int n = d;
            this.position[n] = this.position[n] + distance;
            int n2 = d++;
            this.currentOffset[n2] = this.currentOffset[n2] + distance;
        }
    }

    @Override
    public void setPosition(int pos, int d) {
        long distance = (long)pos - this.position[d];
        int n = d;
        this.position[n] = this.position[n] + distance;
        int n2 = d;
        this.currentOffset[n2] = this.currentOffset[n2] + distance;
    }

    @Override
    public void setPosition(long pos, int d) {
        long distance = pos - this.position[d];
        int n = d;
        this.position[n] = this.position[n] + distance;
        int n2 = d;
        this.currentOffset[n2] = this.currentOffset[n2] + distance;
    }

    @Override
    public double realMin(int d) {
        return this.currentOffset[d] + this.initialMin[d];
    }

    @Override
    public void realMin(double[] min) {
        for (int d = 0; d < this.n; ++d) {
            min[d] = this.currentOffset[d] + this.initialMin[d];
        }
    }

    @Override
    public void realMin(RealPositionable min) {
        for (int d = 0; d < this.n; ++d) {
            min.setPosition(this.currentOffset[d] + this.initialMin[d], d);
        }
    }

    @Override
    public double realMax(int d) {
        return this.currentOffset[d] + this.initialMax[d];
    }

    @Override
    public void realMax(double[] max) {
        for (int d = 0; d < this.n; ++d) {
            max[d] = this.currentOffset[d] + this.initialMax[d];
        }
    }

    @Override
    public void realMax(RealPositionable max) {
        for (int d = 0; d < this.n; ++d) {
            max.setPosition(this.currentOffset[d] + this.initialMax[d], d);
        }
    }

    @Override
    public long min(int d) {
        return this.currentOffset[d] + this.initialMin[d];
    }

    @Override
    public void min(long[] min) {
        for (int d = 0; d < this.n; ++d) {
            min[d] = this.currentOffset[d] + this.initialMin[d];
        }
    }

    @Override
    public void min(Positionable min) {
        for (int d = 0; d < this.n; ++d) {
            min.setPosition(this.currentOffset[d] + this.initialMin[d], d);
        }
    }

    @Override
    public long max(int d) {
        return this.currentOffset[d] + this.initialMax[d];
    }

    @Override
    public void max(long[] max) {
        for (int d = 0; d < this.n; ++d) {
            max[d] = this.currentOffset[d] + this.initialMax[d];
        }
    }

    @Override
    public void max(Positionable max) {
        for (int d = 0; d < this.n; ++d) {
            max.setPosition(this.currentOffset[d] + this.initialMax[d], d);
        }
    }

    @Override
    public void dimensions(long[] dimensions) {
        for (int d = 0; d < this.n; ++d) {
            dimensions[d] = this.initialMax[d] - this.initialMin[d] + 1L;
        }
    }

    @Override
    public long dimension(int d) {
        return this.initialMax[d] - this.initialMin[d] + 1L;
    }

    public String toString() {
        int d;
        StringBuilder sb = new StringBuilder();
        String className = this.getClass().getSimpleName();
        sb.append(className);
        sb.append(" [(");
        for (d = 0; d < this.n; ++d) {
            sb.append(this.min(d));
            if (d >= this.n - 1) continue;
            sb.append(", ");
        }
        sb.append(") -- (");
        for (d = 0; d < this.n; ++d) {
            sb.append(this.max(d));
            if (d >= this.n - 1) continue;
            sb.append(", ");
        }
        sb.append(") = ");
        for (d = 0; d < this.n; ++d) {
            sb.append(this.dimension(d));
            if (d >= this.n - 1) continue;
            sb.append("x");
        }
        sb.append(", pos=(");
        for (d = 0; d < this.n; ++d) {
            sb.append(this.getLongPosition(d));
            if (d >= this.n - 1) continue;
            sb.append(", ");
        }
        sb.append("), origin(");
        for (d = 0; d < this.n; ++d) {
            sb.append(this.origin().getLongPosition(d));
            if (d >= this.n - 1) continue;
            sb.append(", ");
        }
        sb.append(")]");
        return sb.toString();
    }

    private class Origin
    implements PositionableLocalizable {
        private Origin() {
        }

        @Override
        public int numDimensions() {
            return PositionableInterval.this.n;
        }

        @Override
        public void localize(float[] pos) {
            for (int d = 0; d < PositionableInterval.this.n; ++d) {
                pos[d] = PositionableInterval.this.position[d] - PositionableInterval.this.currentOffset[d] - PositionableInterval.this.initialMin[d];
            }
        }

        @Override
        public void localize(double[] pos) {
            for (int d = 0; d < PositionableInterval.this.n; ++d) {
                pos[d] = PositionableInterval.this.position[d] - PositionableInterval.this.currentOffset[d] - PositionableInterval.this.initialMin[d];
            }
        }

        @Override
        public float getFloatPosition(int d) {
            return PositionableInterval.this.position[d] - PositionableInterval.this.currentOffset[d] - PositionableInterval.this.initialMin[d];
        }

        @Override
        public double getDoublePosition(int d) {
            return PositionableInterval.this.position[d] - PositionableInterval.this.currentOffset[d] - PositionableInterval.this.initialMin[d];
        }

        @Override
        public void localize(int[] pos) {
            for (int d = 0; d < PositionableInterval.this.n; ++d) {
                pos[d] = (int)(PositionableInterval.this.position[d] - PositionableInterval.this.currentOffset[d] - PositionableInterval.this.initialMin[d]);
            }
        }

        @Override
        public void localize(long[] pos) {
            for (int d = 0; d < PositionableInterval.this.n; ++d) {
                pos[d] = PositionableInterval.this.position[d] - PositionableInterval.this.currentOffset[d] - PositionableInterval.this.initialMin[d];
            }
        }

        @Override
        public int getIntPosition(int d) {
            return (int)(PositionableInterval.this.position[d] - PositionableInterval.this.currentOffset[d] - PositionableInterval.this.initialMin[d]);
        }

        @Override
        public long getLongPosition(int d) {
            return PositionableInterval.this.position[d] - PositionableInterval.this.currentOffset[d] - PositionableInterval.this.initialMin[d];
        }

        @Override
        public void fwd(int d) {
            int n = d;
            PositionableInterval.this.currentOffset[n] = PositionableInterval.this.currentOffset[n] - 1L;
        }

        @Override
        public void bck(int d) {
            int n = d;
            PositionableInterval.this.currentOffset[n] = PositionableInterval.this.currentOffset[n] + 1L;
        }

        @Override
        public void move(int distance, int d) {
            this.move((long)distance, d);
        }

        @Override
        public void move(long distance, int d) {
            int n = d;
            PositionableInterval.this.currentOffset[n] = PositionableInterval.this.currentOffset[n] - distance;
        }

        @Override
        public void move(Localizable localizable) {
            for (int d = 0; d < PositionableInterval.this.n; ++d) {
                this.move(localizable.getLongPosition(d), d);
            }
        }

        @Override
        public void move(int[] distance) {
            for (int d = 0; d < PositionableInterval.this.n; ++d) {
                this.move(distance[d], d);
            }
        }

        @Override
        public void move(long[] distance) {
            for (int d = 0; d < PositionableInterval.this.n; ++d) {
                this.move(distance[d], d);
            }
        }

        @Override
        public void setPosition(Localizable localizable) {
            for (int d = 0; d < PositionableInterval.this.n; ++d) {
                this.setPosition(localizable.getLongPosition(d), d);
            }
        }

        @Override
        public void setPosition(int[] pos) {
            for (int d = 0; d < PositionableInterval.this.n; ++d) {
                this.setPosition(pos[d], d);
            }
        }

        @Override
        public void setPosition(long[] pos) {
            for (int d = 0; d < PositionableInterval.this.n; ++d) {
                this.setPosition(pos[d], d);
            }
        }

        @Override
        public void setPosition(int pos, int d) {
            this.setPosition((long)pos, d);
        }

        @Override
        public void setPosition(long pos, int d) {
            long distance = pos - PositionableInterval.this.position[d] + PositionableInterval.this.currentOffset[d] + PositionableInterval.this.initialMin[d];
            this.move(distance, d);
        }
    }
}

