/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.transform.integer.permutation;

import net.imglib2.transform.InvertibleTransform;

public abstract class AbstractPermutationTransform
implements InvertibleTransform {
    protected final int[] lut;
    protected final int[] inverseLut;

    public AbstractPermutationTransform(int[] lut) {
        this.lut = (int[])lut.clone();
        this.inverseLut = new int[lut.length];
        for (int i = 0; i < lut.length; ++i) {
            this.inverseLut[lut[i]] = i;
        }
    }

    public int apply(int x) {
        return this.lut[x];
    }

    public long applyChecked(int x) {
        if (x < 0) {
            return -9223372036854775807L;
        }
        if (x >= this.lut.length) {
            return Long.MAX_VALUE;
        }
        return this.apply(x);
    }

    public int applyInverse(int y) {
        return this.inverseLut[y];
    }

    public long applyInverseChecked(int y) {
        if (y < 0) {
            return -9223372036854775807L;
        }
        if (y >= this.lut.length) {
            return Long.MAX_VALUE;
        }
        return this.applyInverse(y);
    }

    public int[] getLutCopy() {
        return (int[])this.lut.clone();
    }

    public int[] getInverseLutCopy() {
        return (int[])this.inverseLut.clone();
    }

    public static final boolean checkBijectivity(int[] lut) {
        int[] inverseLut = new int[lut.length];
        try {
            int i;
            for (i = 0; i < lut.length; ++i) {
                inverseLut[i] = -1;
            }
            for (i = 0; i < lut.length; ++i) {
                inverseLut[lut[i]] = i;
            }
            for (i = 0; i < lut.length; ++i) {
                if (inverseLut[i] != -1) continue;
                return false;
            }
            return true;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return false;
        }
    }
}

