/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.type.logic;

import java.math.BigInteger;
import net.imglib2.img.NativeImg;
import net.imglib2.img.basictypeaccess.LongAccess;
import net.imglib2.img.basictypeaccess.array.LongArray;
import net.imglib2.type.BooleanType;
import net.imglib2.type.Index;
import net.imglib2.type.NativeType;
import net.imglib2.type.NativeTypeFactory;
import net.imglib2.type.numeric.IntegerType;
import net.imglib2.type.numeric.integer.AbstractIntegerType;
import net.imglib2.util.Fraction;
import net.imglib2.util.Util;

public class BitType
extends AbstractIntegerType<BitType>
implements BooleanType<BitType>,
NativeType<BitType>,
IntegerType<BitType> {
    protected final Index i = new Index();
    protected final NativeImg<?, ? extends LongAccess> img;
    protected LongAccess dataAccess;
    private static final NativeTypeFactory<BitType, LongAccess> typeFactory = NativeTypeFactory.LONG(BitType::new);

    public BitType(NativeImg<?, ? extends LongAccess> bitStorage) {
        this.img = bitStorage;
    }

    public BitType(boolean value) {
        this((NativeImg)null);
        this.dataAccess = new LongArray(1);
        this.set(value);
    }

    public BitType(LongAccess access) {
        this((NativeImg)null);
        this.dataAccess = access;
    }

    public BitType() {
        this(false);
    }

    @Override
    public void updateContainer(Object c) {
        this.dataAccess = this.img.update(c);
    }

    @Override
    public Index index() {
        return this.i;
    }

    @Override
    public BitType duplicateTypeOnSameNativeImg() {
        return new BitType(this.img);
    }

    @Override
    public NativeTypeFactory<BitType, LongAccess> getNativeTypeFactory() {
        return typeFactory;
    }

    @Override
    public boolean get() {
        int j = this.i.get();
        return 1L == (this.dataAccess.getValue(j >>> 6) >>> (j & 0x3F) & 1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(boolean value) {
        int j = this.i.get();
        int i1 = j >>> 6;
        long bit = 1L << (j & 0x3F);
        LongAccess longAccess = this.dataAccess;
        synchronized (longAccess) {
            if (value) {
                this.dataAccess.setValue(i1, this.dataAccess.getValue(i1) | bit);
            } else {
                this.dataAccess.setValue(i1, this.dataAccess.getValue(i1) & (bit ^ 0xFFFFFFFFFFFFFFFFL));
            }
        }
    }

    @Override
    public int getInteger() {
        return this.get() ? 1 : 0;
    }

    @Override
    public long getIntegerLong() {
        return this.get() ? 1L : 0L;
    }

    @Override
    public BigInteger getBigInteger() {
        return this.get() ? BigInteger.ONE : BigInteger.ZERO;
    }

    @Override
    public void setInteger(int f) {
        if (f >= 1) {
            this.set(true);
        } else {
            this.set(false);
        }
    }

    @Override
    public void setInteger(long f) {
        if (f >= 1L) {
            this.set(true);
        } else {
            this.set(false);
        }
    }

    @Override
    public void setBigInteger(BigInteger b) {
        if (b.compareTo(BigInteger.ZERO) > 0) {
            this.set(true);
        } else {
            this.set(false);
        }
    }

    @Override
    public double getMaxValue() {
        return 1.0;
    }

    @Override
    public double getMinValue() {
        return 0.0;
    }

    @Override
    public void set(BitType c) {
        this.set(c.get());
    }

    @Override
    public void and(BitType c) {
        this.set(this.get() && c.get());
    }

    @Override
    public void or(BitType c) {
        this.set(this.get() || c.get());
    }

    @Override
    public void xor(BitType c) {
        this.set(this.get() ^ c.get());
    }

    @Override
    public void not() {
        this.set(!this.get());
    }

    @Override
    public void add(BitType c) {
        this.xor(c);
    }

    @Override
    public void div(BitType c) {
        this.and(c);
    }

    @Override
    public void mul(BitType c) {
        this.and(c);
    }

    @Override
    public void sub(BitType c) {
        this.xor(c);
    }

    @Override
    public void mul(float c) {
        if (c >= 0.5f) {
            this.set(this.get());
        } else {
            this.set(false);
        }
    }

    @Override
    public void mul(double c) {
        if (c >= 0.5) {
            this.set(this.get());
        } else {
            this.set(false);
        }
    }

    @Override
    public void setOne() {
        this.set(true);
    }

    @Override
    public void setZero() {
        this.set(false);
    }

    @Override
    public void inc() {
        this.not();
    }

    @Override
    public void dec() {
        this.not();
    }

    @Override
    public BitType createVariable() {
        return new BitType();
    }

    @Override
    public BitType copy() {
        return new BitType(this.dataAccess != null ? this.get() : false);
    }

    @Override
    public String toString() {
        boolean value = this.get();
        return value ? "1" : "0";
    }

    @Override
    public Fraction getEntitiesPerPixel() {
        return new Fraction(1L, 64L);
    }

    @Override
    public int getBitsPerPixel() {
        return 1;
    }

    @Override
    public int compareTo(BitType other) {
        return Boolean.compare(this.get(), other.get());
    }

    @Override
    public boolean valueEquals(BitType t) {
        return this.get() == t.get();
    }

    @Override
    public boolean equals(Object obj) {
        return Util.valueEqualsObject(this, obj);
    }

    @Override
    public int hashCode() {
        return Boolean.hashCode(this.get());
    }
}

