/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ui;

import net.imglib2.RandomAccessible;
import net.imglib2.RealRandomAccessible;
import net.imglib2.concatenate.Concatenable;
import net.imglib2.display.screenimage.awt.ARGBScreenImage;
import net.imglib2.realtransform.AffineGet;
import net.imglib2.realtransform.AffineSet;
import net.imglib2.realtransform.RealViews;
import net.imglib2.type.numeric.ARGBType;
import net.imglib2.ui.AbstractSimpleRenderer;
import net.imglib2.ui.AffineTransformType;
import net.imglib2.ui.PainterThread;
import net.imglib2.ui.RenderSource;
import net.imglib2.ui.RenderTarget;
import net.imglib2.ui.RendererFactory;
import net.imglib2.ui.SimpleInterruptibleProjector;

public class SimpleRenderer<A extends AffineGet & Concatenable<AffineGet>>
extends AbstractSimpleRenderer<A> {
    protected final RenderSource<?, A> source;

    public SimpleRenderer(AffineTransformType<A> transformType, RenderSource<?, A> source, RenderTarget display, PainterThread painterThread, boolean doubleBuffered, int numRenderingThreads) {
        super(transformType, display, painterThread, doubleBuffered, numRenderingThreads);
        this.source = source;
    }

    @Override
    protected SimpleInterruptibleProjector<?, ARGBType> createProjector(A viewerTransform, ARGBScreenImage target) {
        return SimpleRenderer.createProjector(this.transformType, this.source, viewerTransform, target, this.numRenderingThreads);
    }

    protected static <T, A extends AffineGet & Concatenable<AffineGet>> SimpleInterruptibleProjector<T, ARGBType> createProjector(AffineTransformType<A> transformType, RenderSource<T, A> source, A viewerTransform, ARGBScreenImage screenImage, int numRenderingThreads) {
        return new SimpleInterruptibleProjector<T, ARGBType>(SimpleRenderer.getTransformedSource(transformType, source, viewerTransform), source.getConverter(), screenImage, numRenderingThreads);
    }

    protected static <T, A extends AffineGet & Concatenable<AffineGet>> RandomAccessible<T> getTransformedSource(AffineTransformType<A> transformType, RenderSource<T, A> source, A viewerTransform) {
        RealRandomAccessible<T> img = source.getInterpolatedSource();
        AffineGet sourceToScreen = (AffineGet)transformType.createTransform();
        transformType.set(sourceToScreen, viewerTransform);
        ((Concatenable)((Object)sourceToScreen)).concatenate(source.getSourceTransform());
        return RealViews.affine(img, sourceToScreen);
    }

    public static class Factory<A extends AffineSet & AffineGet>
    implements RendererFactory<A> {
        final AffineTransformType<A> transformType;
        final RenderSource<?, A> source;
        protected final boolean doubleBuffered;
        protected final int numRenderingThreads;

        public Factory(AffineTransformType<A> transformType, RenderSource<?, A> source, boolean doubleBuffered, int numRenderingThreads) {
            this.transformType = transformType;
            this.source = source;
            this.doubleBuffered = doubleBuffered;
            this.numRenderingThreads = numRenderingThreads;
        }

        @Override
        public SimpleRenderer<A> create(RenderTarget display, PainterThread painterThread) {
            return new SimpleRenderer<A>(this.transformType, this.source, display, painterThread, this.doubleBuffered, this.numRenderingThreads);
        }
    }
}

